/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.KlassKlass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class ArrayKlassKlass
extends KlassKlass {
    private static long headerSize;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("arrayKlassKlass");
        headerSize = type.getSize() + Oop.getHeaderSize();
    }

    ArrayKlassKlass(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    @Override
    public long getObjectSize() {
        return ArrayKlassKlass.alignObjectSize(headerSize);
    }

    @Override
    public void printValueOn(PrintStream tty) {
        tty.print("ArrayKlassKlass");
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ArrayKlassKlass.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

