/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Point;
import java.io.IOException;
import sun.awt.X11.MotifDnDConstants;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDropTargetEventProcessor;
import sun.awt.X11.XDropTargetProtocol;
import sun.awt.X11.XDropTargetProtocolListener;
import sun.awt.X11.XDropTargetRegistry;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XException;
import sun.awt.X11.XSelection;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

class MotifDnDDropTargetProtocol
extends XDropTargetProtocol {
    private static final Unsafe unsafe = XlibWrapper.unsafe;
    private long sourceWindow = 0L;
    private long sourceWindowMask = 0L;
    private int sourceProtocolVersion = 0;
    private int sourceActions = 0;
    private long[] sourceFormats = null;
    private long sourceAtom = 0L;
    private int userAction = 0;
    private int sourceX = 0;
    private int sourceY = 0;
    private XWindow targetXWindow = null;
    private boolean topLevelLeavePostponed = false;

    protected MotifDnDDropTargetProtocol(XDropTargetProtocolListener xDropTargetProtocolListener) {
        super(xDropTargetProtocolListener);
    }

    static XDropTargetProtocol createInstance(XDropTargetProtocolListener xDropTargetProtocolListener) {
        return new MotifDnDDropTargetProtocol(xDropTargetProtocolListener);
    }

    public String getProtocolName() {
        return "MotifDnD";
    }

    public void registerDropTarget(long l) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        MotifDnDConstants.writeDragReceiverInfoStruct(l);
    }

    public void unregisterDropTarget(long l) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        MotifDnDConstants.XA_MOTIF_ATOM_0.DeleteProperty(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEmbedderDropSite(long l) {
        WindowPropertyGetter windowPropertyGetter;
        long l2;
        long l3;
        int n;
        boolean bl;
        block11: {
            assert (XToolkit.isAWTLockHeldByCurrentThread());
            bl = false;
            n = 0;
            l3 = 0L;
            long l4 = XDropTargetRegistry.getDnDProxyWindow();
            int n2 = 0;
            l2 = 0L;
            int n3 = 16;
            windowPropertyGetter = new WindowPropertyGetter(l, MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO, 0L, 65535L, false, 0L);
            try {
                n2 = windowPropertyGetter.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                if (n2 == 0 && windowPropertyGetter.getData() != 0L && windowPropertyGetter.getActualType() != 0L && windowPropertyGetter.getActualFormat() == 8 && windowPropertyGetter.getNumberOfItems() >= 16) {
                    bl = true;
                    l2 = windowPropertyGetter.getData();
                    n3 = windowPropertyGetter.getNumberOfItems();
                    byte by = unsafe.getByte(l2);
                    int n4 = unsafe.getInt(l2 + 4L);
                    if (by != MotifDnDConstants.getByteOrderByte()) {
                        n4 = MotifDnDConstants.Swapper.swap(n4);
                    }
                    if ((l3 = (long)n4) == l4) {
                        Object var17_12 = null;
                        if (!bl) {
                            unsafe.freeMemory(l2);
                            l2 = 0L;
                        }
                        windowPropertyGetter.dispose();
                        return;
                    }
                    n4 = (int)l4;
                    if (by != MotifDnDConstants.getByteOrderByte()) {
                        n4 = MotifDnDConstants.Swapper.swap(n4);
                    }
                    unsafe.putInt(l2 + 4L, n4);
                } else {
                    l2 = unsafe.allocateMemory(n3);
                    unsafe.putByte(l2, MotifDnDConstants.getByteOrderByte());
                    unsafe.putByte(l2 + 1L, (byte)0);
                    unsafe.putByte(l2 + 2L, (byte)5);
                    unsafe.putByte(l2 + 3L, (byte)0);
                    unsafe.putInt(l2 + 4L, (int)l4);
                    unsafe.putShort(l2 + 8L, (short)0);
                    unsafe.putShort(l2 + 10L, (short)0);
                    unsafe.putInt(l2 + 12L, n3);
                }
                XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
                XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l, MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO.getAtom(), MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO.getAtom(), 8, 0, l2, n3);
                XToolkit.RESTORE_XERROR_HANDLER();
                if (XToolkit.saved_error == null || XToolkit.saved_error.get_error_code() == 0) break block11;
                throw new XException("Cannot write Motif receiver info property");
            }
            catch (Throwable throwable) {
                Object var17_14 = null;
                if (!bl) {
                    unsafe.freeMemory(l2);
                    l2 = 0L;
                }
                windowPropertyGetter.dispose();
                throw throwable;
            }
        }
        Object var17_13 = null;
        if (!bl) {
            unsafe.freeMemory(l2);
            l2 = 0L;
        }
        windowPropertyGetter.dispose();
        this.putEmbedderRegistryEntry(l, bl, n, l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEmbedderDropSite(long l) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        XDropTargetProtocol.EmbedderRegistryEntry embedderRegistryEntry = this.getEmbedderRegistryEntry(l);
        if (embedderRegistryEntry == null) {
            return;
        }
        if (embedderRegistryEntry.isOverriden()) {
            int n = 0;
            WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l, MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO, 0L, 65535L, false, 0L);
            try {
                n = windowPropertyGetter.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                if (n == 0 && windowPropertyGetter.getData() != 0L && windowPropertyGetter.getActualType() != 0L && windowPropertyGetter.getActualFormat() == 8 && windowPropertyGetter.getNumberOfItems() >= 16) {
                    int n2 = 16;
                    long l2 = windowPropertyGetter.getData();
                    byte by = unsafe.getByte(l2);
                    int n3 = (int)embedderRegistryEntry.getProxy();
                    if (MotifDnDConstants.getByteOrderByte() != by) {
                        n3 = MotifDnDConstants.Swapper.swap(n3);
                    }
                    unsafe.putInt(l2 + 4L, n3);
                    XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
                    XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l, MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO.getAtom(), MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO.getAtom(), 8, 0, l2, n2);
                    XToolkit.RESTORE_XERROR_HANDLER();
                    if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                        throw new XException("Cannot write Motif receiver info property");
                    }
                }
                Object var12_9 = null;
                windowPropertyGetter.dispose();
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                windowPropertyGetter.dispose();
                throw throwable;
            }
        } else {
            MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO.DeleteProperty(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEmbeddedDropSite(long l) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        boolean bl = false;
        int n = 0;
        long l2 = 0L;
        int n2 = 0;
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l, MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO, 0L, 65535L, false, 0L);
        try {
            n2 = windowPropertyGetter.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
            if (n2 == 0 && windowPropertyGetter.getData() != 0L && windowPropertyGetter.getActualType() != 0L && windowPropertyGetter.getActualFormat() == 8 && windowPropertyGetter.getNumberOfItems() >= 16) {
                bl = true;
                long l3 = windowPropertyGetter.getData();
                byte by = unsafe.getByte(l3);
                int n3 = unsafe.getInt(l3 + 4L);
                if (by != MotifDnDConstants.getByteOrderByte()) {
                    n3 = MotifDnDConstants.Swapper.swap(n3);
                }
                l2 = n3;
            }
            Object var14_10 = null;
            windowPropertyGetter.dispose();
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            windowPropertyGetter.dispose();
            throw throwable;
        }
        this.putEmbedderRegistryEntry(l, bl, n, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProtocolSupported(long l) {
        WindowPropertyGetter windowPropertyGetter;
        block3: {
            windowPropertyGetter = new WindowPropertyGetter(l, MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO, 0L, 65535L, false, 0L);
            try {
                int n = windowPropertyGetter.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                if (n != 0 || windowPropertyGetter.getData() == 0L || windowPropertyGetter.getActualType() == 0L || windowPropertyGetter.getActualFormat() != 8 || windowPropertyGetter.getNumberOfItems() < 16) break block3;
                boolean bl = true;
                Object var7_6 = null;
                windowPropertyGetter.dispose();
                return bl;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                windowPropertyGetter.dispose();
                throw throwable;
            }
        }
        boolean bl = false;
        Object var7_7 = null;
        windowPropertyGetter.dispose();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processTopLevelEnter(XClientMessageEvent xClientMessageEvent) {
        int n;
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        if (this.targetXWindow != null || this.sourceWindow != 0L) {
            return false;
        }
        if (!(XToolkit.windowToXWindow(xClientMessageEvent.get_window()) instanceof XWindow) && this.getEmbedderRegistryEntry(xClientMessageEvent.get_window()) == null) {
            return false;
        }
        long l = 0L;
        long l2 = 0L;
        byte by = 0;
        long l3 = 0L;
        long[] lArray = null;
        long l4 = xClientMessageEvent.get_data();
        byte by2 = unsafe.getByte(l4 + 1L);
        l = MotifDnDConstants.Swapper.getInt(l4 + 8L, by2);
        l3 = MotifDnDConstants.Swapper.getInt(l4 + 12L, by2);
        Object object = new WindowPropertyGetter(l, XAtom.get(l3), 0L, 65535L, false, MotifDnDConstants.XA_MOTIF_DRAG_INITIATOR_INFO.getAtom());
        try {
            n = ((WindowPropertyGetter)object).execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
            if (n == 0 && ((WindowPropertyGetter)object).getData() != 0L && ((WindowPropertyGetter)object).getActualType() == MotifDnDConstants.XA_MOTIF_DRAG_INITIATOR_INFO.getAtom() && ((WindowPropertyGetter)object).getActualFormat() == 8 && ((WindowPropertyGetter)object).getNumberOfItems() == 8) {
                long l5 = ((WindowPropertyGetter)object).getData();
                byte by3 = unsafe.getByte(l5);
                by = unsafe.getByte(l5 + 1L);
                if (by != 0) {
                    boolean bl = false;
                    Object var17_15 = null;
                    ((WindowPropertyGetter)object).dispose();
                    return bl;
                }
                short s = MotifDnDConstants.Swapper.getShort(l5 + 2L, by3);
                lArray = MotifDnDConstants.getTargetListForIndex(s);
            } else {
                lArray = new long[]{};
            }
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            ((WindowPropertyGetter)object).dispose();
            throw throwable;
        }
        Object var17_16 = null;
        ((WindowPropertyGetter)object).dispose();
        object = new XWindowAttributes();
        try {
            XToolkit.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
            n = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l, ((XWindowAttributes)object).pData);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (n == 0 || XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("XGetWindowAttributes failed");
            }
            l2 = ((XWindowAttributes)object).get_your_event_mask();
            Object var19_19 = null;
            ((XWindowAttributes)object).dispose();
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            ((XWindowAttributes)object).dispose();
            throw throwable;
        }
        XToolkit.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
        XlibWrapper.XSelectInput(XToolkit.getDisplay(), l, l2 | 0x20000L);
        XToolkit.RESTORE_XERROR_HANDLER();
        if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
            throw new XException("XSelectInput failed");
        }
        this.sourceWindow = l;
        this.sourceWindowMask = l2;
        this.sourceProtocolVersion = by;
        this.sourceActions = 0;
        this.sourceFormats = lArray;
        this.sourceAtom = l3;
        return true;
    }

    private boolean processDragMotion(XClientMessageEvent xClientMessageEvent) {
        long l = xClientMessageEvent.get_data();
        byte by = unsafe.getByte(l + 1L);
        byte by2 = (byte)(unsafe.getByte(l) & 0x7F);
        int n = 0;
        int n2 = 0;
        short s = MotifDnDConstants.Swapper.getShort(l + 2L, by);
        int n3 = (s & 0xF) >> 0;
        int n4 = (s & 0xF00) >> 8;
        int n5 = MotifDnDConstants.getJavaActionsForMotifActions(n3);
        int n6 = MotifDnDConstants.getJavaActionsForMotifActions(n4);
        int n7 = (int)this.sourceWindow;
        if (by != MotifDnDConstants.getByteOrderByte()) {
            n7 = MotifDnDConstants.Swapper.swap(n7);
        }
        unsafe.putInt(l + 12L, n7);
        XWindow xWindow = null;
        Object object = XToolkit.windowToXWindow(xClientMessageEvent.get_window());
        if (object instanceof XWindow) {
            xWindow = (XWindow)object;
        }
        if (by2 == 8) {
            n = this.sourceX;
            n2 = this.sourceY;
            if (xWindow == null) {
                xWindow = this.targetXWindow;
            }
        } else {
            XBaseWindow xBaseWindow;
            long l2;
            n = MotifDnDConstants.Swapper.getShort(l + 8L, by);
            n2 = MotifDnDConstants.Swapper.getShort(l + 10L, by);
            if (xWindow == null && (l2 = XDropTargetRegistry.getRegistry().getEmbeddedDropSite(xClientMessageEvent.get_window(), n, n2)) != 0L && (xBaseWindow = XToolkit.windowToXWindow(l2)) instanceof XWindow) {
                xWindow = (XWindow)xBaseWindow;
            }
            if (xWindow != null) {
                object = xWindow.toLocal(n, n2);
                n = ((Point)object).x;
                n2 = ((Point)object).y;
            }
        }
        if (xWindow == null) {
            if (this.targetXWindow != null) {
                this.notifyProtocolListener(this.targetXWindow, n, n2, 0, n6, xClientMessageEvent, 505);
            }
        } else {
            int n8 = 0;
            n8 = this.targetXWindow == null ? 504 : 506;
            this.notifyProtocolListener(xWindow, n, n2, n5, n6, xClientMessageEvent, n8);
        }
        this.sourceActions = n6;
        this.userAction = n5;
        this.sourceX = n;
        this.sourceY = n2;
        this.targetXWindow = xWindow;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processTopLevelLeave(XClientMessageEvent xClientMessageEvent) {
        byte by;
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        long l = xClientMessageEvent.get_data();
        long l2 = MotifDnDConstants.Swapper.getInt(l + 8L, by = unsafe.getByte(l + 1L));
        if (l2 != this.sourceWindow) {
            return false;
        }
        this.topLevelLeavePostponed = true;
        long l3 = this.getEmbedderRegistryEntry(xClientMessageEvent.get_window()) != null ? XDropTargetRegistry.getDnDProxyWindow() : xClientMessageEvent.get_window();
        XClientMessageEvent xClientMessageEvent2 = new XClientMessageEvent();
        try {
            xClientMessageEvent2.set_type(33);
            xClientMessageEvent2.set_window(xClientMessageEvent.get_window());
            xClientMessageEvent2.set_format(32);
            xClientMessageEvent2.set_message_type(0L);
            xClientMessageEvent2.set_data(0, 0L);
            xClientMessageEvent2.set_data(1, 0L);
            xClientMessageEvent2.set_data(2, 0L);
            xClientMessageEvent2.set_data(3, 0L);
            xClientMessageEvent2.set_data(4, 0L);
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), l3, false, 0L, xClientMessageEvent2.pData);
            Object var11_7 = null;
            xClientMessageEvent2.dispose();
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            xClientMessageEvent2.dispose();
            throw throwable;
        }
        return true;
    }

    private boolean processDropStart(XClientMessageEvent xClientMessageEvent) {
        XBaseWindow xBaseWindow;
        long l;
        byte by;
        long l2 = xClientMessageEvent.get_data();
        long l3 = MotifDnDConstants.Swapper.getInt(l2 + 16L, by = unsafe.getByte(l2 + 1L));
        if (l3 != this.sourceWindow) {
            return false;
        }
        long l4 = MotifDnDConstants.Swapper.getInt(l2 + 12L, by);
        short s = MotifDnDConstants.Swapper.getShort(l2 + 2L, by);
        int n = (s & 0xF) >> 0;
        int n2 = (s & 0xF00) >> 8;
        int n3 = MotifDnDConstants.getJavaActionsForMotifActions(n);
        int n4 = MotifDnDConstants.getJavaActionsForMotifActions(n2);
        int n5 = MotifDnDConstants.Swapper.getShort(l2 + 8L, by);
        int n6 = MotifDnDConstants.Swapper.getShort(l2 + 10L, by);
        XWindow xWindow = null;
        Object object = XToolkit.windowToXWindow(xClientMessageEvent.get_window());
        if (object instanceof XWindow) {
            xWindow = (XWindow)object;
        }
        if (xWindow == null && (l = XDropTargetRegistry.getRegistry().getEmbeddedDropSite(xClientMessageEvent.get_window(), n5, n6)) != 0L && (xBaseWindow = XToolkit.windowToXWindow(l)) instanceof XWindow) {
            xWindow = (XWindow)xBaseWindow;
        }
        if (xWindow != null) {
            object = xWindow.toLocal(n5, n6);
            n5 = ((Point)object).x;
            n6 = ((Point)object).y;
        }
        if (xWindow != null) {
            this.notifyProtocolListener(xWindow, n5, n6, n3, n4, xClientMessageEvent, 502);
        } else if (this.targetXWindow != null) {
            this.notifyProtocolListener(this.targetXWindow, n5, n6, 0, n4, xClientMessageEvent, 505);
        }
        return true;
    }

    public int getMessageType(XClientMessageEvent xClientMessageEvent) {
        if (xClientMessageEvent.get_message_type() != MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom()) {
            return 0;
        }
        long l = xClientMessageEvent.get_data();
        byte by = (byte)(unsafe.getByte(l) & 0x7F);
        switch (by) {
            case 0: {
                return 1;
            }
            case 2: 
            case 8: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 5: {
                return 4;
            }
        }
        return 0;
    }

    protected boolean processClientMessageImpl(XClientMessageEvent xClientMessageEvent) {
        if (xClientMessageEvent.get_message_type() != MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom()) {
            if (this.topLevelLeavePostponed) {
                this.topLevelLeavePostponed = false;
                this.cleanup();
            }
            return false;
        }
        long l = xClientMessageEvent.get_data();
        byte by = (byte)(unsafe.getByte(l) & 0x7F);
        byte by2 = (byte)(unsafe.getByte(l) & 0xFFFFFF80);
        if (this.topLevelLeavePostponed) {
            this.topLevelLeavePostponed = false;
            if (by != 5) {
                this.cleanup();
            }
        }
        if (by2 != 0) {
            return false;
        }
        switch (by) {
            case 0: {
                return this.processTopLevelEnter(xClientMessageEvent);
            }
            case 2: 
            case 8: {
                return this.processDragMotion(xClientMessageEvent);
            }
            case 1: {
                return this.processTopLevelLeave(xClientMessageEvent);
            }
            case 5: {
                return this.processDropStart(xClientMessageEvent);
            }
        }
        return false;
    }

    protected void sendEnterMessageToToplevel(long l, XClientMessageEvent xClientMessageEvent) {
        throw new Error("UNIMPLEMENTED");
    }

    protected void sendLeaveMessageToToplevel(long l, XClientMessageEvent xClientMessageEvent) {
        throw new Error("UNIMPLEMENTED");
    }

    public boolean forwardEventToEmbedded(long l, long l2, int n) {
        return false;
    }

    public boolean isXEmbedSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendResponse(long l, int n, int n2) {
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent(l);
        if (xClientMessageEvent.get_message_type() != MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom()) {
            return false;
        }
        long l2 = xClientMessageEvent.get_data();
        int n3 = unsafe.getByte(l2) & 0x7F;
        byte by = (byte)(unsafe.getByte(l2) & 0xFFFFFF80);
        byte by2 = unsafe.getByte(l2 + 1L);
        int n4 = 0;
        if (by != 0) {
            return false;
        }
        switch (n3) {
            case 0: 
            case 1: {
                return false;
            }
            case 2: {
                switch (n) {
                    case 504: {
                        n4 = 3;
                        break;
                    }
                    case 506: {
                        n4 = 2;
                        break;
                    }
                    case 505: {
                        n4 = 4;
                    }
                }
                break;
            }
            case 5: 
            case 8: {
                n4 = n3;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        XClientMessageEvent xClientMessageEvent2 = new XClientMessageEvent();
        try {
            short s;
            int n5;
            xClientMessageEvent2.set_type(33);
            xClientMessageEvent2.set_window(MotifDnDConstants.Swapper.getInt(l2 + 12L, by2));
            xClientMessageEvent2.set_format(8);
            xClientMessageEvent2.set_message_type(MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom());
            long l3 = xClientMessageEvent2.get_data();
            unsafe.putByte(l3, (byte)(n4 | 0xFFFFFF80));
            unsafe.putByte(l3 + 1L, MotifDnDConstants.getByteOrderByte());
            int n6 = 0;
            if (n4 != 4) {
                n5 = MotifDnDConstants.Swapper.getShort(l2 + 2L, by2);
                s = n2 == 0 ? (short)2 : 3;
                n6 = n5 & 0xFFFFFFF0 & 0xFFFFFF0F;
                n6 |= MotifDnDConstants.getMotifActionsForJavaActions(n2) << 0;
                n6 |= s << 4;
            } else {
                n6 = 0;
            }
            unsafe.putShort(l3 + 2L, (short)n6);
            n5 = MotifDnDConstants.Swapper.getInt(l2 + 4L, by2);
            unsafe.putInt(l3 + 4L, n5);
            if (n4 != 4) {
                s = MotifDnDConstants.Swapper.getShort(l2 + 8L, by2);
                short s2 = MotifDnDConstants.Swapper.getShort(l2 + 10L, by2);
                unsafe.putShort(l3 + 8L, s);
                unsafe.putShort(l3 + 10L, s2);
            } else {
                unsafe.putShort(l3 + 8L, (short)0);
                unsafe.putShort(l3 + 10L, (short)0);
            }
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), xClientMessageEvent2.get_window(), false, 0L, xClientMessageEvent2.pData);
                Object var20_16 = null;
            }
            catch (Throwable throwable) {
                Object var20_17 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            Object var22_19 = null;
            xClientMessageEvent2.dispose();
        }
        catch (Throwable throwable) {
            Object var22_20 = null;
            xClientMessageEvent2.dispose();
            throw throwable;
        }
        return true;
    }

    public Object getData(long l, long l2) throws IllegalArgumentException, IOException {
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent(l);
        if (xClientMessageEvent.get_message_type() != MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom()) {
            throw new IllegalArgumentException();
        }
        long l3 = xClientMessageEvent.get_data();
        byte by = (byte)(unsafe.getByte(l3) & 0x7F);
        byte by2 = (byte)(unsafe.getByte(l3) & 0xFFFFFF80);
        byte by3 = unsafe.getByte(l3 + 1L);
        if (by2 != 0) {
            throw new IOException("Cannot get data: corrupted context");
        }
        long l4 = 0L;
        switch (by) {
            case 2: 
            case 8: {
                l4 = this.sourceAtom;
                break;
            }
            case 5: {
                l4 = MotifDnDConstants.Swapper.getInt(l3 + 12L, by3);
                break;
            }
            default: {
                throw new IOException("Cannot get data: invalid message reason");
            }
        }
        if (l4 == 0L) {
            throw new IOException("Cannot get data: drag source property atom unavailable");
        }
        long l5 = MotifDnDConstants.Swapper.getInt(l3 + 4L, by3);
        XAtom xAtom = XAtom.get(l4);
        XSelection xSelection = XSelection.getSelection(xAtom);
        if (xSelection == null) {
            xSelection = new XSelection(xAtom, null);
        }
        return xSelection.getData(l2, l5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendDropDone(long l, boolean bl, int n) {
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent(l);
        if (xClientMessageEvent.get_message_type() != MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom()) {
            return false;
        }
        long l2 = xClientMessageEvent.get_data();
        byte by = (byte)(unsafe.getByte(l2) & 0x7F);
        byte by2 = (byte)(unsafe.getByte(l2) & 0xFFFFFF80);
        byte by3 = unsafe.getByte(l2 + 1L);
        if (by2 != 0) {
            return false;
        }
        if (by != 5) {
            return false;
        }
        long l3 = MotifDnDConstants.Swapper.getInt(l2 + 4L, by3);
        long l4 = MotifDnDConstants.Swapper.getInt(l2 + 12L, by3);
        long l5 = 0L;
        l5 = bl ? MotifDnDConstants.XA_XmTRANSFER_SUCCESS.getAtom() : MotifDnDConstants.XA_XmTRANSFER_FAILURE.getAtom();
        XToolkit.awtLock();
        try {
            XlibWrapper.XConvertSelection(XToolkit.getDisplay(), l4, l5, MotifDnDConstants.XA_MOTIF_ATOM_0.getAtom(), XWindow.getXAWTRootWindow().getWindow(), l3);
            XlibWrapper.XFlush(XToolkit.getDisplay());
            Object var18_12 = null;
        }
        catch (Throwable throwable) {
            Object var18_13 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        this.targetXWindow = null;
        this.cleanup();
        return true;
    }

    public final long getSourceWindow() {
        return this.sourceWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        XDropTargetEventProcessor.reset();
        if (this.targetXWindow != null) {
            this.notifyProtocolListener(this.targetXWindow, 0, 0, 0, this.sourceActions, null, 505);
        }
        if (this.sourceWindow != 0L) {
            XToolkit.awtLock();
            try {
                XToolkit.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                XlibWrapper.XSelectInput(XToolkit.getDisplay(), this.sourceWindow, this.sourceWindowMask);
                XToolkit.RESTORE_XERROR_HANDLER();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            {
            }
        }
        this.sourceWindow = 0L;
        this.sourceWindowMask = 0L;
        this.sourceProtocolVersion = 0;
        this.sourceActions = 0;
        this.sourceFormats = null;
        this.sourceAtom = 0L;
        this.userAction = 0;
        this.sourceX = 0;
        this.sourceY = 0;
        this.targetXWindow = null;
        this.topLevelLeavePostponed = false;
    }

    public boolean isDragOverComponent() {
        return this.targetXWindow != null;
    }

    private void notifyProtocolListener(XWindow xWindow, int n, int n2, int n3, int n4, XClientMessageEvent xClientMessageEvent, int n5) {
        long l = 0L;
        if (xClientMessageEvent != null) {
            new XClientMessageEvent(l);
            int n6 = XClientMessageEvent.getSize();
            l = unsafe.allocateMemory(n6 + 4 * Native.getLongSize());
            unsafe.copyMemory(xClientMessageEvent.pData, l, n6);
        }
        this.getProtocolListener().handleDropTargetNotification(xWindow, n, n2, n3, n4, this.sourceFormats, l, n5);
    }
}

