/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class HeapBlock
extends VMObject {
    private static long heapBlockSize;
    private static Field headerField;
    private static CIntegerField headerLengthField;
    private static CIntegerField headerUsedField;

    private static void initialize(TypeDataBase db) {
        Type type = db.lookupType("HeapBlock");
        heapBlockSize = type.getSize();
        headerField = type.getField("_header");
        type = db.lookupType("HeapBlock::Header");
        headerLengthField = type.getCIntegerField("_length");
        headerUsedField = type.getCIntegerField("_used");
    }

    public HeapBlock(Address addr) {
        super(addr);
    }

    public long getLength() {
        return this.getHeader().getLength();
    }

    public boolean isFree() {
        return this.getHeader().isFree();
    }

    public Address getAllocatedSpace() {
        return this.addr.addOffsetTo(heapBlockSize);
    }

    private Header getHeader() {
        return (Header)VMObjectFactory.newObject(Header.class, this.addr.addOffsetTo(headerField.getOffset()));
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                HeapBlock.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }

    public static class Header
    extends VMObject {
        public Header(Address addr) {
            super(addr);
        }

        public long getLength() {
            return headerLengthField.getValue(this.addr);
        }

        public boolean isFree() {
            return headerUsedField.getValue(this.addr) == 0L;
        }
    }
}

