/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections;

import com.intellij.cvsSupport2.config.ExtConfiguration;
import com.intellij.cvsSupport2.config.ProxySettings;
import com.intellij.cvsSupport2.config.SshSettings;
import com.intellij.cvsSupport2.connections.ConnectionSettingsImpl;
import com.intellij.cvsSupport2.connections.CvsRootData;
import com.intellij.cvsSupport2.connections.ext.ExtConnection;
import com.intellij.cvsSupport2.connections.ssh.SSHPasswordProvider;
import com.intellij.cvsSupport2.connections.ssh.SshAuthentication;
import com.intellij.cvsSupport2.connections.ssh.SshConnectionPool;
import com.intellij.cvsSupport2.connections.ssh.SshPasswordAuthentication;
import com.intellij.cvsSupport2.connections.ssh.SshPublicKeyAuthentication;
import com.intellij.cvsSupport2.errorHandling.ErrorRegistry;
import java.io.File;
import org.netbeans.lib.cvsclient.connection.ConnectionSettings;
import org.netbeans.lib.cvsclient.connection.IConnection;
import org.netbeans.lib.cvsclient.connection.PServerConnection;

public class CvsConnectionUtil {
    public static final int DEFAULT_PSERVER_PORT = 2401;

    private CvsConnectionUtil() {
    }

    public static IConnection createSshConnection(CvsRootData settings, SshSettings sshConfiguration, ProxySettings proxySettings, SSHPasswordProvider sshPasswordProvider, int timeout) {
        ConnectionSettingsImpl connectionSettings = new ConnectionSettingsImpl(settings.HOST, settings.PORT, proxySettings.USE_PROXY, proxySettings.PROXY_HOST, proxySettings.PROXY_PORT, timeout, proxySettings.getType(), proxySettings.getLogin(), proxySettings.getPassword());
        SshConnectionPool pool = SshConnectionPool.getInstance();
        SshAuthentication authentication = sshConfiguration.USE_PPK ? new SshPublicKeyAuthentication(new File(sshConfiguration.PATH_TO_PPK), settings.USER, sshPasswordProvider, settings.getCvsRootAsString()) : new SshPasswordAuthentication(settings.USER, sshPasswordProvider, settings.getCvsRootAsString());
        return pool.getConnection(settings.REPOSITORY, connectionSettings, authentication);
    }

    public static int getPort(String port) {
        if (port.length() == 0) {
            return 22;
        }
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            return 22;
        }
    }

    public static IConnection createExtConnection(CvsRootData settings, ExtConfiguration extConfiguration, SshSettings sshConfiguration, SSHPasswordProvider sshPasswordProvider, ProxySettings proxySettings, ErrorRegistry errorRegistry, int timeout) {
        if (extConfiguration.USE_INTERNAL_SSH_IMPLEMENTATION) {
            return CvsConnectionUtil.createSshConnection(settings, sshConfiguration, proxySettings, sshPasswordProvider, timeout);
        }
        return new ExtConnection(settings.HOST, settings.USER, settings.REPOSITORY, extConfiguration, errorRegistry);
    }

    public static IConnection createPServerConnection(CvsRootData root, ProxySettings proxySettings, int timeout) {
        ConnectionSettingsImpl connectionSettings = new ConnectionSettingsImpl(root.HOST, root.PORT, proxySettings.USE_PROXY, proxySettings.PROXY_HOST, proxySettings.PROXY_PORT, timeout, proxySettings.TYPE, proxySettings.getLogin(), proxySettings.getPassword());
        return new PServerConnection((ConnectionSettings)connectionSettings, root.USER, root.PASSWORD, CvsConnectionUtil.adjustRepository(root));
    }

    public static String adjustRepository(CvsRootData root) {
        if (root.REPOSITORY != null) {
            return root.REPOSITORY.replace('\\', '/');
        }
        return null;
    }
}

