/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.psi.PsiElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.inspections.SplitterFactory;
import com.intellij.spellchecker.tokenizer.Token;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocCommentTokenizer
extends Tokenizer<PsiDocComment> {
    private static final Set<String> excludedTags = new HashSet();

    public DocCommentTokenizer() {
        excludedTags.add("author");
        excludedTags.add("see");
        excludedTags.add("by");
        excludedTags.add("link");
    }

    @Nullable
    public Token[] tokenize(@NotNull PsiDocComment comment) {
        if (comment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/DocCommentTokenizer.tokenize must not be null");
        }
        ArrayList<Token> result = new ArrayList<Token>();
        for (PsiElement el : comment.getChildren()) {
            if (el instanceof PsiDocTag) {
                PsiDocTag tag = (PsiDocTag)el;
                if (excludedTags.contains(tag.getName())) continue;
                for (PsiElement data : tag.getDataElements()) {
                    result.add(new Token(data, data.getText(), false, (Splitter)SplitterFactory.getInstance().getCommentSplitter()));
                }
                continue;
            }
            result.add(new Token(el, el.getText(), false, (Splitter)SplitterFactory.getInstance().getCommentSplitter()));
        }
        Token[] t = new Token[result.size()];
        result.toArray(t);
        return result.size() == 0 ? null : t;
    }
}

