/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure.treetable;

import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class StripedTreeTable
extends TreeTable {
    private Color myStripeColor1;
    private Color myStripeColor2;

    public StripedTreeTable(TreeTableModel treeTableModel, Color stripeColor1) {
        this(treeTableModel, stripeColor1, Color.white);
    }

    public StripedTreeTable(TreeTableModel treeTableModel, Color stripeColor1, Color stripeColor2) {
        super(treeTableModel);
        this.myStripeColor1 = stripeColor1;
        this.myStripeColor2 = stripeColor2;
        this.setOpaque(false);
        this.getTree().setOpaque(false);
        this.getTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                int[] selectionRows = StripedTreeTable.this.getTree().getSelectionRows();
                if (selectionRows != null && selectionRows.length > 0) {
                    StripedTreeTable.this.addColumnSelectionInterval(0, StripedTreeTable.this.getColumnCount() - 1);
                }
            }
        });
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn column = this.getColumn(this.getColumnName(i));
            final TableCellRenderer cellRenderer = this.getCellRenderer(i);
            if (cellRenderer == null) continue;
            column.setCellRenderer(new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                    Component component = cellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                    StripedTreeTable.this.drawStripe(isSelected, component, row, UIUtil.getTableSelectionBackground(), UIUtil.getTableBackground());
                    return component;
                }
            });
        }
        final TreeCellRenderer treeRenderer = this.getTreeRenderer();
        if (treeRenderer != null) {
            this.getTree().setCellRenderer(new DefaultTreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    Component component = treeRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                    StripedTreeTable.this.drawStripe(selected, component, row, UIUtil.getTreeSelectionBackground(), UIUtil.getTreeTextBackground());
                    return component;
                }
            });
        }
    }

    protected TableCellRenderer getCellRenderer(int column) {
        return null;
    }

    protected TreeCellRenderer getTreeRenderer() {
        return null;
    }

    public void paint(Graphics g) {
        Color color = g.getColor();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getSelectedRow() == i) {
                this.drawStripe(g, i, UIUtil.getTableSelectionBackground());
                continue;
            }
            if (i % 2 == 0) {
                this.drawStripe(g, i, this.myStripeColor1);
                continue;
            }
            this.drawStripe(g, i, this.myStripeColor2);
        }
        g.setColor(color);
        super.paint(g);
    }

    private void drawStripe(Graphics g, int i, Color color) {
        g.setColor(color);
        Rectangle cellRect = this.getCellRect(i, 0, true);
        g.fillRect(cellRect.x, cellRect.y, cellRect.width, cellRect.height);
    }

    private void drawStripe(boolean isSelected, Component component, int row, Color selectionColor, Color bgColor) {
        if (isSelected) {
            component.setBackground(selectionColor);
        } else if (row % 2 == 0) {
            component.setBackground(this.myStripeColor1);
        } else {
            component.setBackground(bgColor);
        }
    }
}

