/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import org.jetbrains.annotations.NotNull;

public class PackageWrapper {
    private final PsiManager myManager;
    @NotNull
    private final String myQualifiedName;

    public PackageWrapper(PsiManager manager, @NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/PackageWrapper.<init> must not be null");
        }
        this.myManager = manager;
        this.myQualifiedName = qualifiedName;
    }

    public PackageWrapper(PsiPackage aPackage) {
        this.myManager = aPackage.getManager();
        this.myQualifiedName = aPackage.getQualifiedName();
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public PsiDirectory[] getDirectories() {
        PsiPackage aPackage = JavaPsiFacade.getInstance(this.myManager.getProject()).findPackage(this.myQualifiedName);
        if (aPackage != null) {
            return aPackage.getDirectories();
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    public boolean exists() {
        return JavaPsiFacade.getInstance(this.myManager.getProject()).findPackage(this.myQualifiedName) != null;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myQualifiedName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/PackageWrapper.getQualifiedName must not return null");
        }
        return string;
    }

    public boolean equalToPackage(PsiPackage aPackage) {
        return aPackage != null && this.myQualifiedName.equals(aPackage.getQualifiedName());
    }

    public static PackageWrapper create(PsiPackage aPackage) {
        return new PackageWrapper(aPackage);
    }
}

