/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeElementPattern<ParentType, T extends ParentType, Self extends TreeElementPattern<ParentType, T, Self>>
extends ObjectPattern<T, Self> {
    protected TreeElementPattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/TreeElementPattern.<init> must not be null");
        }
        super(condition);
    }

    protected TreeElementPattern(Class<T> aClass) {
        super(aClass);
    }

    @Nullable
    protected abstract ParentType getParent(@NotNull ParentType var1);

    protected abstract ParentType[] getChildren(@NotNull ParentType var1);

    public Self withParent(@NotNull Class<? extends ParentType> type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/TreeElementPattern.withParent must not be null");
        }
        return this.withParent(StandardPatterns.instanceOf(type));
    }

    public Self withParent(@NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/TreeElementPattern.withParent must not be null");
        }
        return this.withSuperParent(1, pattern);
    }

    public Self withChild(@NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/TreeElementPattern.withChild must not be null");
        }
        return this.withChildren(StandardPatterns.collection().atLeastOne(pattern));
    }

    public Self withFirstChild(@NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/TreeElementPattern.withFirstChild must not be null");
        }
        return this.withChildren(StandardPatterns.collection().first(pattern));
    }

    public Self withLastChild(@NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/TreeElementPattern.withLastChild must not be null");
        }
        return this.withChildren(StandardPatterns.collection().last(pattern));
    }

    public Self withChildren(final @NotNull ElementPattern<Collection<ParentType>> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/TreeElementPattern.withChildren must not be null");
        }
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("withChildren"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/TreeElementPattern$1.accepts must not be null");
                }
                return pattern.getCondition().accepts(Arrays.asList(TreeElementPattern.this.getChildren(t)), context);
            }
        }));
    }

    public Self isFirstAcceptedChild(final @NotNull ElementPattern<? super ParentType> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/TreeElementPattern.isFirstAcceptedChild must not be null");
        }
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("isFirstAcceptedChild"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/TreeElementPattern$2.accepts must not be null");
                }
                Object parent = TreeElementPattern.this.getParent(t);
                if (parent != null) {
                    T[] children;
                    for (Object child : children = TreeElementPattern.this.getChildren(parent)) {
                        if (!pattern.getCondition().accepts(child, context)) continue;
                        return child == t;
                    }
                }
                return false;
            }
        }));
    }

    public Self withSuperParent(int level, @NotNull Class<? extends ParentType> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/patterns/TreeElementPattern.withSuperParent must not be null");
        }
        return this.withSuperParent(level, StandardPatterns.instanceOf(aClass));
    }

    public Self withSuperParent(final int level, final @NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/patterns/TreeElementPattern.withSuperParent must not be null");
        }
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("withSuperParent"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/TreeElementPattern$3.accepts must not be null");
                }
                Object parent = t;
                for (int i = 0; i < level; ++i) {
                    if (parent == null) {
                        return false;
                    }
                    parent = TreeElementPattern.this.getParent(parent);
                }
                return pattern.getCondition().accepts(parent, context);
            }
        }));
    }

    public Self inside(@NotNull Class<? extends ParentType> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/TreeElementPattern.inside must not be null");
        }
        return this.inside(StandardPatterns.instanceOf(pattern));
    }

    public Self inside(@NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/TreeElementPattern.inside must not be null");
        }
        return this.inside(false, pattern);
    }

    public Self inside(final boolean strict, final @NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/patterns/TreeElementPattern.inside must not be null");
        }
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("inside"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                Object element;
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/TreeElementPattern$4.accepts must not be null");
                }
                Object t2 = element = strict ? TreeElementPattern.this.getParent(t) : t;
                while (element != null) {
                    if (pattern.getCondition().accepts(element, context)) {
                        return true;
                    }
                    element = TreeElementPattern.this.getParent(element);
                }
                return false;
            }
        }));
    }

    public Self insideSequence(final boolean strict, final ElementPattern<? extends ParentType> ... patterns) {
        if (patterns == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/patterns/TreeElementPattern.insideSequence must not be null");
        }
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("condInside"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                Object element;
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/TreeElementPattern$5.accepts must not be null");
                }
                int i = 0;
                Object t2 = element = strict ? TreeElementPattern.this.getParent(t) : t;
                while (element != null && i >= patterns.length) {
                    for (int j = i; j < patterns.length; ++j) {
                        if (!patterns[j].getCondition().accepts(t, context)) continue;
                        if (i != j) {
                            return false;
                        }
                        ++i;
                        break;
                    }
                    element = TreeElementPattern.this.getParent(element);
                }
                return false;
            }
        }));
    }
}

