/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.WeakHashMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public class ContentRevisionVirtualFile
extends AbstractVcsVirtualFile {
    private final ContentRevision myContentRevision;
    private byte[] myContent;
    private boolean myContentLoadFailed;
    private static final WeakHashMap<ContentRevision, ContentRevisionVirtualFile> ourMap = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentRevisionVirtualFile create(ContentRevision contentRevision) {
        WeakHashMap<ContentRevision, ContentRevisionVirtualFile> weakHashMap = ourMap;
        synchronized (weakHashMap) {
            ContentRevisionVirtualFile revisionVirtualFile = (ContentRevisionVirtualFile)ourMap.get((Object)contentRevision);
            if (revisionVirtualFile == null) {
                revisionVirtualFile = new ContentRevisionVirtualFile(contentRevision);
                ourMap.put((Object)contentRevision, (Object)revisionVirtualFile);
            }
            return revisionVirtualFile;
        }
    }

    private ContentRevisionVirtualFile(ContentRevision contentRevision) {
        super(contentRevision.getFile().getPath(), VcsFileSystem.getInstance());
        this.myContentRevision = contentRevision;
        this.setCharset(CharsetToolkit.UTF8_CHARSET);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        byte[] byArray;
        if (this.myContentLoadFailed || this.myProcessingBeforeContentsChange) {
            byArray = ArrayUtil.EMPTY_BYTE_ARRAY;
            if (ArrayUtil.EMPTY_BYTE_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/vfs/ContentRevisionVirtualFile.contentsToByteArray must not return null");
            return byArray;
        }
        if (this.myContent == null) {
            this.loadContent();
        }
        byArray = this.myContent;
        if (this.myContent != null) return byArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/vfs/ContentRevisionVirtualFile.contentsToByteArray must not return null");
    }

    private void loadContent() {
        final VcsFileSystem vcsFileSystem = (VcsFileSystem)this.getFileSystem();
        try {
            String content = this.myContentRevision.getContent();
            if (content == null) {
                throw new VcsException("Could not load content");
            }
            this.fireBeforeContentsChange();
            ++this.myModificationStamp;
            this.setRevision(this.myContentRevision.getRevisionNumber().asString());
            ByteBuffer byteBuffer = this.getCharset().encode(content);
            this.myContent = byteBuffer.compact().array();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    vcsFileSystem.fireContentsChanged(this, ContentRevisionVirtualFile.this, 0L);
                }
            });
        }
        catch (VcsException e) {
            this.myContentLoadFailed = true;
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    vcsFileSystem.fireBeforeFileDeletion(this, ContentRevisionVirtualFile.this);
                }
            });
            this.myContent = ArrayUtil.EMPTY_BYTE_ARRAY;
            this.setRevision("0");
            Messages.showMessageDialog(VcsBundle.message("message.text.could.not.load.virtual.file.content", this.getPresentableUrl(), e.getLocalizedMessage()), VcsBundle.message("message.title.could.not.load.content", new Object[0]), Messages.getInformationIcon());
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    vcsFileSystem.fireFileDeleted(this, ContentRevisionVirtualFile.this, ContentRevisionVirtualFile.this.getName(), ContentRevisionVirtualFile.this.getParent());
                }
            });
        }
        catch (ProcessCanceledException ex) {
            this.myContent = ArrayUtil.EMPTY_BYTE_ARRAY;
        }
    }
}

