/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.util;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;

public class MethodParenthesesHandler
extends ParenthesesInsertHandler<LookupElement> {
    private final PsiMethod myMethod;
    private final boolean myOverloadsMatter;

    public MethodParenthesesHandler(PsiMethod method, boolean overloadsMatter) {
        this.myMethod = method;
        this.myOverloadsMatter = overloadsMatter;
    }

    public MethodParenthesesHandler(PsiMethod method, boolean overloadsMatter, boolean spaceBeforeParentheses, boolean spaceBetweenParentheses, boolean insertRightParenthesis) {
        super(spaceBeforeParentheses, spaceBetweenParentheses, insertRightParenthesis);
        this.myMethod = method;
        this.myOverloadsMatter = overloadsMatter;
    }

    @Override
    protected boolean placeCaretInsideParentheses(InsertionContext context, LookupElement item) {
        return MethodParenthesesHandler.hasParams(item, context.getElements(), this.myOverloadsMatter, this.myMethod);
    }

    public static boolean hasParams(LookupElement item, LookupElement[] allItems, boolean overloadsMatter, PsiMethod method) {
        boolean hasParams;
        boolean bl = hasParams = method.getParameterList().getParametersCount() > 0;
        if (overloadsMatter) {
            hasParams |= MethodParenthesesHandler.hasOverloads(item, allItems, method);
        }
        return hasParams;
    }

    private static boolean hasOverloads(LookupElement item, LookupElement[] allItems, PsiMethod method) {
        String name = method.getName();
        for (LookupElement item1 : allItems) {
            Object o = item1.getObject();
            if (item.getObject() == o || !(o instanceof PsiMethod) || !((PsiMethod)o).getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected PsiElement findNextToken(InsertionContext context) {
        PsiElement element = context.getFile().findElementAt(context.getTailOffset());
        if (element instanceof PsiWhiteSpace && element.getText().contains("\n") && !CodeStyleSettingsManager.getSettings((Project)context.getProject()).METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE) {
            return null;
        }
        return super.findNextToken(context);
    }
}

