/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.integer;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.integer.ConvertIntegerToHexPredicate;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;

public class ConvertIntegerToHexIntention
extends Intention {
    private static final BigInteger LONG_BINARY_ONES = new BigInteger("ffffffffffffffff", 16);
    private static final BigInteger INT_BINARY_ONES = new BigInteger("ffffffff", 16);

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ConvertIntegerToHexPredicate convertIntegerToHexPredicate = new ConvertIntegerToHexPredicate();
        if (convertIntegerToHexPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/integer/ConvertIntegerToHexIntention.getElementPredicate must not return null");
        }
        return convertIntegerToHexPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/integer/ConvertIntegerToHexIntention.processIntention must not be null");
        }
        PsiExpression expression = (PsiExpression)element;
        PsiType type = expression.getType();
        if (PsiType.INT.equals(type) || PsiType.LONG.equals(type)) {
            BigInteger value;
            boolean isLong;
            int textLength;
            String textString = expression.getText();
            char lastChar = textString.charAt((textLength = textString.length()) - 1);
            boolean bl = isLong = lastChar == 'l' || lastChar == 'L';
            if (isLong) {
                textString = textString.substring(0, textLength - 1);
            }
            if (textString.charAt(0) == '0') {
                value = new BigInteger(textString, 8);
            } else {
                PsiPrefixExpression prefixExpression;
                IElementType tokenType;
                value = new BigInteger(textString, 10);
                PsiElement parent = expression.getParent();
                if (parent instanceof PsiPrefixExpression && JavaTokenType.MINUS == (tokenType = (prefixExpression = (PsiPrefixExpression)parent).getOperationTokenType())) {
                    value = isLong ? value.xor(LONG_BINARY_ONES).add(BigInteger.ONE) : value.xor(INT_BINARY_ONES).add(BigInteger.ONE);
                    String hexString = "0x" + value.toString(16);
                    if (isLong) {
                        hexString = hexString + 'L';
                    }
                    ConvertIntegerToHexIntention.replaceExpression(hexString, (PsiExpression)prefixExpression);
                    return;
                }
            }
            String hexString = "0x" + value.toString(16);
            if (isLong) {
                hexString = hexString + 'L';
            }
            ConvertIntegerToHexIntention.replaceExpression(hexString, expression);
        } else {
            boolean isFloat;
            int textLength;
            String textString = expression.getText();
            char lastChar = textString.charAt((textLength = textString.length()) - 1);
            boolean bl = isFloat = lastChar == 'f' || lastChar == 'F';
            if (isFloat) {
                textString = textString.substring(0, textLength - 1);
            }
            if (isFloat) {
                float floatValue = Float.parseFloat(textString);
                String floatString = Float.toHexString(floatValue) + lastChar;
                ConvertIntegerToHexIntention.replaceExpression(floatString, expression);
            } else {
                double doubleValue = Double.parseDouble(textString);
                String floatString = Double.toHexString(doubleValue);
                ConvertIntegerToHexIntention.replaceExpression(floatString, expression);
            }
        }
    }
}

