/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.introspection;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.types.Reference;

public enum AntAttributeType {
    INTEGER,
    BOOLEAN,
    STRING,
    FILE,
    ID_REFERENCE;

    private static final Map<Class<?>, AntAttributeType> ourClassesMap;

    public static AntAttributeType create(Class antDeclaredClass) {
        AntAttributeType type = ourClassesMap.get(antDeclaredClass);
        if (type != null) {
            return type;
        }
        if (AntAttributeType.isAssignableFrom(Reference.class, antDeclaredClass)) {
            return ID_REFERENCE;
        }
        return STRING;
    }

    private static boolean isAssignableFrom(Class interfaceClass, Class antDeclaredClass) {
        ClassLoader loader = antDeclaredClass.getClassLoader();
        try {
            Class<?> ifaceClass = loader != null ? loader.loadClass(interfaceClass.getName()) : interfaceClass;
            return ifaceClass.isAssignableFrom(antDeclaredClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    static {
        ourClassesMap = new HashMap();
        ourClassesMap.put(Integer.TYPE, INTEGER);
        ourClassesMap.put(Boolean.TYPE, BOOLEAN);
        ourClassesMap.put(File.class, FILE);
    }
}

