/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NotNull;

public class AntImportsIndex
extends ScalarIndexExtension<Integer> {
    public static final ID<Integer, Void> INDEX_NAME = ID.create((String)"ant-imports");
    private static final int VERSION = 4;
    public static final Integer ANT_FILES_WITH_IMPORTS_KEY = new Integer(0);
    private static final DataIndexer<Integer, Void, FileContent> DATA_INDEXER = new DataIndexer<Integer, Void, FileContent>(){

        @NotNull
        public Map<Integer, Void> map(FileContent inputData) {
            final HashMap<Integer, Void> map = new HashMap<Integer, Void>();
            NanoXmlUtil.parse((Reader)new StringReader(((Object)inputData.getContentAsText()).toString()), (IXMLBuilder)new NanoXmlUtil.IXMLBuilderAdapter(){
                private boolean isFirstElement = true;
                private Set<String> myAttributes = new HashSet<String>();

                public void startElement(String elemName, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                    if (this.isFirstElement) {
                        if (!"project".equalsIgnoreCase(elemName)) {
                            1.stop();
                        }
                        this.isFirstElement = false;
                    } else if ("import".equalsIgnoreCase(elemName)) {
                        map.put(ANT_FILES_WITH_IMPORTS_KEY, null);
                        1.stop();
                    }
                }

                public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                    if (this.myAttributes != null) {
                        this.myAttributes.add(key);
                    }
                }

                public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) throws Exception {
                    if (this.myAttributes != null) {
                        if (!this.myAttributes.contains("name") || !this.myAttributes.contains("default")) {
                            1.stop();
                        }
                        this.myAttributes = null;
                    }
                }
            });
            HashMap<Integer, Void> hashMap = map;
            if (hashMap == null) {
                throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntImportsIndex$1.map must not return null");
            }
            return hashMap;
        }
    };

    public int getVersion() {
        return 4;
    }

    public ID<Integer, Void> getName() {
        return INDEX_NAME;
    }

    public DataIndexer<Integer, Void, FileContent> getIndexer() {
        return DATA_INDEXER;
    }

    public KeyDescriptor<Integer> getKeyDescriptor() {
        return new EnumeratorIntegerDescriptor();
    }

    public FileBasedIndex.InputFilter getInputFilter() {
        final FileTypeManager ftManager = FileTypeManager.getInstance();
        return new FileBasedIndex.InputFilter(){

            public boolean acceptInput(VirtualFile file) {
                return ftManager.getFileTypeByFile(file) instanceof XmlFileType;
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }
}

