/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.Forceable;
import com.intellij.util.io.PagePool;
import com.intellij.util.io.RandomAccessDataFile;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.IOException;

class RecordsTable
implements Disposable,
Forceable {
    private static final int FIRST_RECORD = 1;
    private static final int HEADER_MAGIC_OFFSET = 0;
    private static final int HEADER_VERSION_OFFSET = 4;
    private static final int CONNECTED_MAGIC = 313341156;
    private static final int VERSION = 3;
    private static final int SAFELY_CLOSED_MAGIC = 523190098;
    private static final int ADDRESS_OFFSET = 0;
    private static final int SIZE_OFFSET = 8;
    private static final int CAPACITY_OFFSET = 12;
    private static final int RECORD_SIZE = 16;
    private static final byte[] ZEROES = new byte[16];
    private final RandomAccessDataFile myStorage;
    private TIntArrayList myFreeRecordsList = null;
    private boolean myIsDirty = false;

    public RecordsTable(File storageFilePath, PagePool pool) throws IOException {
        this.myStorage = new RandomAccessDataFile(storageFilePath, pool);
        if (this.myStorage.length() == 0L) {
            this.cleanRecord(0);
            this.myIsDirty = true;
        } else if (this.myStorage.getInt(0L) != 523190098) {
            this.myStorage.dispose();
            throw new IOException("Records table for '" + storageFilePath + "' haven't been closed correctly. Rebuild required.");
        }
    }

    public void markDirty() {
        if (!this.myIsDirty) {
            this.myIsDirty = true;
            this.myStorage.putInt(0L, 313341156);
        }
    }

    public int createNewRecord() throws IOException {
        this.markDirty();
        this.ensureFreeRecordsScanned();
        if (this.myFreeRecordsList.isEmpty()) {
            int filelength = (int)this.myStorage.length();
            if (filelength % 16 != 0) {
                throw new IOException("Corrupted records");
            }
            int result = filelength / 16;
            this.cleanRecord(result);
            return result;
        }
        int result = this.myFreeRecordsList.remove(this.myFreeRecordsList.size() - 1);
        assert (this.getSize(result) == -1);
        this.setSize(result, 0);
        return result;
    }

    private void ensureFreeRecordsScanned() {
        if (this.myFreeRecordsList == null) {
            this.myFreeRecordsList = this.scanForFreeRecords();
        }
    }

    private TIntArrayList scanForFreeRecords() {
        int filelength = (int)this.myStorage.length();
        assert (filelength % 16 == 0);
        TIntArrayList result = new TIntArrayList();
        int lastRecord = filelength / 16;
        for (int i = 1; i < lastRecord; ++i) {
            if (this.getSize(i) != -1) continue;
            result.add(i);
        }
        return result;
    }

    private void cleanRecord(int record) {
        this.myStorage.put(record * 16, ZEROES, 0, 16);
    }

    public long getAddress(int record) {
        return this.myStorage.getLong(record * 16 + 0);
    }

    public int getSize(int record) {
        return this.myStorage.getInt(record * 16 + 8);
    }

    public int getCapacity(int record) {
        return this.myStorage.getInt(record * 16 + 12);
    }

    public void setAddress(int record, long address) {
        this.markDirty();
        this.myStorage.putLong(record * 16 + 0, address);
    }

    public void setCapacity(int record, int capacity) {
        this.markDirty();
        this.myStorage.putInt(record * 16 + 12, capacity);
    }

    public void setSize(int record, int size) {
        this.markDirty();
        this.myStorage.putInt(record * 16 + 8, size);
    }

    public void deleteRecord(int record) {
        this.ensureFreeRecordsScanned();
        this.setSize(record, -1);
        this.myFreeRecordsList.add(record);
    }

    public int getVersion() {
        return this.myStorage.getInt(4L);
    }

    public void setVersion(int expectedVersion) {
        this.markDirty();
        this.myStorage.putInt(4L, expectedVersion);
    }

    @Override
    public void dispose() {
        this.markClean();
        this.myStorage.dispose();
    }

    @Override
    public void force() {
        this.markClean();
        this.myStorage.force();
    }

    public boolean flushSome(int maxPages) {
        this.myStorage.flushSomePages(maxPages);
        if (!this.myStorage.isDirty()) {
            this.force();
            return true;
        }
        return false;
    }

    @Override
    public boolean isDirty() {
        return this.myIsDirty;
    }

    private void markClean() {
        if (this.myIsDirty) {
            this.myIsDirty = false;
            this.myStorage.putInt(0L, 523190098);
        }
    }

    public int getRecordsCount() {
        return (int)(this.myStorage.length() / 16L);
    }
}

