/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.filters.toplevel;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class PackageFilter
implements ElementFilter {
    public boolean isAcceptable(Object element, PsiElement context) {
        GroovyFile groovyFile;
        PsiElement parent;
        if (context.getParent() != null && !(context.getParent() instanceof PsiErrorElement) && context.getParent().getParent() instanceof GroovyFile && ((GroovyFile)context.getParent().getParent()).getPackageDefinition() == null) {
            if (context.getParent() instanceof GrReferenceExpression) {
                return true;
            }
            return context.getParent() instanceof GrApplicationStatement && ((GrApplicationStatement)context.getParent()).getArguments()[0] instanceof GrReferenceExpression;
        }
        if (context.getTextRange().getStartOffset() == 0 && !(context instanceof OuterLanguageElement)) {
            return true;
        }
        PsiElement leaf = GroovyCompletionUtil.getLeafByOffset(context.getTextRange().getStartOffset() - 1, context);
        if (leaf != null && (parent = leaf.getParent()) instanceof GroovyFile && (groovyFile = (GroovyFile)parent).getPackageDefinition() == null) {
            return GroovyCompletionUtil.isNewStatement(context, false);
        }
        return false;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    @NonNls
    public String toString() {
        return "'package' keyword filter";
    }
}

