/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;

public class GroovyReferenceCharFilter
extends CharFilter {
    @Nullable
    public CharFilter.Result acceptChar(char c, int pefixLength, Lookup lookup) {
        PsiFile psiFile = lookup.getPsiFile();
        if (psiFile != null && !psiFile.getViewProvider().getLanguages().contains(GroovyFileType.GROOVY_LANGUAGE)) {
            return null;
        }
        if (Character.isJavaIdentifierPart(c) || c == '\'') {
            return CharFilter.Result.ADD_TO_PREFIX;
        }
        if (c == '\n' || c == '\t') {
            return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
        }
        return null;
    }
}

