/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsExecution;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsResultEx;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.config.ui.ConfigureCvsGlobalSettingsDialog;
import com.intellij.cvsSupport2.config.ui.CvsConfigurationsListEditor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.cvsSupport2.cvsExecution.ModalityContextImpl;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.errorHandling.CvsException;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.cvsIntegration.CvsResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.errorView.ContentManagerProvider;
import com.intellij.ui.errorView.ErrorViewFactory;
import com.intellij.util.ui.ErrorTreeView;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CvsOperationExecutor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor");
    private final CvsResultEx myResult = new CvsResultEx();
    private final boolean myShowProgress;
    private final Project myProject;
    private final ModalityContext myExecutor;
    private boolean myShowErrors = true;
    private boolean myIsQuietOperation = false;
    @Nullable
    private final CvsConfiguration myConfiguration;

    public CvsOperationExecutor(boolean showProgress, Project project, ModalityState modalityState) {
        this.myProject = project;
        this.myShowProgress = showProgress;
        this.myExecutor = new ModalityContextImpl(modalityState, false);
        this.myConfiguration = project != null ? CvsConfiguration.getInstanceChecked(project) : null;
    }

    public CvsOperationExecutor(boolean showProgress, Project project, ModalityContext modalityContext) {
        this.myProject = project;
        this.myShowProgress = showProgress;
        this.myExecutor = modalityContext;
        this.myConfiguration = project != null ? CvsConfiguration.getInstanceChecked(project) : null;
    }

    public CvsOperationExecutor(Project project) {
        this(true, project, ModalityState.defaultModalityState());
    }

    public CvsOperationExecutor(Project project, ModalityState modalityState) {
        this(true, project, modalityState);
    }

    public void performActionSync(final CvsHandler handler, final CvsOperationExecutorCallback callback) {
        final CvsTabbedWindow tabbedWindow = this.myIsQuietOperation ? null : this.openTabbedWindow(handler);
        final Runnable finish = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CvsOperationExecutor.this.myResult.addAllErrors(handler.getErrorsExceptAborted());
                    CvsOperationExecutor.this.myResult.addAllWarnings(handler.getWarnings());
                    handler.runComplitingActivities();
                    if (CvsOperationExecutor.this.myProject == null || CvsOperationExecutor.this.myProject != null && !CvsOperationExecutor.this.myProject.isDisposed()) {
                        CvsOperationExecutor.this.showErrors(handler.getErrorsExceptAborted(), handler.getWarnings(), tabbedWindow);
                    }
                }
                finally {
                    try {
                        if (CvsOperationExecutor.this.myResult.finishedUnsuccessfully(true, handler)) {
                            callback.executionFinished(false);
                        } else {
                            if (handler.getErrors().isEmpty()) {
                                callback.executionFinishedSuccessfully();
                            }
                            callback.executionFinished(true);
                        }
                    }
                    finally {
                        StatusBar statusBar;
                        if (CvsOperationExecutor.this.myProject != null && handler != CvsHandler.NULL && (statusBar = WindowManager.getInstance().getStatusBar(CvsOperationExecutor.this.myProject)) != null) {
                            statusBar.setInfo(CvsOperationExecutor.getStatusMessage(handler));
                        }
                    }
                }
            }
        };
        final Runnable cvsAction = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (handler == CvsHandler.NULL) {
                        return;
                    }
                    CvsOperationExecutor.setText(CvsBundle.message((String)"progress.text.preparing.for.login", (Object[])new Object[0]));
                    handler.beforeLogin();
                    if (CvsOperationExecutor.this.myResult.finishedUnsuccessfully(false, handler)) {
                        return;
                    }
                    CvsOperationExecutor.setText(CvsBundle.message((String)"progress.text.preparing.for.action", (Object[])new Object[]{handler.getTitle()}));
                    handler.run(CvsOperationExecutor.this.myExecutor);
                    if (CvsOperationExecutor.this.myResult.finishedUnsuccessfully(true, handler)) {
                        return;
                    }
                }
                catch (ProcessCanceledException ex) {
                    CvsOperationExecutor.this.myResult.setIsCanceled();
                }
                finally {
                    callback.executeInProgressAfterAction(CvsOperationExecutor.this.myExecutor);
                }
            }
        };
        if (this.doNotShowProgress()) {
            cvsAction.run();
            this.myExecutor.runInDispatchThread(finish, this.myProject);
        } else {
            PerformInBackgroundOption backgroundOption = handler.getBackgroundOption(this.myProject);
            if (backgroundOption != null) {
                Task.Backgroundable task = new Task.Backgroundable(this.myProject, handler.getTitle(), handler.canBeCanceled(), backgroundOption){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/cvsSupport2/cvsExecution/CvsOperationExecutor$3.run must not be null");
                        }
                        cvsAction.run();
                    }

                    public void onSuccess() {
                        finish.run();
                    }
                };
                ProgressManager.getInstance().run((Task)task);
            } else if (ProgressManager.getInstance().runProcessWithProgressSynchronously(cvsAction, handler.getTitle(), handler.canBeCanceled(), this.myProject)) {
                finish.run();
            }
        }
    }

    private static void setText(String text) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setText(text);
        }
    }

    private boolean doNotShowProgress() {
        return CvsOperationExecutor.isInProgress() || CvsOperationExecutor.isInTestMode() || !this.myShowProgress || !ApplicationManager.getApplication().isDispatchThread();
    }

    private static boolean isInTestMode() {
        return ApplicationManager.getApplication().isUnitTestMode();
    }

    private static boolean isInProgress() {
        return ProgressManager.getInstance().getProgressIndicator() != null;
    }

    protected void showErrors(List<VcsException> errors, CvsTabbedWindow tabbedWindow) {
        this.showErrors(errors, new ArrayList<VcsException>(), tabbedWindow);
    }

    protected void showErrors(List<VcsException> errors, List<VcsException> warnings, final CvsTabbedWindow tabbedWindow) {
        if (!this.myShowErrors || this.myIsQuietOperation) {
            return;
        }
        if (tabbedWindow == null) {
            if (errors.isEmpty() && warnings.isEmpty()) {
                return;
            }
            ArrayList<String> messages = new ArrayList<String>();
            for (VcsException error : errors) {
                if (StringUtil.isEmptyOrSpaces((String)error.getMessage())) continue;
                messages.add(error.getMessage());
            }
            for (VcsException error : warnings) {
                if (StringUtil.isEmptyOrSpaces((String)error.getMessage())) continue;
                messages.add(error.getMessage());
            }
            String errorMessage = StringUtil.join(messages, (String)"\n");
            Messages.showErrorDialog((String)errorMessage, (String)"CVS error");
            return;
        }
        if (errors.isEmpty() && warnings.isEmpty()) {
            tabbedWindow.hideErrors();
        } else {
            ErrorTreeView errorTreeView = tabbedWindow.addErrorsTreeView(ErrorViewFactory.SERVICE.getInstance().createErrorTreeView(this.myProject, null, true, new AnAction[]{(DefaultActionGroup)ActionManager.getInstance().getAction("CvsActions")}, new AnAction[]{new AnAction(CvsBundle.message((String)"configure.global.cvs.settings.action.name", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/nodes/cvs_global.png")){

                public void actionPerformed(AnActionEvent e) {
                    new ConfigureCvsGlobalSettingsDialog().show();
                }
            }, new ReconfigureCvsRootAction()}, new ContentManagerProvider(){

                public ContentManager getParentContent() {
                    return tabbedWindow.getContentManager();
                }
            }));
            CvsOperationExecutor.fillErrors(errors, warnings, errorTreeView);
            tabbedWindow.ensureVisible(this.myProject);
        }
    }

    private static void fillErrors(List<VcsException> errors, List<VcsException> warnings, ErrorTreeView errorTreeView) {
        for (VcsException exception : errors) {
            errorTreeView.addMessage(4, exception.getMessages(), exception.getVirtualFile(), -1, -1, (Object)exception);
        }
        for (VcsException exception : warnings) {
            errorTreeView.addMessage(5, exception.getMessages(), exception.getVirtualFile(), -1, -1, (Object)exception);
        }
    }

    @NotNull
    private static Editor createView(Project project) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = editorFactory.createDocument((CharSequence)"");
        Editor result = editorFactory.createViewer(document, project);
        EditorSettings editorSettings = result.getSettings();
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setFoldingOutlineShown(false);
        Editor editor = result;
        if (editor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/cvsSupport2/cvsExecution/CvsOperationExecutor.createView must not return null");
        }
        return editor;
    }

    private static String getStatusMessage(CvsHandler handler) {
        String actionName = handler.getTitle();
        if (handler.getErrors().isEmpty()) {
            return CvsBundle.message((String)"status.text.action.completed", (Object[])new Object[]{actionName});
        }
        return CvsBundle.message((String)"status.text.action.completed.with.errors", (Object[])new Object[]{actionName});
    }

    @Nullable
    public CvsTabbedWindow openTabbedWindow(final CvsHandler output) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (this.myProject != null) {
            if (this.myConfiguration != null && this.myConfiguration.SHOW_OUTPUT && !this.myIsQuietOperation) {
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    this.connectToOutput(output);
                } else {
                    ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            CvsOperationExecutor.this.connectToOutput(output);
                        }
                    }, ModalityState.defaultModalityState());
                }
            }
            if (!this.myProject.isDisposed()) {
                return CvsTabbedWindow.getInstance(this.myProject);
            }
        }
        return null;
    }

    private void connectToOutput(CvsHandler output) {
        CvsTabbedWindow tabbedWindow = CvsTabbedWindow.getInstance(this.myProject);
        Editor editor = tabbedWindow.getOutput();
        if (editor == null) {
            output.connectToOutputView(tabbedWindow.addOutput(CvsOperationExecutor.createView(this.myProject)), this.myProject);
        } else {
            output.connectToOutputView(editor, this.myProject);
        }
    }

    public VcsException getFirstError() {
        return this.myResult.composeError();
    }

    public boolean hasNoErrors() {
        return this.myResult.hasNoErrors();
    }

    public CvsResult getResult() {
        return this.myResult;
    }

    public void setShowErrors(boolean showErrors) {
        this.myShowErrors = showErrors;
    }

    public void setIsQuietOperation(boolean isQuietOperation) {
        this.myIsQuietOperation = isQuietOperation;
    }

    private class ReconfigureCvsRootAction
    extends AnAction {
        public ReconfigureCvsRootAction() {
            super(CvsBundle.message((String)"action.name.reconfigure.cvs.root", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/nodes/cvs_roots.png"));
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Object data = ErrorTreeView.CURRENT_EXCEPTION_DATA_KEY.getData(e.getDataContext());
            e.getPresentation().setEnabled(data instanceof CvsException);
        }

        public void actionPerformed(AnActionEvent e) {
            Object data = ErrorTreeView.CURRENT_EXCEPTION_DATA_KEY.getData(e.getDataContext());
            CvsConfigurationsListEditor.reconfigureCvsRoot(((CvsException)((Object)data)).getCvsRoot(), CvsOperationExecutor.this.myProject);
        }
    }
}

