/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsBrowser;

import com.intellij.cvsSupport2.cvsBrowser.CvsTree;
import com.intellij.cvsSupport2.cvsBrowser.CvsTreeModel;
import com.intellij.cvsSupport2.cvsBrowser.GetContentCallback;
import com.intellij.cvsSupport2.cvsBrowser.LoadingNode;
import com.intellij.cvsSupport2.cvsBrowser.LoginAbortedException;
import com.intellij.cvsSupport2.cvsBrowser.RemoteResourceDataProvider;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.CvsListenerWithProgress;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Future;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CvsElement
extends DefaultMutableTreeNode
implements CvsTabbedWindow.DeactivateListener {
    protected RemoteResourceDataProvider myDataProvider;
    private boolean myLoading;
    protected String myName;
    protected String myPath;
    private final Icon myIcon;
    private final Icon myExpandedIcon;
    private boolean myCanBecheckedOut = true;
    private CvsTreeModel myModel;
    private final Project myProject;
    private Future<?> myLoadingThreadFuture;
    private final Alarm myPeriodAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);

    public CvsElement(Icon icon, Icon expandedIcon, Project project) {
        this.myIcon = icon;
        this.myExpandedIcon = expandedIcon;
        this.myProject = project;
    }

    public CvsElement(Icon icon, Project project) {
        this(icon, icon, project);
    }

    public void setModel(CvsTreeModel model) {
        this.myModel = model;
    }

    @Override
    public void deactivated() {
        this.myPeriodAlarm.cancelAllRequests();
    }

    public void setDataProvider(RemoteResourceDataProvider dataProvider) {
        this.myDataProvider = dataProvider;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    public void setPath(String path) {
        this.myPath = path.startsWith("./") ? path.substring(2) : path;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.getMyChildren().get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.getMyChildren().size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getMyChildren().indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        if (this.alreadyLoaded()) {
            return this.getChildCount() > 0;
        }
        return !this.myDataProvider.equals(RemoteResourceDataProvider.NOT_EXPANDABLE);
    }

    private boolean alreadyLoaded() {
        return this.children != null;
    }

    public Enumeration children() {
        return new Vector(this.getMyChildren()).elements();
    }

    private List getMyChildren() {
        if (this.children == null) {
            final LoadingNode loadingNode = new LoadingNode();
            this.getModel().insertNodeInto(loadingNode, this, 0);
            this.myLoading = true;
            this.myModel.getCvsTree().getTree().setEnabled(false);
            this.myLoadingThreadFuture = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    CvsElement.this.myDataProvider.fillContentFor(CvsElement.this, CvsElement.this.myProject, new MyGetContentCallback(loadingNode));
                }
            });
            Runnable periodRequest = new Runnable(){

                @Override
                public void run() {
                    if (CvsElement.this.isNodeChild(loadingNode)) {
                        loadingNode.updatePeriod();
                        ((DefaultTreeModel)CvsElement.this.myModel.getCvsTree().getTree().getModel()).nodeChanged(loadingNode);
                        CvsElement.this.myPeriodAlarm.addRequest((Runnable)this, 200);
                    }
                }
            };
            this.myPeriodAlarm.addRequest(periodRequest, 200);
            this.myModel.getCvsTree().addListener(this);
        }
        return this.children;
    }

    public CvsTreeModel getModel() {
        return this.myModel;
    }

    @Override
    public String toString() {
        return this.myName;
    }

    public Icon getIcon(boolean expanded) {
        return expanded ? this.myExpandedIcon : this.myIcon;
    }

    public String getElementPath() {
        return this.myPath;
    }

    public String getCheckoutPath() {
        return this.getElementPath();
    }

    public boolean canBeCheckedOut() {
        return this.myCanBecheckedOut;
    }

    public void cannotBeCheckedOut() {
        this.myCanBecheckedOut = false;
    }

    public String getCheckoutDirectoryName() {
        return new File(this.getCheckoutPath()).getName();
    }

    public VirtualFile getVirtualFile() {
        return null;
    }

    public String createPathForChild(String name) {
        return this.getElementPath() + "/" + name;
    }

    public File getCvsLightFile() {
        return null;
    }

    public void release() {
        if (this.myLoadingThreadFuture != null) {
            this.myLoadingThreadFuture.cancel(true);
        }
        if (this.children == null) {
            return;
        }
        Object[] nodes = this.children.toArray();
        for (int i = 0; i < nodes.length; ++i) {
            Object node = nodes[i];
            if (!(node instanceof CvsElement)) continue;
            ((CvsElement)node).release();
        }
    }

    public Component getTree() {
        return this.myModel.getCvsTree().getTree();
    }

    public boolean isLoading() {
        return this.myLoading;
    }

    private class MyGetContentCallback
    implements GetContentCallback,
    CvsTabbedWindow.DeactivateListener {
        private final LoadingNode myLoadingNode;
        private CvsListenerWithProgress myListener;

        public MyGetContentCallback(LoadingNode loadingNode) {
            this.myLoadingNode = loadingNode;
            CvsElement.this.myModel.getCvsTree().addListener(this);
        }

        @Override
        public void deactivated() {
            if (this.myListener != null) {
                this.myListener.indirectCancel();
            }
        }

        @Override
        public void useForCancel(CvsListenerWithProgress listener) {
            this.myListener = listener;
        }

        @Override
        public void appendDirectoryContent(List<CvsElement> directoryContent) {
            this.fill(directoryContent);
        }

        @Override
        public void fillDirectoryContent(List<CvsElement> content) {
        }

        private void fill(final List<CvsElement> content) {
            CvsElement.this.myPeriodAlarm.cancelAllRequests();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int offset = CvsElement.this.getChildCount();
                    for (int i = 0; i < content.size(); ++i) {
                        CvsElement.this.insert((MutableTreeNode)content.get(i), i + offset);
                    }
                    if (offset <= 1 && CvsElement.this.isNodeChild(MyGetContentCallback.this.myLoadingNode)) {
                        CvsElement.this.remove(MyGetContentCallback.this.myLoadingNode);
                    }
                    CvsElement.this.getModel().reload(CvsElement.this);
                    CvsElement.this.getModel().getCvsTree().getTree().expandPath(new TreePath(CvsElement.this.getModel().getPathToRoot(CvsElement.this)));
                }
            });
        }

        @Override
        public void finished() {
            if (CvsElement.this.getParent() == null) {
                CvsElement.this.getModel().selectRoot();
            }
            CvsElement.this.myModel.getCvsTree().removeListener(this);
            CvsElement.this.myLoading = false;
            CvsElement.this.myPeriodAlarm.cancelAllRequests();
            CvsElement.this.myModel.getCvsTree().getTree().setEnabled(true);
            CvsElement.this.myLoadingThreadFuture = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (CvsElement.this.isNodeChild(MyGetContentCallback.this.myLoadingNode)) {
                        CvsElement.this.remove(MyGetContentCallback.this.myLoadingNode);
                        CvsElement.this.getModel().reload(CvsElement.this);
                    }
                }
            });
        }

        @Override
        public void loginAborted() {
            CvsElement.this.myModel.getCvsTree().removeListener(this);
            CvsTree cvsTree = CvsElement.this.myModel.getCvsTree();
            if (cvsTree == null) {
                throw new LoginAbortedException();
            }
            cvsTree.onLoginAborted();
        }
    }
}

