/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.DebuggerFramesList;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class XDebuggerFramesList
extends DebuggerFramesList {
    private XStackFrame mySelectedFrame;

    @Override
    protected ListCellRenderer createListRenderer() {
        return new XDebuggerFrameListRenderer();
    }

    @Override
    protected void onFrameChanged(Object selectedValue) {
        if (this.mySelectedFrame != selectedValue) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    XDebuggerFramesList.this.repaint();
                }
            });
            this.mySelectedFrame = selectedValue instanceof XStackFrame ? (XStackFrame)selectedValue : null;
        }
    }

    private static class XDebuggerFrameListRenderer
    extends ColoredListCellRenderer {
        private XDebuggerFrameListRenderer() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value == null) {
                this.append(XDebuggerBundle.message((String)"stack.frame.loading.text", (Object[])new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
                return;
            }
            if (value instanceof String) {
                this.append((String)value, SimpleTextAttributes.ERROR_ATTRIBUTES);
                return;
            }
            XStackFrame stackFrame = (XStackFrame)value;
            stackFrame.customizePresentation((SimpleColoredComponent)this);
        }
    }
}

