/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.text.StringTokenizer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.Icon;

public class LabeledIcon
implements Icon {
    private final Icon myIcon;
    private final String myMnemonic;
    private final String[] myStrings;
    private int myIconTextGap = 0;

    public LabeledIcon(Icon icon, String text, String mnemonic) {
        this.myIcon = icon;
        this.myMnemonic = mnemonic;
        if (text != null) {
            StringTokenizer tokenizer = new StringTokenizer(text, "\n");
            this.myStrings = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                this.myStrings[i] = tokenizer.nextToken();
                ++i;
            }
        } else {
            this.myStrings = null;
        }
    }

    public void setIconTextGap(int iconTextGap) {
        this.myIconTextGap = iconTextGap;
    }

    public int getIconTextGap() {
        return this.myIconTextGap;
    }

    @Override
    public int getIconHeight() {
        return this.myIcon.getIconHeight() + this.getTextHeight() + this.myIconTextGap;
    }

    @Override
    public int getIconWidth() {
        return Math.max(this.myIcon.getIconWidth(), this.getTextWidth());
    }

    private int getTextHeight() {
        if (this.myStrings != null) {
            Font font = UIUtil.getLabelFont();
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            return fontMetrics.getHeight() * this.myStrings.length;
        }
        return 0;
    }

    private int getTextWidth() {
        if (this.myStrings != null) {
            int width = 0;
            Font font = UIUtil.getLabelFont();
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            for (String string : this.myStrings) {
                width = fontMetrics.stringWidth(string);
            }
            if (this.myMnemonic != null) {
                width += fontMetrics.stringWidth(this.myMnemonic);
            }
            return width;
        }
        return 0;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int iconWidth;
        int width = this.getIconWidth();
        if (width > (iconWidth = this.myIcon.getIconWidth())) {
            this.myIcon.paintIcon(c, g, x + (width - iconWidth) / 2, y);
        } else {
            this.myIcon.paintIcon(c, g, x, y);
        }
        if (this.myStrings != null) {
            Font font = UIUtil.getLabelFont();
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            g.setFont(fontMetrics.getFont());
            if (this.myMnemonic != null) {
                width -= fontMetrics.stringWidth(this.myMnemonic);
            }
            g.setColor(UIUtil.getLabelForeground());
            y += this.myIcon.getIconHeight() + fontMetrics.getMaxAscent() + this.myIconTextGap;
            for (String string : this.myStrings) {
                g.drawString(string, x + (width - fontMetrics.stringWidth(string)) / 2, y);
                y += fontMetrics.getHeight();
            }
            if (this.myMnemonic != null) {
                g.setColor(UIUtil.getTextInactiveTextColor());
                int offset = this.getTextWidth() - fontMetrics.stringWidth(this.myMnemonic);
                g.drawString(this.myMnemonic, x + offset, y -= fontMetrics.getHeight());
            }
        }
    }
}

