/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ProjectTopics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.DeferredIconImpl;
import com.intellij.ui.IconDeferrer;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class IconDeferrerImpl
extends IconDeferrer {
    private final Object LOCK = new Object();
    private final Map<Object, Icon> myIconsCache = new HashMap<Object, Icon>();
    private static final ThreadLocal<Boolean> myEvaluationIsInProgress = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public IconDeferrerImpl(MessageBus bus) {
        MessageBusConnection connection = bus.connect();
        connection.setDefaultHandler(new MessageHandler(){

            public void handle(Method event, Object ... params) {
                IconDeferrerImpl.this.invalidateAllIcons();
            }
        });
        connection.subscribe(ProjectTopics.MODIFICATION_TRACKER, (Object)new PsiModificationTracker.Listener(){

            public void modificationCountChanged() {
                IconDeferrerImpl.this.invalidateAllIcons();
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(List<? extends VFileEvent> events) {
            }

            public void after(List<? extends VFileEvent> events) {
                IconDeferrerImpl.this.clear();
            }
        });
        connection.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener.Adapter(){

            @Override
            public void afterProjectClosed(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/IconDeferrerImpl$4.afterProjectClosed must not be null");
                }
                IconDeferrerImpl.this.clear();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myIconsCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateAllIcons() {
        Object object = this.LOCK;
        synchronized (object) {
            for (Icon icon : this.myIconsCache.values()) {
                if (!(icon instanceof DeferredIconImpl)) continue;
                ((DeferredIconImpl)((Object)icon)).invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Icon defer(Icon base, T param, Function<T, Icon> f) {
        if (myEvaluationIsInProgress.get().booleanValue()) {
            return (Icon)f.fun(param);
        }
        Object object = this.LOCK;
        synchronized (object) {
            Object result = this.myIconsCache.get(param);
            if (result == null) {
                result = new DeferredIconImpl<T>(base, param, f);
                this.myIconsCache.put(param, (Icon)result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void evaluateDeferredInReadAction(Runnable runnable) {
        try {
            myEvaluationIsInProgress.set(Boolean.TRUE);
            ApplicationManager.getApplication().runReadAction(runnable);
        }
        finally {
            myEvaluationIsInProgress.set(Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void evaluateDeferred(Runnable runnable) {
        try {
            myEvaluationIsInProgress.set(Boolean.TRUE);
            runnable.run();
        }
        finally {
            myEvaluationIsInProgress.set(Boolean.FALSE);
        }
    }
}

