/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.classMembers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.refactoring.util.classMembers.ClassThisReferencesVisitor;

public class ElementNeedsThis
extends ClassThisReferencesVisitor {
    private boolean myResult = false;
    private final PsiElement myMember;

    public ElementNeedsThis(PsiClass aClass, PsiElement member) {
        super(aClass);
        this.myMember = member;
    }

    public ElementNeedsThis(PsiClass aClass) {
        super(aClass);
        this.myMember = null;
    }

    public boolean usesMembers() {
        return this.myResult;
    }

    @Override
    protected void visitClassMemberReferenceElement(PsiMember classMember, PsiJavaCodeReferenceElement classMemberReference) {
        if (classMember == null || classMember.equals(this.myMember)) {
            return;
        }
        if (classMember.hasModifierProperty("static")) {
            return;
        }
        this.myResult = true;
    }

    @Override
    protected void visitExplicitThis(PsiClass referencedClass, PsiThisExpression reference) {
        this.myResult = true;
    }

    @Override
    protected void visitExplicitSuper(PsiClass referencedClass, PsiSuperExpression reference) {
        this.myResult = true;
    }

    public void visitElement(PsiElement element) {
        if (this.myResult) {
            return;
        }
        super.visitElement(element);
    }
}

