/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.beanProperties;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateBeanPropertyFix
implements LocalQuickFix,
IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.beanProperties.CreateBeanPropertyFix");
    protected final String myPropertyName;
    @NotNull
    protected final PsiClass myPsiClass;
    @NotNull
    protected final PsiType myType;

    public static LocalQuickFix[] createFixes(String propertyName, @NotNull PsiClass psiClass, @Nullable PsiType type, boolean createSetter) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/beanProperties/CreateBeanPropertyFix.createFixes must not be null");
        }
        return (LocalQuickFix[])CreateBeanPropertyFix.create(propertyName, psiClass, type, createSetter);
    }

    public static IntentionAction[] createActions(String propertyName, @NotNull PsiClass psiClass, @Nullable PsiType type, boolean createSetter) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/beanProperties/CreateBeanPropertyFix.createActions must not be null");
        }
        return (IntentionAction[])CreateBeanPropertyFix.create(propertyName, psiClass, type, createSetter);
    }

    private static Object[] create(String propertyName, PsiClass psiClass, PsiType type, final boolean createSetter) {
        if (type == null) {
            Project project = psiClass.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiClass aClass = facade.findClass("java.lang.String", GlobalSearchScope.allScope((Project)project));
            if (aClass == null) {
                return new CreateBeanPropertyFix[0];
            }
            type = facade.getElementFactory().createType(aClass);
        }
        if (psiClass.isInterface()) {
            return new CreateBeanPropertyFix[]{new CreateBeanPropertyFix(propertyName, psiClass, type){

                @Override
                protected void doFix() throws IncorrectOperationException {
                    this.createSetter(false);
                }

                @NotNull
                public String getName() {
                    String string = QuickFixBundle.message("create.writable.property", this.myPropertyName);
                    if (string == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/beanProperties/CreateBeanPropertyFix$1.getName must not return null");
                    }
                    return string;
                }
            }};
        }
        return new CreateBeanPropertyFix[]{new CreateBeanPropertyFix(propertyName, psiClass, type){

            @NotNull
            public String getName() {
                String string = QuickFixBundle.message("create.readable.writable.property.with.field", this.myPropertyName);
                if (string == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/impl/beanProperties/CreateBeanPropertyFix$2.getName must not return null");
                }
                return string;
            }

            @Override
            protected void doFix() throws IncorrectOperationException {
                this.createField();
                this.createSetter(true);
                this.createGetter(true);
            }
        }, new CreateBeanPropertyFix(propertyName, psiClass, type){

            @Override
            protected void doFix() throws IncorrectOperationException {
                if (createSetter) {
                    this.createSetter(false);
                } else {
                    this.createGetter(false);
                }
            }

            @NotNull
            public String getName() {
                String string = QuickFixBundle.message(createSetter ? "create.writable.property" : "create.readable.property", this.myPropertyName);
                if (string == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/impl/beanProperties/CreateBeanPropertyFix$3.getName must not return null");
                }
                return string;
            }
        }, new CreateBeanPropertyFix(propertyName, psiClass, type){

            @Override
            protected void doFix() throws IncorrectOperationException {
                this.createField();
                if (createSetter) {
                    this.createSetter(true);
                } else {
                    this.createGetter(true);
                }
            }

            @NotNull
            public String getName() {
                String string = QuickFixBundle.message(createSetter ? "create.writable.property.with.field" : "create.readable.property.with.field", this.myPropertyName);
                if (string == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/impl/beanProperties/CreateBeanPropertyFix$4.getName must not return null");
                }
                return string;
            }
        }};
    }

    protected CreateBeanPropertyFix(String propertyName, @NotNull PsiClass psiClass, @NotNull PsiType type) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/beanProperties/CreateBeanPropertyFix.<init> must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/beanProperties/CreateBeanPropertyFix.<init> must not be null");
        }
        this.myPropertyName = propertyName;
        this.myPsiClass = psiClass;
        this.myType = type;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/beanProperties/CreateBeanPropertyFix.getFamilyName must not return null");
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/beanProperties/CreateBeanPropertyFix.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/beanProperties/CreateBeanPropertyFix.applyFix must not be null");
        }
        this.applyFix(project);
    }

    private void applyFix(Project project) {
        new WriteCommandAction.Simple(project, this.getName(), new PsiFile[]{this.myPsiClass.getContainingFile()}){

            protected void run() throws Throwable {
                try {
                    CreateBeanPropertyFix.this.doFix();
                }
                catch (IncorrectOperationException e) {
                    LOG.error("Cannot create property", (Throwable)e);
                }
            }
        }.execute();
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/beanProperties/CreateBeanPropertyFix.getText must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/beanProperties/CreateBeanPropertyFix.isAvailable must not be null");
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/beanProperties/CreateBeanPropertyFix.invoke must not be null");
        }
        this.applyFix(project);
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected abstract void doFix() throws IncorrectOperationException;

    private String getFieldName() {
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.myPsiClass.getProject());
        return styleManager.suggestVariableName((VariableKind)VariableKind.FIELD, (String)this.myPropertyName, null, (PsiType)this.myType).names[0];
    }

    protected PsiElement createSetter(boolean createField) throws IncorrectOperationException {
        String text;
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myPsiClass.getProject()).getElementFactory();
        String methodName = PropertyUtil.suggestSetterName((String)this.myPropertyName);
        String typeName = this.myType.getCanonicalText();
        boolean isInterface = this.myPsiClass.isInterface();
        if (isInterface) {
            text = "public void " + methodName + "(" + typeName + " " + this.myPropertyName + ");";
        } else if (createField) {
            String fieldName = this.getFieldName();
            if (fieldName.equals(this.myPropertyName)) {
                fieldName = "this." + fieldName;
            }
            text = "public void " + methodName + "(" + typeName + " " + this.myPropertyName + ") {" + fieldName + "=" + this.myPropertyName + ";}";
        } else {
            text = "public void " + methodName + "(" + typeName + " " + this.myPropertyName + ") {}";
        }
        PsiMethod method = elementFactory.createMethodFromText(text, null);
        PsiMethod psiElement = (PsiMethod)this.myPsiClass.add((PsiElement)method);
        if (!isInterface && !createField) {
            CreateFromUsageUtils.setupMethodBody(psiElement);
        }
        return psiElement;
    }

    protected PsiElement createGetter(boolean createField) throws IncorrectOperationException {
        String text;
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myPsiClass.getProject()).getElementFactory();
        String methodName = PropertyUtil.suggestGetterName((String)this.myPropertyName, (PsiType)this.myType);
        String typeName = this.myType.getCanonicalText();
        if (createField) {
            String fieldName = this.getFieldName();
            text = "public " + typeName + " " + methodName + "() { return " + fieldName + "; }";
        } else {
            text = "public " + typeName + " " + methodName + "() { return null; }";
        }
        PsiMethod method = elementFactory.createMethodFromText(text, null);
        PsiMethod psiElement = (PsiMethod)this.myPsiClass.add((PsiElement)method);
        if (!createField) {
            CreateFromUsageUtils.setupMethodBody(psiElement);
        }
        return psiElement;
    }

    protected PsiElement createField() throws IncorrectOperationException {
        String fieldName = this.getFieldName();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myPsiClass.getProject()).getElementFactory();
        PsiField psiField = elementFactory.createField(fieldName, this.myType);
        return this.myPsiClass.add((PsiElement)psiField);
    }
}

