/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Wrap;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;

public abstract class WrappingStrategy {
    public static final WrappingStrategy DO_NOT_WRAP = new WrappingStrategy(null){

        @Override
        protected boolean shouldWrap(IElementType type) {
            return false;
        }
    };
    private final Wrap myWrap;

    public static WrappingStrategy createDoNotWrapCommaStrategy(Wrap wrap) {
        return new WrappingStrategy(wrap){

            @Override
            protected boolean shouldWrap(IElementType type) {
                return type != ElementType.COMMA && type != ElementType.SEMICOLON;
            }
        };
    }

    public WrappingStrategy(Wrap wrap) {
        this.myWrap = wrap;
    }

    public Wrap getWrap(IElementType type) {
        if (this.shouldWrap(type)) {
            return this.myWrap;
        }
        return null;
    }

    protected abstract boolean shouldWrap(IElementType var1);
}

