/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectImport;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectImportWizardStep;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectImportedProjectsStep<T>
extends ProjectImportWizardStep {
    private final JPanel panel;
    protected final ElementsChooser<T> fileChooser = new ElementsChooser<T>(true){

        @Override
        protected String getItemText(@NotNull T item) {
            if (item == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/projectImport/SelectImportedProjectsStep$1.getItemText must not be null");
            }
            return SelectImportedProjectsStep.this.getElementText(item);
        }

        @Override
        protected Icon getItemIcon(T item) {
            return SelectImportedProjectsStep.this.getElementIcon(item);
        }
    };
    private final JCheckBox openModuleSettingsCheckBox;

    public SelectImportedProjectsStep(WizardContext context) {
        super(context);
        this.panel = new JPanel((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.panel.add(this.fileChooser, new GridConstraints(0, 0, 1, 1, 1, 3, 5, 5, null, null, null));
        this.openModuleSettingsCheckBox = new JCheckBox(IdeBundle.message((String)"project.import.show.settings.after", (Object[])new Object[0]));
        this.panel.add((Component)this.openModuleSettingsCheckBox, new GridConstraints(1, 0, 1, 1, 2, 1, 5, 0, null, null, null));
    }

    @Nullable
    protected Icon getElementIcon(T item) {
        return null;
    }

    protected abstract String getElementText(T var1);

    public JComponent getComponent() {
        return this.panel;
    }

    public void updateStep() {
        this.fileChooser.clear();
        for (T element : this.getContext().getList()) {
            this.fileChooser.addElement(element, this.getContext().isMarked(element));
        }
        this.fileChooser.setBorder(BorderFactory.createTitledBorder(IdeBundle.message((String)"project.import.select.title", (Object[])new Object[]{this.getContext().getName()})));
        this.openModuleSettingsCheckBox.setSelected(this.getBuilder().isOpenProjectSettingsAfter());
    }

    public boolean validate() throws ConfigurationException {
        this.getContext().setList(this.fileChooser.getMarkedElements());
        if (this.fileChooser.getMarkedElements().size() == 0) {
            throw new ConfigurationException("Nothing found to import", "Unable to proceed");
        }
        return true;
    }

    public void updateDataModel() {
    }

    public void onStepLeaving() {
        super.onStepLeaving();
        this.getContext().setOpenProjectSettingsAfter(this.openModuleSettingsCheckBox.isSelected());
    }

    public ProjectImportBuilder<T> getContext() {
        return this.getBuilder();
    }
}

