/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.IconLoader;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;

public class PlatformInspectionsConfigurable
implements ErrorsConfigurable {
    private SingleInspectionProfilePanel myPanel;
    private ModifiableModel myProfile;

    @Nls
    public String getDisplayName() {
        return "Inspections";
    }

    public Icon getIcon() {
        return IconLoader.getIcon((String)"/general/configurableErrorHighlighting.png");
    }

    public JComponent createComponent() {
        return this.getPanel();
    }

    public boolean isModified() {
        return this.myPanel != null && this.myPanel.isModified();
    }

    public void apply() throws ConfigurationException {
        this.getPanel().apply();
    }

    public void reset() {
        this.getPanel().reset();
    }

    public void disposeUIResources() {
        if (this.myPanel != null) {
            this.myPanel.disposeUI();
            this.myProfile = null;
            this.myPanel = null;
        }
    }

    @Override
    public void selectProfile(String name) {
    }

    @Override
    public void selectInspectionTool(String selectedToolShortName) {
        this.getPanel().selectInspectionTool(selectedToolShortName);
    }

    @Override
    public Object getSelectedObject() {
        return null;
    }

    public String getHelpTopic() {
        return "preferences.inspections";
    }

    public SingleInspectionProfilePanel getPanel() {
        if (this.myProfile == null) {
            this.myProfile = new InspectionProfileImpl((InspectionProfileImpl)InspectionProfileManager.getInstance().getRootProfile());
        }
        if (this.myPanel == null) {
            this.myPanel = new SingleInspectionProfilePanel(this.myProfile.getName(), this.myProfile);
        }
        return this.myPanel;
    }
}

