/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.impl.ContentImpl;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowImpl
implements ToolWindowEx {
    private final PropertyChangeSupport myChangeSupport;
    private final ToolWindowManagerImpl myToolWindowManager;
    private final String myId;
    private final JComponent myComponent;
    private boolean myAvailable;
    private final ContentManager myContentManager;
    private Icon myIcon = null;
    private static final Content EMPTY_CONTENT = new ContentImpl(new JLabel(), "", false);
    private final ToolWindowContentUi myContentUI;
    private InternalDecorator myDecorator;
    private boolean myHideOnEmptyContent = false;
    private boolean myPlaceholderMode;
    private ToolWindowFactory myContentFactory;
    private ActionCallback myActivation = new ActionCallback.Done();

    ToolWindowImpl(ToolWindowManagerImpl toolWindowManager, String id, boolean canCloseContent, @Nullable JComponent component) {
        this.myToolWindowManager = toolWindowManager;
        this.myChangeSupport = new PropertyChangeSupport(this);
        this.myId = id;
        this.myAvailable = true;
        ContentFactory contentFactory = (ContentFactory)ServiceManager.getService(ContentFactory.class);
        this.myContentUI = new ToolWindowContentUi(this);
        this.myContentManager = contentFactory.createContentManager((ContentUI)this.myContentUI, canCloseContent, toolWindowManager.getProject());
        if (component != null) {
            Content content = contentFactory.createContent(component, "", false);
            this.myContentManager.addContent(content);
            this.myContentManager.setSelectedContent(content, false);
        }
        this.myComponent = this.myContentManager.getComponent();
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.myChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.myChangeSupport.removePropertyChangeListener(l);
    }

    public final void activate(Runnable runnable) {
        this.activate(runnable, true);
    }

    public void activate(@Nullable Runnable runnable, boolean autoFocusContents) {
        this.activate(runnable, autoFocusContents, true);
    }

    public void activate(final @Nullable Runnable runnable, boolean autoFocusContents, boolean forced) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myToolWindowManager.activateToolWindow(this.myId, forced, autoFocusContents);
        if (runnable != null) {
            this.getActivation().doWhenDone(new Runnable(){

                @Override
                public void run() {
                    ToolWindowImpl.this.myToolWindowManager.invokeLater(runnable);
                }
            });
        }
    }

    public final boolean isActive() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myToolWindowManager.isToolWindowActive(this.myId);
    }

    public final void show(final Runnable runnable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myToolWindowManager.showToolWindow(this.myId);
        if (runnable != null) {
            this.getActivation().doWhenDone(new Runnable(){

                @Override
                public void run() {
                    ToolWindowImpl.this.myToolWindowManager.invokeLater(runnable);
                }
            });
        }
    }

    public final void hide(Runnable runnable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myToolWindowManager.hideToolWindow(this.myId, false);
        if (runnable != null) {
            this.myToolWindowManager.invokeLater(runnable);
        }
    }

    public final boolean isVisible() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myToolWindowManager.isToolWindowVisible(this.myId);
    }

    public final ToolWindowAnchor getAnchor() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myToolWindowManager.getToolWindowAnchor(this.myId);
    }

    public final void setAnchor(ToolWindowAnchor anchor, Runnable runnable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myToolWindowManager.setToolWindowAnchor(this.myId, anchor);
        if (runnable != null) {
            this.myToolWindowManager.invokeLater(runnable);
        }
    }

    public boolean isSplitMode() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myToolWindowManager.isSplitMode(this.myId);
    }

    public void setContentUiType(ToolWindowContentUiType type, Runnable runnable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myToolWindowManager.setContentUiType(this.myId, type);
        if (runnable != null) {
            this.myToolWindowManager.invokeLater(runnable);
        }
    }

    public void setDefaultContentUiType(@NotNull ToolWindowContentUiType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowImpl.setDefaultContentUiType must not be null");
        }
        this.myToolWindowManager.setDefaultContentUiType(this, type);
    }

    public ToolWindowContentUiType getContentUiType() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myToolWindowManager.getContentUiType(this.myId);
    }

    public void setSplitMode(boolean isSideTool, @Nullable Runnable runnable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myToolWindowManager.setSideTool(this.myId, isSideTool);
        if (runnable != null) {
            this.myToolWindowManager.invokeLater(runnable);
        }
    }

    public final void setAutoHide(boolean state) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myToolWindowManager.setToolWindowAutoHide(this.myId, state);
    }

    public final boolean isAutoHide() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myToolWindowManager.isToolWindowAutoHide(this.myId);
    }

    public final boolean isFloating() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myToolWindowManager.isToolWindowFloating(this.myId);
    }

    public final ToolWindowType getType() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myToolWindowManager.getToolWindowType(this.myId);
    }

    public final void setType(ToolWindowType type, Runnable runnable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myToolWindowManager.setToolWindowType(this.myId, type);
        if (runnable != null) {
            this.myToolWindowManager.invokeLater(runnable);
        }
    }

    @Override
    public final ToolWindowType getInternalType() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myToolWindowManager.getToolWindowInternalType(this.myId);
    }

    @Override
    public void stretchWidth(int value) {
        this.myToolWindowManager.stretchWidth(this, value);
    }

    @Override
    public void stretchHeight(int value) {
        this.myToolWindowManager.stretchHeight(this, value);
    }

    @Override
    public InternalDecorator getDecorator() {
        return this.myDecorator;
    }

    public final void setAvailable(boolean available, Runnable runnable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Boolean oldAvailable = this.myAvailable ? Boolean.TRUE : Boolean.FALSE;
        this.myAvailable = available;
        this.myChangeSupport.firePropertyChange("available", oldAvailable, this.myAvailable ? Boolean.TRUE : Boolean.FALSE);
        if (runnable != null) {
            this.myToolWindowManager.invokeLater(runnable);
        }
    }

    public void installWatcher(ContentManager contentManager) {
        new ContentManagerWatcher(this, contentManager);
    }

    public final boolean isAvailable() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myAvailable && this.myComponent != null;
    }

    public final JComponent getComponent() {
        return this.myComponent;
    }

    public ContentManager getContentManager() {
        return this.myContentManager;
    }

    public ToolWindowContentUi getContentUI() {
        return this.myContentUI;
    }

    public final Icon getIcon() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myIcon;
    }

    public final String getId() {
        return this.myId;
    }

    public final String getTitle() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.getSelectedContent().getDisplayName();
    }

    public final void setIcon(Icon icon) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Icon oldIcon = this.getIcon();
        this.getSelectedContent().setIcon(icon);
        this.myIcon = icon;
        this.myChangeSupport.firePropertyChange("icon", oldIcon, icon);
    }

    public final void setTitle(String title) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String oldTitle = this.getTitle();
        this.getSelectedContent().setDisplayName(title);
        this.myChangeSupport.firePropertyChange("title", oldTitle, title);
    }

    private Content getSelectedContent() {
        Content selected = this.getContentManager().getSelectedContent();
        return selected != null ? selected : EMPTY_CONTENT;
    }

    public void setDecorator(InternalDecorator decorator) {
        this.myDecorator = decorator;
    }

    public void fireActivated() {
        if (this.myDecorator != null) {
            this.myDecorator.fireActivated();
        }
    }

    public void fireHidden() {
        if (this.myDecorator != null) {
            this.myDecorator.fireHidden();
        }
    }

    public void fireHiddenSide() {
        if (this.myDecorator != null) {
            this.myDecorator.fireHiddenSide();
        }
    }

    public ToolWindowManagerImpl getToolWindowManager() {
        return this.myToolWindowManager;
    }

    @Nullable
    public ActionGroup getPopupGroup() {
        return this.myDecorator != null ? this.myDecorator.createPopupGroup() : null;
    }

    public void setDefaultState(@Nullable ToolWindowAnchor anchor, @Nullable ToolWindowType type, @Nullable Rectangle floatingBounds) {
        this.myToolWindowManager.setDefaultState(this, anchor, type, floatingBounds);
    }

    public void setToHideOnEmptyContent(boolean hideOnEmpty) {
        this.myHideOnEmptyContent = hideOnEmpty;
    }

    public boolean isToHideOnEmptyContent() {
        return this.myHideOnEmptyContent;
    }

    public boolean isDisposed() {
        return this.myContentManager.isDisposed();
    }

    public boolean isPlaceholderMode() {
        return this.myPlaceholderMode;
    }

    public void setPlaceholderMode(boolean placeholderMode) {
        this.myPlaceholderMode = placeholderMode;
    }

    public ActionCallback getActivation() {
        return this.myActivation;
    }

    public ActionCallback setActivation(ActionCallback activation) {
        if (this.myActivation != null && !this.myActivation.isProcessed() && !this.myActivation.equals(activation)) {
            this.myActivation.setRejected();
        }
        this.myActivation = activation;
        return this.myActivation;
    }

    public void setContentFactory(ToolWindowFactory contentFactory) {
        this.myContentFactory = contentFactory;
    }

    public void ensureContentInitialized() {
        if (this.myContentFactory != null) {
            this.getContentManager().removeAllContents(false);
            this.myContentFactory.createToolWindowContent(this.myToolWindowManager.getProject(), (ToolWindow)this);
            this.myContentFactory = null;
        }
    }

    public void showContentPopup(InputEvent inputEvent) {
        this.myContentUI.showContentPopup(inputEvent);
    }
}

