/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.CustomizeUIAction;
import com.intellij.ide.actions.ViewToolbarAction;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.StatusBarCustomComponentFactory;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.status.StatusBarImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreen;
import com.intellij.ui.PopupHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.jetbrains.annotations.Nullable;

public class IdeRootPane
extends JRootPane {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.IdeRootPane");
    private JComponent myToolbar;
    private StatusBarImpl myStatusBar;
    private final Box myNorthPanel = Box.createVerticalBox();
    private final List<IdeRootPaneNorthExtension> myNorthComponents = new ArrayList<IdeRootPaneNorthExtension>();
    private ToolWindowsPane myToolWindowsPane;
    private final MyUISettingsListenerImpl myUISettingsListener;
    private JPanel myContentPane;
    private final ActionManager myActionManager;
    private final UISettings myUISettings;
    private static Component myWelcomePane;
    private final boolean myGlassPaneInitialized;
    private final IdeGlassPaneImpl myGlassPane;
    private final Application myApplication;

    IdeRootPane(ActionManager actionManager, UISettings uiSettings, DataManager dataManager, KeymapManager keymapManager, Application application, String[] commandLineArgs) {
        this.myActionManager = actionManager;
        this.myUISettings = uiSettings;
        this.updateToolbar();
        this.myContentPane.add((Component)this.myNorthPanel, "North");
        this.createStatusBar();
        this.updateStatusBarVisibility();
        this.myContentPane.add((Component)this.myStatusBar, "South");
        this.myUISettingsListener = new MyUISettingsListenerImpl();
        this.setJMenuBar(new IdeMenuBar(this.myActionManager, dataManager, keymapManager));
        Ref willOpenProject = new Ref((Object)Boolean.FALSE);
        AppLifecycleListener lifecyclePublisher = (AppLifecycleListener)application.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC);
        lifecyclePublisher.appFrameCreated(commandLineArgs, (Ref<Boolean>)willOpenProject);
        LOG.info("App initialization took " + (System.nanoTime() - PluginManager.startupStart) / 1000000L + " ms");
        PluginManager.dumpPluginClassStatistics();
        if (!((Boolean)willOpenProject.get()).booleanValue()) {
            myWelcomePane = WelcomeScreen.createWelcomePanel();
            this.myContentPane.add(myWelcomePane);
            lifecyclePublisher.welcomeScreenDisplayed();
        }
        this.myGlassPane = new IdeGlassPaneImpl(this);
        this.setGlassPane(this.myGlassPane);
        this.myGlassPaneInitialized = true;
        this.myGlassPane.setVisible(false);
        this.myApplication = application;
        this.myStatusBar.setCustomComponentsFactory(Arrays.asList(StatusBarCustomComponentFactory.EP_NAME.getExtensions()));
    }

    @Override
    public void setGlassPane(Component glass) {
        if (this.myGlassPaneInitialized) {
            throw new IllegalStateException("Setting of glass pane for IdeFrame is prohibited");
        }
        super.setGlassPane(glass);
    }

    @Override
    public final void addNotify() {
        super.addNotify();
        this.myUISettings.addUISettingsListener((UISettingsListener)this.myUISettingsListener);
    }

    @Override
    public final void removeNotify() {
        this.myUISettings.removeUISettingsListener((UISettingsListener)this.myUISettingsListener);
        super.removeNotify();
    }

    final void setToolWindowsPane(ToolWindowsPane toolWindowsPane) {
        JComponent contentPane = (JComponent)this.getContentPane();
        if (this.myToolWindowsPane != null) {
            contentPane.remove(this.myToolWindowsPane);
        }
        if (myWelcomePane != null) {
            contentPane.remove(myWelcomePane);
            myWelcomePane = null;
        }
        this.myToolWindowsPane = toolWindowsPane;
        if (this.myToolWindowsPane != null) {
            contentPane.add((Component)this.myToolWindowsPane, "Center");
        } else if (!this.myApplication.isDisposeInProgress()) {
            myWelcomePane = WelcomeScreen.createWelcomePanel();
            contentPane.add(myWelcomePane);
        }
        contentPane.revalidate();
    }

    @Override
    protected final Container createContentPane() {
        this.myContentPane = new JPanel(new BorderLayout());
        this.myContentPane.setBackground(Color.GRAY);
        return this.myContentPane;
    }

    void updateToolbar() {
        if (this.myToolbar != null) {
            this.myNorthPanel.remove(this.myToolbar);
        }
        this.myToolbar = this.createToolbar();
        this.myNorthPanel.add(this.myToolbar);
        this.updateToolbarVisibility();
        this.myContentPane.revalidate();
    }

    void updateMainMenuActions() {
        ((IdeMenuBar)this.menuBar).updateMenuActions();
        this.menuBar.repaint();
    }

    private JComponent createToolbar() {
        ActionGroup group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("MainToolBar");
        ActionToolbar toolBar = this.myActionManager.createActionToolbar("MainToolbar", group, true);
        toolBar.setLayoutPolicy(1);
        DefaultActionGroup menuGroup = new DefaultActionGroup();
        menuGroup.add((AnAction)new ViewToolbarAction());
        menuGroup.add((AnAction)new CustomizeUIAction());
        PopupHandler.installUnknownPopupHandler((JComponent)toolBar.getComponent(), (ActionGroup)menuGroup, (ActionManager)this.myActionManager);
        return toolBar.getComponent();
    }

    private void createStatusBar() {
        this.myStatusBar = new StatusBarImpl(this.myUISettings);
    }

    @Nullable
    final StatusBarEx getStatusBar() {
        return this.myStatusBar;
    }

    private void updateToolbarVisibility() {
        this.myToolbar.setVisible(this.myUISettings.SHOW_MAIN_TOOLBAR);
    }

    private void updateStatusBarVisibility() {
        this.myStatusBar.setVisible(this.myUISettings.SHOW_STATUS_BAR);
    }

    public void installNorthComponents(Project project) {
        this.myNorthComponents.addAll(Arrays.asList(Extensions.getExtensions(IdeRootPaneNorthExtension.EP_NAME, (AreaInstance)project)));
        for (IdeRootPaneNorthExtension northComponent : this.myNorthComponents) {
            this.myNorthPanel.add(northComponent.getComponent());
            northComponent.uiSettingsChanged(this.myUISettings);
        }
    }

    public void deinstallNorthComponents() {
        for (IdeRootPaneNorthExtension northComponent : this.myNorthComponents) {
            this.myNorthPanel.remove(northComponent.getComponent());
            Disposer.dispose((Disposable)northComponent);
        }
        this.myNorthComponents.clear();
    }

    public IdeRootPaneNorthExtension findByName(String name) {
        for (IdeRootPaneNorthExtension northComponent : this.myNorthComponents) {
            if (!Comparing.strEqual((String)name, (String)northComponent.getKey())) continue;
            return northComponent;
        }
        return null;
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return !this.myGlassPane.hasPainters() && this.myGlassPane.getComponentCount() == 0;
    }

    private final class MyUISettingsListenerImpl
    implements UISettingsListener {
        private MyUISettingsListenerImpl() {
        }

        public final void uiSettingsChanged(UISettings source) {
            IdeRootPane.this.updateToolbarVisibility();
            IdeRootPane.this.updateStatusBarVisibility();
            for (IdeRootPaneNorthExtension component : IdeRootPane.this.myNorthComponents) {
                component.uiSettingsChanged(source);
            }
        }
    }
}

