/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.codeInsight.CodeSmellInfo;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInsight.daemon.impl.PostHighlightingPass;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CodeSmellDetector;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.impl.VcsErrorViewPanel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CodeSmellDetectorImpl
extends CodeSmellDetector {
    private final Project myProject;

    public CodeSmellDetectorImpl(Project project) {
        this.myProject = project;
    }

    public void showCodeSmellErrors(final List<CodeSmellInfo> smellList) {
        Collections.sort(smellList, new Comparator<CodeSmellInfo>(){

            @Override
            public int compare(CodeSmellInfo o1, CodeSmellInfo o2) {
                return o1.getTextRange().getStartOffset() - o2.getTextRange().getStartOffset();
            }
        });
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CodeSmellDetectorImpl.this.myProject.isDisposed()) {
                    return;
                }
                if (smellList.isEmpty()) {
                    return;
                }
                VcsErrorViewPanel errorTreeView = new VcsErrorViewPanel(CodeSmellDetectorImpl.this.myProject);
                AbstractVcsHelperImpl helper = (AbstractVcsHelperImpl)AbstractVcsHelper.getInstance((Project)CodeSmellDetectorImpl.this.myProject);
                helper.openMessagesView(errorTreeView, VcsBundle.message((String)"code.smells.error.messages.tab.name", (Object[])new Object[0]));
                FileDocumentManager fileManager = FileDocumentManager.getInstance();
                for (CodeSmellInfo smellInfo : smellList) {
                    VirtualFile file = fileManager.getFile(smellInfo.getDocument());
                    OpenFileDescriptor navigatable = new OpenFileDescriptor(CodeSmellDetectorImpl.this.myProject, file, smellInfo.getStartLine(), smellInfo.getStartColumn());
                    String exportPrefix = NewErrorTreeViewPanel.createExportPrefix(smellInfo.getStartLine() + 1);
                    String rendererPrefix = NewErrorTreeViewPanel.createRendererPrefix(smellInfo.getStartLine() + 1, smellInfo.getStartColumn() + 1);
                    if (smellInfo.getSeverity() == HighlightSeverity.ERROR) {
                        errorTreeView.addMessage(4, new String[]{smellInfo.getDescription()}, file.getPresentableUrl(), (Navigatable)navigatable, exportPrefix, rendererPrefix, null);
                        continue;
                    }
                    errorTreeView.addMessage(5, new String[]{smellInfo.getDescription()}, file.getPresentableUrl(), (Navigatable)navigatable, exportPrefix, rendererPrefix, null);
                }
            }
        });
    }

    public List<CodeSmellInfo> findCodeSmells(final List<VirtualFile> filesToCheck) throws ProcessCanceledException {
        final ArrayList<CodeSmellInfo> result = new ArrayList<CodeSmellInfo>();
        final PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        final FileDocumentManager fileManager = FileDocumentManager.getInstance();
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                for (int i = 0; i < filesToCheck.size(); ++i) {
                    Document document;
                    PsiFile psiFile;
                    if (progress != null && progress.isCanceled()) {
                        throw new ProcessCanceledException();
                    }
                    VirtualFile file = (VirtualFile)filesToCheck.get(i);
                    if (progress != null) {
                        progress.setText(VcsBundle.message((String)"searching.for.code.smells.processing.file.progress.text", (Object[])new Object[]{file.getPresentableUrl()}));
                        progress.setFraction((double)i / (double)filesToCheck.size());
                    }
                    if ((psiFile = manager.findFile(file)) == null || (document = fileManager.getDocument(file)) == null) continue;
                    List codeSmells = CodeSmellDetectorImpl.this.findCodeSmells(psiFile, progress, document);
                    result.addAll(codeSmells);
                }
            }
        }, VcsBundle.message((String)"checking.code.smells.progress.title", (Object[])new Object[0]), true, this.myProject);
        if (!completed) {
            throw new ProcessCanceledException();
        }
        return result;
    }

    private List<CodeSmellInfo> findCodeSmells(PsiFile psiFile, ProgressIndicator progress, Document document) {
        ArrayList<CodeSmellInfo> result = new ArrayList<CodeSmellInfo>();
        GeneralHighlightingPass action1 = new GeneralHighlightingPass(this.myProject, psiFile, document, 0, psiFile.getTextLength(), true);
        action1.doCollectInformation(progress);
        this.collectErrorsAndWarnings(action1.getHighlights(), result, document);
        PostHighlightingPass action2 = new PostHighlightingPass(this.myProject, psiFile, document, 0, psiFile.getTextLength());
        action2.doCollectInformation(progress);
        this.collectErrorsAndWarnings(action2.getHighlights(), result, document);
        LocalInspectionsPass action3 = new LocalInspectionsPass(psiFile, document, 0, psiFile.getTextLength());
        action3.doCollectInformation(progress);
        this.collectErrorsAndWarnings(action3.getHighlights(), result, document);
        return result;
    }

    private void collectErrorsAndWarnings(Collection<HighlightInfo> highlights, List<CodeSmellInfo> result, Document document) {
        if (highlights == null) {
            return;
        }
        for (HighlightInfo highlightInfo : highlights) {
            HighlightSeverity severity = highlightInfo.getSeverity();
            if (SeverityRegistrar.getInstance(this.myProject).compare(severity, HighlightSeverity.WARNING) < 0) continue;
            result.add(new CodeSmellInfo(document, CodeSmellDetectorImpl.getDescription(highlightInfo), new TextRange(highlightInfo.startOffset, highlightInfo.endOffset), severity));
        }
    }

    private static String getDescription(HighlightInfo highlightInfo) {
        HighlightDisplayKey severityKey;
        String id;
        String description = highlightInfo.description;
        HighlightInfoType type = highlightInfo.type;
        if (type instanceof HighlightInfoType.HighlightInfoTypeSeverityByKey && (id = (severityKey = ((HighlightInfoType.HighlightInfoTypeSeverityByKey)type).getSeverityKey()).getID()) != null) {
            return "[" + id + "] " + description;
        }
        return description;
    }
}

