/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListEditHandler;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListsIndexes;
import com.intellij.openapi.vcs.changes.ChangeListsWriteOperations;
import com.intellij.openapi.vcs.changes.ChangesDelta;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.DeletedFilesHolder;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.PlusMinus;
import com.intellij.openapi.vcs.changes.SwitchedFileHolder;
import com.intellij.openapi.vcs.changes.VcsAppendableDirtyScope;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListWorker
implements ChangeListsWriteOperations {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangeListWorker");
    private final Project myProject;
    private final Map<String, LocalChangeList> myMap;
    private final DeletedFilesHolder myLocallyDeleted;
    private final SwitchedFileHolder mySwitchedHolder;
    private LocalChangeList myDefault;
    private ChangeListsIndexes myIdx;
    private final ChangesDelta myDelta;
    private final List<String> myListsToDisappear;

    public ChangeListWorker(Project project, PlusMinus<Pair<String, AbstractVcs>> deltaListener) {
        this.myProject = project;
        this.myMap = new HashMap<String, LocalChangeList>();
        this.myIdx = new ChangeListsIndexes();
        this.myLocallyDeleted = new DeletedFilesHolder();
        this.mySwitchedHolder = new SwitchedFileHolder(project, FileHolder.HolderType.SWITCHED);
        this.myDelta = new ChangesDelta(project, deltaListener);
        this.myListsToDisappear = new LinkedList<String>();
    }

    private ChangeListWorker(ChangeListWorker worker) {
        this.myProject = worker.myProject;
        this.myMap = new HashMap<String, LocalChangeList>();
        this.myIdx = new ChangeListsIndexes(worker.myIdx);
        this.myLocallyDeleted = worker.myLocallyDeleted.copy();
        this.mySwitchedHolder = worker.mySwitchedHolder.copy();
        this.myDelta = worker.myDelta;
        this.myListsToDisappear = new LinkedList<String>(worker.myListsToDisappear);
        LocalChangeList defaultList = null;
        for (LocalChangeList changeList : worker.myMap.values()) {
            LocalChangeList copy = changeList.copy();
            String changeListName = copy.getName();
            this.myMap.put(changeListName, copy);
            if (!copy.isDefault()) continue;
            defaultList = copy;
        }
        if (defaultList == null) {
            LOG.info("default list not found when copy");
            defaultList = this.myMap.get(worker.getDefaultListName());
        }
        if (defaultList == null) {
            LOG.info("default list not found when copy in original object too");
            if (!this.myMap.isEmpty()) {
                defaultList = this.myMap.values().iterator().next();
            }
        }
        this.myDefault = defaultList;
    }

    public boolean takeData(@NotNull ChangeListWorker worker) {
        if (worker == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangeListWorker.takeData must not be null");
        }
        this.myMap.clear();
        this.myMap.putAll(worker.myMap);
        this.myDefault = worker.myDefault;
        this.myListsToDisappear.clear();
        this.myListsToDisappear.addAll(worker.myListsToDisappear);
        boolean somethingChanged = this.myDelta.step(this.myIdx, worker.myIdx);
        this.myIdx = new ChangeListsIndexes(worker.myIdx);
        this.checkForMultipleCopiesNotMove();
        this.myLocallyDeleted.takeFrom(worker.myLocallyDeleted);
        this.mySwitchedHolder.takeFrom(worker.mySwitchedHolder);
        return somethingChanged;
    }

    private void checkForMultipleCopiesNotMove() {
        MultiMap<FilePath, Pair<Change, String>> moves = new MultiMap<FilePath, Pair<Change, String>>(){

            protected Collection<Pair<Change, String>> createCollection() {
                return new LinkedList<Pair<Change, String>>();
            }

            protected Collection<Pair<Change, String>> createEmptyCollection() {
                return Collections.emptyList();
            }
        };
        for (LocalChangeList changeList : this.myMap.values()) {
            Collection changes = changeList.getChanges();
            for (Change change : changes) {
                if (!change.isMoved() && !change.isRenamed()) continue;
                moves.putValue((Object)change.getBeforeRevision().getFile(), (Object)new Pair((Object)change, (Object)changeList.getName()));
            }
        }
        boolean somethingChanged = false;
        for (FilePath filePath : moves.keySet()) {
            List copies = (List)moves.get((Object)filePath);
            if (copies.size() == 1) continue;
            Collections.sort(copies, MyChangesAfterRevisionComparator.getInstance());
            for (int i = 0; i < copies.size() - 1; ++i) {
                somethingChanged = true;
                Pair item = (Pair)copies.get(i);
                Change oldChange = (Change)item.getFirst();
                Change newChange = new Change(null, oldChange.getAfterRevision());
                LocalChangeListImpl list = (LocalChangeListImpl)this.myMap.get(item.getSecond());
                list.removeChange(oldChange);
                list.addChange(newChange);
                VcsKey key = this.myIdx.getVcsFor(oldChange);
                this.myIdx.changeRemoved(oldChange);
                this.myIdx.changeAdded(newChange, key);
            }
        }
        if (somethingChanged) {
            FileStatusManager.getInstance((Project)this.myProject).fileStatusesChanged();
        }
    }

    public ChangeListWorker copy() {
        return new ChangeListWorker(this);
    }

    public boolean findListByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangeListWorker.findListByName must not be null");
        }
        return this.myMap.containsKey(name);
    }

    @Nullable
    public LocalChangeList getCopyByName(String name) {
        return this.myMap.get(name);
    }

    @Nullable
    public LocalChangeList getChangeList(String id) {
        for (LocalChangeList changeList : this.myMap.values()) {
            if (!changeList.getId().equals(id)) continue;
            return changeList.copy();
        }
        return null;
    }

    @Override
    @Nullable
    public String setDefault(String name) {
        LocalChangeList newDefault = this.myMap.get(name);
        if (newDefault == null) {
            return null;
        }
        String previousName = null;
        if (this.myDefault != null) {
            ((LocalChangeListImpl)this.myDefault).setDefault(false);
            this.correctChangeListEditHandler(this.myDefault);
            previousName = this.myDefault.getName();
        }
        ((LocalChangeListImpl)newDefault).setDefault(true);
        this.myDefault = newDefault;
        return previousName;
    }

    @Override
    public boolean setReadOnly(String name, boolean value) {
        LocalChangeList list = this.myMap.get(name);
        if (list != null) {
            list.setReadOnly(value);
        }
        return list != null;
    }

    @Override
    public LocalChangeList addChangeList(@NotNull String name, @Nullable String description) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangeListWorker.addChangeList must not be null");
        }
        return this.addChangeList(null, name, description, false);
    }

    LocalChangeList addChangeList(String id, @NotNull String name, @Nullable String description, boolean inUpdate) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangeListWorker.addChangeList must not be null");
        }
        boolean contains = this.myMap.containsKey(name);
        LOG.assertTrue(!contains, (Object)("Attempt to create duplicate changelist " + name));
        LocalChangeListImpl newList = (LocalChangeListImpl)LocalChangeList.createEmptyChangeList((Project)this.myProject, (String)name);
        if (description != null) {
            newList.setCommentImpl(description);
        }
        if (id != null) {
            newList.setId(id);
        }
        this.myMap.put(name, newList);
        if (inUpdate) {
            newList.startProcessingChanges(this.myProject, null);
        }
        return newList.copy();
    }

    public boolean addChangeToList(@NotNull String name, Change change, VcsKey vcsKey) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangeListWorker.addChangeToList must not be null");
        }
        LOG.debug("[addChangeToList] name: " + name + " change: " + ChangesUtil.getFilePath((Change)change).getPath() + " vcs: " + (vcsKey == null ? null : vcsKey.getName()));
        LocalChangeList changeList = this.myMap.get(name);
        if (changeList != null) {
            ((LocalChangeListImpl)changeList).addChange(change);
            this.myIdx.changeAdded(change, vcsKey);
            this.correctChangeListEditHandler(changeList);
        }
        return changeList != null;
    }

    public void addChangeToCorrespondingList(Change change, VcsKey vcsKey) {
        String path = LOG.isDebugEnabled() ? ChangesUtil.getFilePath((Change)change).getPath() : "";
        LOG.debug("[addChangeToCorrespondingList] for change " + path);
        assert (this.myDefault != null);
        for (LocalChangeList list : this.myMap.values()) {
            if (list.isDefault()) {
                LOG.debug("[addChangeToCorrespondingList] skip default list: " + list.getName());
                continue;
            }
            if (!((LocalChangeListImpl)list).processChange(change)) continue;
            LOG.debug("[addChangeToCorrespondingList] matched: " + list.getName());
            this.myIdx.changeAdded(change, vcsKey);
            this.correctChangeListEditHandler(list);
            return;
        }
        ((LocalChangeListImpl)this.myDefault).processChange(change);
        this.myIdx.changeAdded(change, vcsKey);
        this.correctChangeListEditHandler(this.myDefault);
    }

    @Override
    public boolean removeChangeList(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangeListWorker.removeChangeList must not be null");
        }
        LocalChangeList list = this.myMap.get(name);
        if (list == null) {
            return false;
        }
        if (list.isDefault()) {
            throw new RuntimeException(new IncorrectOperationException("Cannot remove default changelist"));
        }
        String listName = list.getName();
        for (Change change : list.getChanges()) {
            ((LocalChangeListImpl)this.myDefault).addChange(change);
        }
        this.myMap.remove(listName);
        return true;
    }

    void initialized() {
        for (LocalChangeList list : this.myMap.values()) {
            this.correctChangeListEditHandler(list);
        }
    }

    private void correctChangeListEditHandler(LocalChangeList list) {
    }

    @Override
    @Nullable
    public MultiMap<LocalChangeList, Change> moveChangesTo(String name, Change[] changes) {
        LocalChangeListImpl changeList = (LocalChangeListImpl)this.myMap.get(name);
        if (changeList != null) {
            MultiMap result = new MultiMap();
            for (LocalChangeList list : this.myMap.values()) {
                if (list.equals((Object)changeList)) continue;
                for (Change change : changes) {
                    Change removedChange = ((LocalChangeListImpl)list).removeChange(change);
                    if (removedChange == null) continue;
                    this.correctChangeListEditHandler(list);
                    changeList.addChange(removedChange);
                    result.putValue((Object)list, (Object)removedChange);
                }
            }
            this.correctChangeListEditHandler(changeList);
            return result;
        }
        return null;
    }

    @Override
    public boolean editName(@NotNull String fromName, @NotNull String toName) {
        boolean canEdit;
        if (fromName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangeListWorker.editName must not be null");
        }
        if (toName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangeListWorker.editName must not be null");
        }
        if (fromName.equals(toName)) {
            return false;
        }
        LocalChangeList list = this.myMap.get(fromName);
        boolean bl = canEdit = list != null && !list.isReadOnly();
        if (canEdit) {
            LocalChangeListImpl listImpl = (LocalChangeListImpl)list;
            listImpl.setNameImpl(toName);
            this.myMap.remove(fromName);
            this.myMap.put(toName, list);
            ChangeListEditHandler editHandler = listImpl.getEditHandler();
            if (editHandler != null) {
                listImpl.setCommentImpl(editHandler.changeCommentOnChangeName(toName, listImpl.getComment()));
            }
        }
        return canEdit;
    }

    @Override
    @Nullable
    public String editComment(@NotNull String fromName, String newComment) {
        if (fromName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangeListWorker.editComment must not be null");
        }
        LocalChangeList list = this.myMap.get(fromName);
        if (list != null) {
            String oldComment = list.getComment();
            if (!Comparing.equal((String)oldComment, (String)newComment)) {
                LocalChangeListImpl listImpl = (LocalChangeListImpl)list;
                listImpl.setCommentImpl(newComment);
                ChangeListEditHandler editHandler = listImpl.getEditHandler();
                if (editHandler != null) {
                    listImpl.setNameImpl(editHandler.changeNameOnChangeComment(listImpl.getName(), listImpl.getComment()));
                    if (!fromName.equals(listImpl.getName())) {
                        this.myMap.remove(fromName);
                        this.myMap.put(listImpl.getName(), list);
                    }
                }
            }
            return oldComment;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Nullable
    public LocalChangeList getDefaultListCopy() {
        return this.myDefault == null ? null : this.myDefault.copy();
    }

    public boolean isDefaultList(LocalChangeList list) {
        return this.myDefault != null && list.getId().equals(this.myDefault.getId());
    }

    public Project getProject() {
        return this.myProject;
    }

    public void notifyStartProcessingChanges(VcsAppendableDirtyScope scope) {
        ArrayList<Change> oldChanges = new ArrayList<Change>();
        for (LocalChangeList list : this.myMap.values()) {
            Collection<Change> affectedChanges = ((LocalChangeListImpl)list).startProcessingChanges(this.myProject, (VcsDirtyScope)scope);
            if (affectedChanges.isEmpty()) continue;
            oldChanges.addAll(affectedChanges);
        }
        for (Change change : oldChanges) {
            this.myIdx.changeRemoved(change);
        }
        this.correctScopeForMoves(scope, oldChanges);
        this.myLocallyDeleted.cleanScope((VcsDirtyScope)scope);
        this.mySwitchedHolder.cleanScope((VcsDirtyScope)scope);
    }

    private void correctScopeForMoves(VcsAppendableDirtyScope scope, Collection<Change> changes) {
        if (scope == null) {
            return;
        }
        for (Change change : changes) {
            if (!change.isMoved() && !change.isRenamed()) continue;
            scope.addDirtyFile(change.getBeforeRevision().getFile());
            scope.addDirtyFile(change.getAfterRevision().getFile());
        }
    }

    public void notifyDoneProcessingChanges(ChangeListListener dispatcher) {
        ArrayList<LocalChangeList> changedLists = new ArrayList<LocalChangeList>();
        HashMap<LocalChangeListImpl, ArrayList<Change>> removedChanges = new HashMap<LocalChangeListImpl, ArrayList<Change>>();
        HashMap<LocalChangeListImpl, ArrayList<Change>> addedChanges = new HashMap<LocalChangeListImpl, ArrayList<Change>>();
        for (LocalChangeList localChangeList : this.myMap.values()) {
            ArrayList<Change> added;
            ArrayList<Change> removed;
            LocalChangeListImpl listImpl = (LocalChangeListImpl)localChangeList;
            if (listImpl.doneProcessingChanges(removed = new ArrayList<Change>(), added = new ArrayList<Change>())) {
                changedLists.add(localChangeList);
            }
            if (!removed.isEmpty()) {
                removedChanges.put(listImpl, removed);
            }
            if (added.isEmpty()) continue;
            addedChanges.put(listImpl, added);
        }
        for (Map.Entry entry : removedChanges.entrySet()) {
            dispatcher.changesRemoved((Collection)entry.getValue(), (ChangeList)entry.getKey());
        }
        for (Map.Entry entry : addedChanges.entrySet()) {
            dispatcher.changesAdded((Collection)entry.getValue(), (ChangeList)entry.getKey());
        }
        for (ChangeList changeList : changedLists) {
            dispatcher.changeListChanged(changeList);
        }
        this.mySwitchedHolder.calculateChildren();
        for (String string : this.myListsToDisappear) {
            LocalChangeList changeList = this.myMap.get(string);
            if (changeList == null || !changeList.getChanges().isEmpty() || changeList.isReadOnly() || changeList.isDefault()) continue;
            this.removeChangeList(string);
        }
        this.myListsToDisappear.clear();
    }

    public List<LocalChangeList> getListsCopy() {
        ArrayList<LocalChangeList> result = new ArrayList<LocalChangeList>();
        for (LocalChangeList list : this.myMap.values()) {
            result.add(list.copy());
        }
        return result;
    }

    public String getDefaultListName() {
        return this.myDefault == null ? null : this.myDefault.getName();
    }

    public List<File> getAffectedPaths() {
        return this.myIdx.getAffectedPaths();
    }

    @NotNull
    public List<VirtualFile> getAffectedFiles() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (LocalChangeList list : this.myMap.values()) {
            for (Change change : list.getChanges()) {
                VirtualFile file;
                ContentRevision before = change.getBeforeRevision();
                ContentRevision after = change.getAfterRevision();
                if (before != null && (file = before.getFile().getVirtualFile()) != null) {
                    result.add(file);
                }
                if (after == null || (file = after.getFile().getVirtualFile()) == null) continue;
                result.add(file);
            }
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ChangeListWorker.getAffectedFiles must not return null");
        }
        return arrayList;
    }

    public LocalChangeList getListCopy(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangeListWorker.getListCopy must not be null");
        }
        for (LocalChangeList list : this.myMap.values()) {
            for (Change change : list.getChanges()) {
                if (change.getAfterRevision() != null && Comparing.equal((Object)change.getAfterRevision().getFile().getVirtualFile(), (Object)file)) {
                    return list.copy();
                }
                if (change.getBeforeRevision() == null || !Comparing.equal((Object)change.getBeforeRevision().getFile().getVirtualFile(), (Object)file)) continue;
                return list.copy();
            }
        }
        return null;
    }

    @Nullable
    public Change getChangeForPath(FilePath file) {
        for (LocalChangeList list : this.myMap.values()) {
            for (Change change : list.getChanges()) {
                ContentRevision afterRevision = change.getAfterRevision();
                if (afterRevision != null && afterRevision.getFile().equals(file)) {
                    return change;
                }
                ContentRevision beforeRevision = change.getBeforeRevision();
                if (beforeRevision == null || !beforeRevision.getFile().equals(file)) continue;
                return change;
            }
        }
        return null;
    }

    public FileStatus getStatus(VirtualFile file) {
        return this.myIdx.getStatus(file);
    }

    public DeletedFilesHolder getLocallyDeleted() {
        return this.myLocallyDeleted.copy();
    }

    public SwitchedFileHolder getSwitchedHolder() {
        return this.mySwitchedHolder.copy();
    }

    public void addSwitched(VirtualFile file, @NotNull String branchName, boolean recursive) {
        if (branchName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangeListWorker.addSwitched must not be null");
        }
        this.mySwitchedHolder.addFile(file, branchName, recursive);
    }

    public void removeSwitched(VirtualFile file) {
        this.mySwitchedHolder.removeFile(file);
    }

    public String getBranchForFile(VirtualFile file) {
        return this.mySwitchedHolder.getBranchForFile(file);
    }

    public boolean isSwitched(VirtualFile file) {
        return this.mySwitchedHolder.containsFile(file);
    }

    public void addLocallyDeleted(LocallyDeletedChange change) {
        this.myLocallyDeleted.addFile(change);
    }

    public boolean isContainedInLocallyDeleted(FilePath filePath) {
        return this.myLocallyDeleted.isContainedInLocallyDeleted(filePath);
    }

    @NotNull
    public Map<String, List<Change>> listsForChanges(Collection<Change> changes, Map<String, LocalChangeList> lists) {
        GatherChangesVsListsInfo info = new GatherChangesVsListsInfo(changes);
        info.run();
        lists.putAll(info.getIncludedListsCopies());
        Map<String, List<Change>> map = info.getListToChangesMap();
        if (map == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ChangeListWorker.listsForChanges must not return null");
        }
        return map;
    }

    @NotNull
    public Collection<LocalChangeList> getInvolvedListsFilterChanges(Collection<Change> changes, List<Change> validChanges) {
        GatherListsFilterValidChanges worker = new GatherListsFilterValidChanges(changes);
        worker.run();
        validChanges.addAll(worker.getValidChanges());
        Collection<LocalChangeList> collection = worker.getIncludedListsCopies().values();
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ChangeListWorker.getInvolvedListsFilterChanges must not return null");
        }
        return collection;
    }

    @Nullable
    public LocalChangeList listForChange(Change change) {
        for (LocalChangeList list : this.myMap.values()) {
            if (!list.getChanges().contains(change)) continue;
            return list.copy();
        }
        return null;
    }

    @Nullable
    public String listNameIfOnlyOne(@Nullable Change[] changes) {
        if (changes == null || changes.length == 0) {
            return null;
        }
        Change first = changes[0];
        for (LocalChangeList list : this.myMap.values()) {
            Collection listChanges = list.getChanges();
            if (!listChanges.contains(first)) continue;
            for (int i = 1; i < changes.length; ++i) {
                Change change = changes[i];
                if (listChanges.contains(change)) continue;
                return null;
            }
            return list.getName();
        }
        return null;
    }

    @NotNull
    public Collection<Change> getChangesIn(FilePath dirPath) {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (LocalChangeList list : this.myMap.values()) {
            for (Change change : list.getChanges()) {
                ContentRevision afterRevision = change.getAfterRevision();
                if (afterRevision != null && afterRevision.getFile().isUnder(dirPath, false)) {
                    changes.add(change);
                    continue;
                }
                ContentRevision beforeRevision = change.getBeforeRevision();
                if (beforeRevision == null || !beforeRevision.getFile().isUnder(dirPath, false)) continue;
                changes.add(change);
            }
        }
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ChangeListWorker.getChangesIn must not return null");
        }
        return arrayList;
    }

    void setListsToDisappear(Collection<String> names) {
        this.myListsToDisappear.addAll(names);
    }

    ChangeListManagerGate createSelfGate() {
        return new MyGate(this);
    }

    private static class MyChangesAfterRevisionComparator
    implements Comparator<Pair<Change, String>> {
        private static final MyChangesAfterRevisionComparator ourInstance = new MyChangesAfterRevisionComparator();

        private MyChangesAfterRevisionComparator() {
        }

        public static MyChangesAfterRevisionComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(Pair<Change, String> o1, Pair<Change, String> o2) {
            String s1 = ((Change)o1.getFirst()).getAfterRevision().getFile().getPresentableUrl();
            String s2 = ((Change)o2.getFirst()).getAfterRevision().getFile().getPresentableUrl();
            return SystemInfo.isFileSystemCaseSensitive ? s1.compareTo(s2) : s1.compareToIgnoreCase(s2);
        }
    }

    private static class MyGate
    implements ChangeListManagerGate {
        private final ChangeListWorker myWorker;

        private MyGate(ChangeListWorker worker) {
            this.myWorker = worker;
        }

        public List<LocalChangeList> getListsCopy() {
            return this.myWorker.getListsCopy();
        }

        @Nullable
        public LocalChangeList findChangeList(String name) {
            return this.myWorker.getCopyByName(name);
        }

        public LocalChangeList addChangeList(String name, String comment) {
            return this.myWorker.addChangeList(null, name, comment, true);
        }

        public LocalChangeList findOrCreateList(String name, String comment) {
            LocalChangeList list = this.myWorker.getCopyByName(name);
            if (list == null) {
                list = this.addChangeList(name, comment);
            }
            return list;
        }

        public void editComment(String name, String comment) {
            this.myWorker.editComment(name, comment);
        }

        public void editName(String oldName, String newName) {
            this.myWorker.editName(oldName, newName);
        }

        public void moveChanges(String toList, Collection<Change> changes) {
            this.myWorker.moveChangesTo(toList, changes.toArray(new Change[changes.size()]));
        }

        public void setListsToDisappear(Collection<String> names) {
            this.myWorker.setListsToDisappear(names);
        }
    }

    private class GatherListsFilterValidChanges
    extends ExternalVsInternalChangesIntersection {
        private final List<Change> myValidChanges;

        private GatherListsFilterValidChanges(Collection<Change> inChanges) {
            super(inChanges);
            this.myValidChanges = new ArrayList<Change>();
        }

        @Override
        protected void processInChange(Pair<String, String> key, Change change) {
            LocalChangeList list = (LocalChangeList)this.myInternalMap.get(key);
            if (list != null) {
                this.myIncludedListsCopies.put(list.getName(), list);
                this.myValidChanges.add(change);
            }
        }

        public List<Change> getValidChanges() {
            return this.myValidChanges;
        }
    }

    private class GatherChangesVsListsInfo
    extends ExternalVsInternalChangesIntersection {
        private final Map<String, List<Change>> myListToChangesMap;

        private GatherChangesVsListsInfo(Collection<Change> inChanges) {
            super(inChanges);
            this.myListToChangesMap = new HashMap<String, List<Change>>();
        }

        @Override
        protected void processInChange(Pair<String, String> key, Change change) {
            String tmpName;
            List<Change> list;
            LocalChangeList tmpList = (LocalChangeList)this.myInternalMap.get(key);
            if (tmpList == null) {
                tmpList = this.myDefaultCopy;
            }
            if ((list = this.myListToChangesMap.get(tmpName = tmpList.getName())) == null) {
                list = new ArrayList<Change>();
                this.myListToChangesMap.put(tmpName, list);
                this.myIncludedListsCopies.put(tmpName, tmpList);
            }
            list.add(change);
        }

        public Map<String, List<Change>> getListToChangesMap() {
            return this.myListToChangesMap;
        }
    }

    private abstract class ExternalVsInternalChangesIntersection {
        protected final Collection<Change> myInChanges;
        protected final Map<Pair<String, String>, LocalChangeList> myInternalMap;
        protected final LocalChangeList myDefaultCopy;
        protected final Map<String, LocalChangeList> myIncludedListsCopies;

        protected ExternalVsInternalChangesIntersection(Collection<Change> inChanges) {
            this.myInChanges = inChanges;
            this.myInternalMap = new HashMap<Pair<String, String>, LocalChangeList>();
            this.myDefaultCopy = ChangeListWorker.this.myDefault.copy();
            this.myIncludedListsCopies = new HashMap<String, LocalChangeList>();
        }

        private Pair<String, String> keyForChange(Change change) {
            FilePath beforePath = ChangesUtil.getBeforePath((Change)change);
            String beforeKey = beforePath == null ? null : beforePath.getIOFile().getAbsolutePath();
            FilePath afterPath = ChangesUtil.getAfterPath((Change)change);
            String afterKey = afterPath == null ? null : afterPath.getIOFile().getAbsolutePath();
            return new Pair((Object)beforeKey, (Object)afterKey);
        }

        private void preparation() {
            for (LocalChangeList list : ChangeListWorker.this.myMap.values()) {
                Collection managerChanges = list.getChanges();
                LocalChangeList copy = list.copy();
                for (Change change : managerChanges) {
                    this.myInternalMap.put(this.keyForChange(change), copy);
                }
            }
        }

        protected abstract void processInChange(Pair<String, String> var1, Change var2);

        public void run() {
            this.preparation();
            for (Change change : this.myInChanges) {
                Pair<String, String> key = this.keyForChange(change);
                this.processInChange(key, change);
            }
        }

        public Map<String, LocalChangeList> getIncludedListsCopies() {
            return this.myIncludedListsCopies;
        }
    }
}

