/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;

public final class TextEditorState
implements FileEditorState {
    public int LINE;
    public int COLUMN;
    public float VERTICAL_SCROLL_PROPORTION;
    public int SELECTION_START;
    public int SELECTION_END;
    public CodeFoldingState FOLDING_STATE;
    private static final int MIN_CHANGE_DISTANCE = 4;

    public boolean equals(Object o) {
        if (!(o instanceof TextEditorState)) {
            return false;
        }
        TextEditorState textEditorState = (TextEditorState)o;
        if (this.COLUMN != textEditorState.COLUMN) {
            return false;
        }
        if (this.LINE != textEditorState.LINE) {
            return false;
        }
        if (this.VERTICAL_SCROLL_PROPORTION != textEditorState.VERTICAL_SCROLL_PROPORTION) {
            return false;
        }
        if (this.SELECTION_START != textEditorState.SELECTION_START) {
            return false;
        }
        return this.SELECTION_END == textEditorState.SELECTION_END;
    }

    public int hashCode() {
        return this.LINE + this.COLUMN;
    }

    public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
        if (!(otherState instanceof TextEditorState)) {
            return false;
        }
        TextEditorState other = (TextEditorState)otherState;
        return level == FileEditorStateLevel.NAVIGATION && Math.abs(this.LINE - other.LINE) < 4;
    }

    public String toString() {
        return "[" + this.LINE + "," + this.COLUMN + "]";
    }
}

