/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ActionPopupMenuImpl
implements ActionPopupMenu {
    private final MyMenu myMenu;
    private final ActionManagerImpl myManager;

    public ActionPopupMenuImpl(String place, @NotNull ActionGroup group, ActionManagerImpl actionManager, @Nullable PresentationFactory factory) {
        if (group == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionPopupMenuImpl.<init> must not be null");
        }
        this.myManager = actionManager;
        this.myMenu = new MyMenu(place, group, factory);
    }

    public JPopupMenu getComponent() {
        return this.myMenu;
    }

    private class MyMenu
    extends JPopupMenu {
        private final String myPlace;
        private final ActionGroup myGroup;
        private DataContext myContext;
        private final PresentationFactory myPresentationFactory;

        public MyMenu(@NotNull String place, @Nullable ActionGroup group, PresentationFactory factory) {
            if (group == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionPopupMenuImpl$MyMenu.<init> must not be null");
            }
            this.myPlace = place;
            this.myGroup = group;
            this.myPresentationFactory = factory != null ? factory : new MenuItemPresentationFactory();
            this.addPopupMenuListener(new MyPopupMenuListener());
        }

        @Override
        public void show(Component component, int x, int y) {
            if (!component.isShowing()) {
                throw new IllegalArgumentException("component must be shown on the screen");
            }
            this.removeAll();
            int x2 = Math.min(Math.max(0, x), component.getWidth() - 1);
            int y2 = Math.min(Math.max(0, y), component.getHeight() - 1);
            this.myContext = DataManager.getInstance().getDataContext(component, x2, y2);
            Utils.fillMenu(this.myGroup, this, true, this.myPresentationFactory, this.myContext, this.myPlace, false, false);
            if (this.getComponentCount() == 0) {
                return;
            }
            Dimension preferredSize = this.getPreferredSize();
            Point p = component.getLocationOnScreen();
            int _x = p.x + x;
            int _y = p.y + y;
            GraphicsConfiguration targetGraphicsConfiguration = null;
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] devices = env.getScreenDevices();
            for (int i = 0; i < devices.length; ++i) {
                GraphicsDevice device = devices[i];
                GraphicsConfiguration graphicsConfiguration = device.getDefaultConfiguration();
                Rectangle r = graphicsConfiguration.getBounds();
                if (r.x > _x || _x > r.x + r.width || r.y > _y || _y > r.y + r.height) continue;
                targetGraphicsConfiguration = graphicsConfiguration;
                break;
            }
            if (targetGraphicsConfiguration == null && devices.length > 0) {
                targetGraphicsConfiguration = env.getDefaultScreenDevice().getDefaultConfiguration();
            }
            if (targetGraphicsConfiguration == null) {
                throw new IllegalStateException("It's impossible to determine target graphics environment for point (" + _x + "," + _y + ")");
            }
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(targetGraphicsConfiguration);
            Rectangle targetRectangle = targetGraphicsConfiguration.getBounds();
            targetRectangle.x += insets.left;
            targetRectangle.y += insets.top;
            targetRectangle.width -= insets.left + insets.right;
            targetRectangle.height -= insets.top + insets.bottom;
            if (_x + preferredSize.width > targetRectangle.x + targetRectangle.width) {
                x -= preferredSize.width;
            }
            if (_y + preferredSize.height > targetRectangle.y + targetRectangle.height) {
                int invisibleHeight = _y + preferredSize.height - targetRectangle.y - targetRectangle.height;
                y -= invisibleHeight;
            }
            super.show(component, x, y);
        }

        private class MyPopupMenuListener
        implements PopupMenuListener {
            private MyPopupMenuListener() {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                ActionPopupMenuImpl.this.myManager.removeActionPopup(ActionPopupMenuImpl.this);
                MyMenu.this.removeAll();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ActionPopupMenuImpl.this.myManager.removeActionPopup(ActionPopupMenuImpl.this);
                MyMenu.this.removeAll();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                MyMenu.this.removeAll();
                Utils.fillMenu(MyMenu.this.myGroup, MyMenu.this, !UISettings.getInstance().DISABLE_MNEMONICS, MyMenu.this.myPresentationFactory, MyMenu.this.myContext, MyMenu.this.myPlace, false, false);
                ActionPopupMenuImpl.this.myManager.addActionPopup(ActionPopupMenuImpl.this);
            }
        }
    }
}

