/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard.impl;

import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModelListener;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportNode;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkSupportModelImpl
extends UserDataHolderBase
implements FrameworkSupportModel {
    private final Project myProject;
    private final ModuleBuilder myModuleBuilder;
    private final EventDispatcher<FrameworkSupportModelListener> myDispatcher = EventDispatcher.create(FrameworkSupportModelListener.class);
    private final Map<String, FrameworkSupportNode> mySettingsMap = new HashMap<String, FrameworkSupportNode>();

    public FrameworkSupportModelImpl(@Nullable Project project, @Nullable ModuleBuilder builder) {
        this.myProject = project;
        this.myModuleBuilder = builder;
    }

    public void registerComponent(@NotNull FrameworkSupportProvider provider, @NotNull FrameworkSupportNode node) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelImpl.registerComponent must not be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelImpl.registerComponent must not be null");
        }
        this.mySettingsMap.put(provider.getId(), node);
    }

    public Project getProject() {
        return this.myProject;
    }

    public ModuleBuilder getModuleBuilder() {
        return this.myModuleBuilder;
    }

    public boolean isFrameworkSelected(@NotNull @NonNls String providerId) {
        if (providerId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelImpl.isFrameworkSelected must not be null");
        }
        FrameworkSupportNode node = this.mySettingsMap.get(providerId);
        return node != null && node.isChecked();
    }

    public void addFrameworkListener(@NotNull FrameworkSupportModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelImpl.addFrameworkListener must not be null");
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeFrameworkListener(@NotNull FrameworkSupportModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelImpl.removeFrameworkListener must not be null");
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public void setFrameworkComponentEnabled(@NotNull @NonNls String providerId, boolean enable) {
        if (providerId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelImpl.setFrameworkComponentEnabled must not be null");
        }
        FrameworkSupportNode node = this.mySettingsMap.get(providerId);
        if (node == null) {
            throw new IllegalArgumentException("provider '" + providerId + " not found");
        }
        if (enable != node.isChecked()) {
            node.setChecked(enable);
        }
    }

    public FrameworkSupportConfigurable getFrameworkConfigurable(@NotNull @NonNls String providerId) {
        if (providerId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelImpl.getFrameworkConfigurable must not be null");
        }
        FrameworkSupportNode node = this.mySettingsMap.get(providerId);
        if (node == null) {
            throw new IllegalArgumentException("provider '" + providerId + " not found");
        }
        return node.getConfigurable();
    }

    public void onFrameworkSelectionChanged(FrameworkSupportNode node) {
        FrameworkSupportModelListener multicaster = (FrameworkSupportModelListener)this.myDispatcher.getMulticaster();
        if (node.isChecked()) {
            multicaster.frameworkSelected(node.getProvider());
        } else {
            multicaster.frameworkUnselected(node.getProvider());
        }
    }
}

