/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.newProjectWizard.ProjectCreateModeStep;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.newProjectWizard.modes.WizardMode;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddModuleWizard
extends AbstractWizard<ModuleWizardStep> {
    private static final String ADD_MODULE_TITLE = IdeBundle.message((String)"title.add.module", (Object[])new Object[0]);
    private static final String NEW_PROJECT_TITLE = IdeBundle.message((String)"title.new.project", (Object[])new Object[0]);
    private final Project myCurrentProject;
    private WizardContext myWizardContext;
    private ProjectCreateModeStep myRootStep;

    public AddModuleWizard(Project project, ModulesProvider modulesProvider, @Nullable String defaultPath) {
        super(project == null ? NEW_PROJECT_TITLE : ADD_MODULE_TITLE, project);
        this.myCurrentProject = project;
        this.initModuleWizard(project, modulesProvider, defaultPath);
    }

    public AddModuleWizard(Component parent, Project project, ModulesProvider modulesProvider) {
        super(project == null ? NEW_PROJECT_TITLE : ADD_MODULE_TITLE, parent);
        this.myCurrentProject = project;
        this.initModuleWizard(project, modulesProvider, null);
    }

    private void initModuleWizard(Project project, ModulesProvider modulesProvider, @Nullable String defaultPath) {
        this.myWizardContext = new WizardContext(project);
        if (defaultPath != null) {
            this.myWizardContext.setProjectFileDirectory(defaultPath);
            this.myWizardContext.setProjectName(defaultPath.substring(FileUtil.toSystemIndependentName((String)defaultPath).lastIndexOf("/") + 1));
        }
        this.myWizardContext.addContextListener(new WizardContext.Listener(){

            public void buttonsUpdateRequested() {
                AddModuleWizard.this.updateButtons();
            }

            public void nextStepRequested() {
                AddModuleWizard.this.doNextAction();
            }
        });
        this.myRootStep = new ProjectCreateModeStep(defaultPath, this.myWizardContext){

            @Override
            protected void update() {
                AddModuleWizard.this.updateButtons();
            }
        };
        this.addStep((Step)this.myRootStep);
        for (WizardMode mode : this.myRootStep.getModes()) {
            this.appendSteps(mode.getSteps(this.myWizardContext, modulesProvider));
        }
        this.init();
    }

    private void appendSteps(@Nullable StepSequence sequence) {
        if (sequence != null) {
            List<ModuleWizardStep> commonSteps = sequence.getCommonSteps();
            for (ModuleWizardStep step : commonSteps) {
                this.addStep((Step)step);
            }
            for (String type : sequence.getTypes()) {
                this.appendSteps(sequence.getSpecificSteps(type));
            }
        }
    }

    protected void updateStep() {
        final ModuleWizardStep currentStep = (ModuleWizardStep)this.getCurrentStepObject();
        currentStep.updateStep();
        super.updateStep();
        this.updateButtons();
        final JButton nextButton = this.getNextButton();
        final JButton finishButton = this.getFinishButton();
        final boolean isLastStep = this.isLastStep(this.getCurrentStep());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!AddModuleWizard.this.isShowing()) {
                    return;
                }
                JComponent preferredFocusedComponent = currentStep.getPreferredFocusedComponent();
                if (preferredFocusedComponent != null) {
                    preferredFocusedComponent.requestFocus();
                } else if (isLastStep) {
                    finishButton.requestFocus();
                } else {
                    nextButton.requestFocus();
                }
                AddModuleWizard.this.getRootPane().setDefaultButton(isLastStep ? finishButton : nextButton);
            }
        });
    }

    protected void dispose() {
        for (ModuleWizardStep step : this.mySteps) {
            step.disposeUIResources();
        }
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doOKAction() {
        int idx = this.getCurrentStep();
        try {
            while (true) {
                ModuleWizardStep step;
                if ((step = (ModuleWizardStep)this.mySteps.get(idx)) != this.getCurrentStepObject()) {
                    step.updateStep();
                }
                if (!this.commitStepData(step)) {
                    return;
                }
                step.onStepLeaving();
                try {
                    step._commit(true);
                }
                catch (CommitStepException e) {
                    String message = e.getMessage();
                    if (message != null) {
                        Messages.showErrorDialog((Component)this.getCurrentStepComponent(), (String)message);
                    }
                    this.myCurrentStep = idx;
                    this.updateStep();
                    return;
                }
                if (!this.isLastStep(idx)) {
                    idx = this.getNextStep(idx);
                    continue;
                }
                break;
            }
        }
        finally {
            this.myCurrentStep = idx;
            this.updateStep();
        }
        super.doOKAction();
    }

    private boolean commitStepData(ModuleWizardStep step) {
        try {
            if (!step.validate()) {
                return false;
            }
        }
        catch (ConfigurationException e) {
            Messages.showErrorDialog((Project)this.myCurrentProject, (String)e.getMessage(), (String)e.getTitle());
            return false;
        }
        step.updateDataModel();
        return true;
    }

    protected void doNextAction() {
        ModuleWizardStep step = (ModuleWizardStep)this.getCurrentStepObject();
        if (!this.commitStepData(step)) {
            return;
        }
        step.onStepLeaving();
        super.doNextAction();
    }

    protected void doPreviousAction() {
        ModuleWizardStep step = (ModuleWizardStep)this.getCurrentStepObject();
        step.onStepLeaving();
        super.doPreviousAction();
    }

    public void doCancelAction() {
        ModuleWizardStep step = (ModuleWizardStep)this.getCurrentStepObject();
        step.onStepLeaving();
        super.doCancelAction();
    }

    private void updateButtons() {
        boolean isLastStep = this.isLastStep(this.getCurrentStep());
        this.getNextButton().setEnabled(!isLastStep);
        this.getFinishButton().setEnabled(isLastStep);
        this.getRootPane().setDefaultButton(isLastStep ? this.getFinishButton() : this.getNextButton());
    }

    private boolean isLastStep(int step) {
        return this.getNextStep(step) == step;
    }

    protected String getHelpID() {
        ModuleWizardStep step = (ModuleWizardStep)this.getCurrentStepObject();
        if (step != null) {
            return step.getHelpId();
        }
        return null;
    }

    protected final int getNextStep(int step) {
        ModuleWizardStep nextStep = null;
        StepSequence stepSequence = this.getMode().getSteps(this.myWizardContext, null);
        if (stepSequence != null) {
            if (this.myRootStep == this.mySteps.get(step)) {
                return this.mySteps.indexOf(stepSequence.getCommonSteps().get(0));
            }
            nextStep = stepSequence.getNextStep((ModuleWizardStep)this.mySteps.get(step));
            while (nextStep != null && !nextStep.isStepVisible()) {
                nextStep = stepSequence.getNextStep(nextStep);
            }
        }
        return nextStep == null ? step : this.mySteps.indexOf(nextStep);
    }

    protected final int getPreviousStep(int step) {
        ModuleWizardStep previousStep = null;
        StepSequence stepSequence = this.getMode().getSteps(this.myWizardContext, null);
        if (stepSequence != null) {
            previousStep = stepSequence.getPreviousStep((ModuleWizardStep)this.mySteps.get(step));
            while (previousStep != null && !previousStep.isStepVisible()) {
                previousStep = stepSequence.getPreviousStep(previousStep);
            }
        }
        return previousStep == null ? 0 : this.mySteps.indexOf(previousStep);
    }

    private WizardMode getMode() {
        return this.myRootStep.getMode();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getNewProjectFilePath() {
        String string;
        if (this.myWizardContext.getProjectStorageFormat() == StorageScheme.DEFAULT) {
            string = this.myWizardContext.getProjectFileDirectory() + File.separator + this.myWizardContext.getProjectName() + ".ipr";
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/ide/util/newProjectWizard/AddModuleWizard.getNewProjectFilePath must not return null");
            return string;
        }
        string = this.myWizardContext.getProjectFileDirectory();
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/ide/util/newProjectWizard/AddModuleWizard.getNewProjectFilePath must not return null");
    }

    @NotNull
    public StorageScheme getStorageScheme() {
        StorageScheme storageScheme = this.myWizardContext.getProjectStorageFormat();
        if (storageScheme == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/newProjectWizard/AddModuleWizard.getStorageScheme must not return null");
        }
        return storageScheme;
    }

    @Nullable
    public static Sdk getNewProjectJdk(WizardContext context) {
        if (context.getProjectJdk() != null) {
            return context.getProjectJdk();
        }
        Project project = context.getProject() == null ? ProjectManager.getInstance().getDefaultProject() : context.getProject();
        Sdk projectJdk = ProjectRootManager.getInstance((Project)project).getProjectJdk();
        if (projectJdk != null) {
            return projectJdk;
        }
        if (context.getProject() == null) {
            final ProjectBuilder projectBuilder = context.getProjectBuilder();
            return ProjectJdkTable.getInstance().findMostRecentSdk((Condition)new Condition<Sdk>(){

                public boolean value(Sdk sdk) {
                    return projectBuilder == null || projectBuilder.isSuitableSdk(sdk);
                }
            });
        }
        return null;
    }

    @Nullable
    public Sdk getNewProjectJdk() {
        return AddModuleWizard.getNewProjectJdk(this.myWizardContext);
    }

    @NotNull
    public String getNewCompileOutput() {
        String projectFilePath = this.myWizardContext.getProjectFileDirectory();
        String path = this.myWizardContext.getCompilerOutputDirectory();
        if (path == null) {
            path = StringUtil.endsWithChar((CharSequence)projectFilePath, (char)'/') ? projectFilePath + "out" : projectFilePath + "/out";
        }
        String string = path;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/newProjectWizard/AddModuleWizard.getNewCompileOutput must not return null");
        }
        return string;
    }

    @NonNls
    public String getModuleFilePath() {
        return this.myWizardContext.getProjectFileDirectory() + File.separator + this.myWizardContext.getProjectName() + ".iml";
    }

    public ProjectBuilder getProjectBuilder() {
        return this.myWizardContext.getProjectBuilder();
    }

    public String getProjectName() {
        return this.myWizardContext.getProjectName();
    }

    protected String getDimensionServiceKey() {
        return "NewModule_or_Project.wizard";
    }
}

