/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.impl;

import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CustomFileTypeBraceMatcher
implements BraceMatcher {
    CustomFileTypeBraceMatcher() {
    }

    @Override
    public int getBraceTokenGroupId(IElementType tokenType) {
        return 777;
    }

    @Override
    public boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        IElementType tokenType = iterator.getTokenType();
        return tokenType == CustomHighlighterTokenType.L_BRACKET || tokenType == CustomHighlighterTokenType.L_PARENTH || tokenType == CustomHighlighterTokenType.L_BRACE;
    }

    @Override
    public boolean isRBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        IElementType tokenType = iterator.getTokenType();
        return tokenType == CustomHighlighterTokenType.R_BRACKET || tokenType == CustomHighlighterTokenType.R_PARENTH || tokenType == CustomHighlighterTokenType.R_BRACE;
    }

    @Override
    public boolean isPairBraces(IElementType tokenType, IElementType tokenType2) {
        return tokenType == CustomHighlighterTokenType.L_BRACE && tokenType2 == CustomHighlighterTokenType.R_BRACE || tokenType == CustomHighlighterTokenType.R_BRACE && tokenType2 == CustomHighlighterTokenType.L_BRACE || tokenType == CustomHighlighterTokenType.L_BRACKET && tokenType2 == CustomHighlighterTokenType.R_BRACKET || tokenType == CustomHighlighterTokenType.R_BRACKET && tokenType2 == CustomHighlighterTokenType.L_BRACKET || tokenType == CustomHighlighterTokenType.L_PARENTH && tokenType2 == CustomHighlighterTokenType.R_PARENTH || tokenType == CustomHighlighterTokenType.R_PARENTH && tokenType2 == CustomHighlighterTokenType.L_PARENTH;
    }

    @Override
    public boolean isStructuralBrace(HighlighterIterator iterator, CharSequence text, FileType fileType) {
        IElementType type = iterator.getTokenType();
        return type == CustomHighlighterTokenType.L_BRACE || type == CustomHighlighterTokenType.R_BRACE;
    }

    @Override
    public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/highlighter/custom/impl/CustomFileTypeBraceMatcher.getOppositeBraceTokenType must not be null");
        }
        if (!(type instanceof CustomHighlighterTokenType.CustomElementType)) {
            return null;
        }
        if (type == CustomHighlighterTokenType.L_BRACE) {
            return CustomHighlighterTokenType.R_BRACE;
        }
        if (type == CustomHighlighterTokenType.R_BRACE) {
            return CustomHighlighterTokenType.L_BRACE;
        }
        if (type == CustomHighlighterTokenType.L_BRACKET) {
            return CustomHighlighterTokenType.R_BRACKET;
        }
        if (type == CustomHighlighterTokenType.R_BRACKET) {
            return CustomHighlighterTokenType.L_BRACKET;
        }
        if (type == CustomHighlighterTokenType.L_PARENTH) {
            return CustomHighlighterTokenType.R_PARENTH;
        }
        if (type == CustomHighlighterTokenType.R_PARENTH) {
            return CustomHighlighterTokenType.L_PARENTH;
        }
        return null;
    }

    @Override
    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (lbraceType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/highlighter/custom/impl/CustomFileTypeBraceMatcher.isPairedBracesAllowedBeforeType must not be null");
        }
        return true;
    }

    @Override
    public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
        return openingBraceOffset;
    }
}

