/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindSettings;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUsagesOptions
extends UserDataHolderBase
implements Cloneable {
    public SearchScope searchScope;
    public boolean isSearchForTextOccurences;
    public boolean isUsages;
    public boolean isClassesUsages;
    public boolean isMethodsUsages;
    public boolean isFieldsUsages;
    public boolean isDerivedClasses;
    public boolean isImplementingClasses;
    public boolean isDerivedInterfaces;
    public boolean isOverridingMethods;
    public boolean isImplementingMethods;
    public boolean isIncludeSubpackages;
    public boolean isSkipImportStatements;
    public boolean isSkipPackageStatements;
    public boolean isCheckDeepInheritance;
    public boolean isIncludeInherited;
    public boolean isReadAccess;
    public boolean isWriteAccess;
    public boolean isIncludeOverloadUsages;
    public boolean isThrowUsages;

    public FindUsagesOptions(@NotNull Project project, @Nullable DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesOptions.<init> must not be null");
        }
        this.isSearchForTextOccurences = true;
        this.isUsages = false;
        this.isClassesUsages = false;
        this.isMethodsUsages = false;
        this.isFieldsUsages = false;
        this.isDerivedClasses = false;
        this.isImplementingClasses = false;
        this.isDerivedInterfaces = false;
        this.isOverridingMethods = false;
        this.isImplementingMethods = false;
        this.isIncludeSubpackages = true;
        this.isSkipImportStatements = false;
        this.isSkipPackageStatements = false;
        this.isCheckDeepInheritance = true;
        this.isIncludeInherited = false;
        this.isReadAccess = false;
        this.isWriteAccess = false;
        this.isIncludeOverloadUsages = false;
        this.isThrowUsages = false;
        String defaultScopeName = FindSettings.getInstance().getDefaultScopeName();
        List<SearchScope> predefined = ScopeChooserCombo.getPredefinedScopes(project, dataContext, true, false, false, false);
        for (SearchScope scope : predefined) {
            if (!scope.getDisplayName().equals(defaultScopeName)) continue;
            this.searchScope = scope;
            break;
        }
        if (this.searchScope == null) {
            this.searchScope = ProjectScope.getProjectScope((Project)project);
        }
    }

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindUsagesOptions that = (FindUsagesOptions)o;
        if (this.isCheckDeepInheritance != that.isCheckDeepInheritance) {
            return false;
        }
        if (this.isClassesUsages != that.isClassesUsages) {
            return false;
        }
        if (this.isDerivedClasses != that.isDerivedClasses) {
            return false;
        }
        if (this.isDerivedInterfaces != that.isDerivedInterfaces) {
            return false;
        }
        if (this.isFieldsUsages != that.isFieldsUsages) {
            return false;
        }
        if (this.isImplementingClasses != that.isImplementingClasses) {
            return false;
        }
        if (this.isImplementingMethods != that.isImplementingMethods) {
            return false;
        }
        if (this.isIncludeInherited != that.isIncludeInherited) {
            return false;
        }
        if (this.isIncludeOverloadUsages != that.isIncludeOverloadUsages) {
            return false;
        }
        if (this.isIncludeSubpackages != that.isIncludeSubpackages) {
            return false;
        }
        if (this.isMethodsUsages != that.isMethodsUsages) {
            return false;
        }
        if (this.isOverridingMethods != that.isOverridingMethods) {
            return false;
        }
        if (this.isReadAccess != that.isReadAccess) {
            return false;
        }
        if (this.isSearchForTextOccurences != that.isSearchForTextOccurences) {
            return false;
        }
        if (this.isSkipImportStatements != that.isSkipImportStatements) {
            return false;
        }
        if (this.isSkipPackageStatements != that.isSkipPackageStatements) {
            return false;
        }
        if (this.isThrowUsages != that.isThrowUsages) {
            return false;
        }
        if (this.isUsages != that.isUsages) {
            return false;
        }
        if (this.isWriteAccess != that.isWriteAccess) {
            return false;
        }
        return !(this.searchScope != null ? !this.searchScope.equals(that.searchScope) : that.searchScope != null);
    }

    public int hashCode() {
        int result = this.searchScope != null ? this.searchScope.hashCode() : 0;
        result = 31 * result + (this.isSearchForTextOccurences ? 1 : 0);
        result = 31 * result + (this.isUsages ? 1 : 0);
        result = 31 * result + (this.isClassesUsages ? 1 : 0);
        result = 31 * result + (this.isMethodsUsages ? 1 : 0);
        result = 31 * result + (this.isFieldsUsages ? 1 : 0);
        result = 31 * result + (this.isDerivedClasses ? 1 : 0);
        result = 31 * result + (this.isImplementingClasses ? 1 : 0);
        result = 31 * result + (this.isDerivedInterfaces ? 1 : 0);
        result = 31 * result + (this.isOverridingMethods ? 1 : 0);
        result = 31 * result + (this.isImplementingMethods ? 1 : 0);
        result = 31 * result + (this.isIncludeSubpackages ? 1 : 0);
        result = 31 * result + (this.isSkipImportStatements ? 1 : 0);
        result = 31 * result + (this.isSkipPackageStatements ? 1 : 0);
        result = 31 * result + (this.isCheckDeepInheritance ? 1 : 0);
        result = 31 * result + (this.isIncludeInherited ? 1 : 0);
        result = 31 * result + (this.isReadAccess ? 1 : 0);
        result = 31 * result + (this.isWriteAccess ? 1 : 0);
        result = 31 * result + (this.isIncludeOverloadUsages ? 1 : 0);
        result = 31 * result + (this.isThrowUsages ? 1 : 0);
        return result;
    }
}

