/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.facetType;

import com.intellij.facet.FacetType;
import com.intellij.facet.impl.autodetecting.DisabledAutodetectionByTypeElement;
import com.intellij.facet.impl.autodetecting.DisabledAutodetectionInModuleElement;
import com.intellij.facet.impl.autodetecting.FacetAutodetectingManager;
import com.intellij.facet.impl.autodetecting.FacetAutodetectingManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ChooseModulesDialog;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ListUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Icons;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetAutodetectionConfigurable
implements Configurable {
    private final Project myProject;
    private final StructureConfigurableContext myContext;
    private final FacetType<?, ?> myFacetType;
    private JPanel myMainPanel;
    private JCheckBox myEnableAutoDetectionCheckBox;
    private JList myModulesList;
    private JButton myAddModuleButton;
    private JButton myRemoveModuleButton;
    private JList myFilesList;
    private JButton myRemoveFileButton;
    private JPanel mySettingsPanel;
    private JPanel mySkipFilesListPanel;
    private final DefaultListModel myModulesListModel;
    private final DefaultListModel myFilesListModel;
    private final BidirectionalMap<String, String> myFile2Module;
    private final Set<String> myRemovedModules;
    private final Set<String> myAddedModules;
    private final Set<String> myRemovedFiles;
    private boolean myAutodetectionWasEnabled;

    public FacetAutodetectionConfigurable(@NotNull Project project, StructureConfigurableContext context, @NotNull FacetType<?, ?> facetType) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/facetType/FacetAutodetectionConfigurable.<init> must not be null");
        }
        if (facetType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/ui/facetType/FacetAutodetectionConfigurable.<init> must not be null");
        }
        this.$$$setupUI$$$();
        this.myFile2Module = new BidirectionalMap();
        this.myRemovedModules = new HashSet<String>();
        this.myAddedModules = new HashSet<String>();
        this.myRemovedFiles = new HashSet<String>();
        this.myProject = project;
        this.myContext = context;
        this.myFacetType = facetType;
        this.myModulesList.setCellRenderer(new ModulesListCellRenderer());
        this.myModulesListModel = new DefaultListModel();
        this.myModulesList.setModel(this.myModulesListModel);
        this.myFilesList.setCellRenderer(new FilesListCellRenderer());
        this.myFilesListModel = new DefaultListModel();
        this.myFilesList.setModel(this.myFilesListModel);
        this.myAddModuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String description = ProjectBundle.message((String)"choose.description.facet.auto.detection.will.be.disabled.in.the.selected.modules", (Object[])new Object[]{FacetAutodetectionConfigurable.this.myFacetType.getPresentableName()});
                String title = ProjectBundle.message((String)"choose.modules.dialog.title", (Object[])new Object[0]);
                ChooseModulesDialog dialog = new ChooseModulesDialog(FacetAutodetectionConfigurable.this.myProject, FacetAutodetectionConfigurable.this.getEnabledModules(), title, description);
                dialog.show();
                List chosenElements = dialog.getChosenElements();
                if (dialog.isOK() && !chosenElements.isEmpty()) {
                    for (Module module : chosenElements) {
                        String moduleName = module.getName();
                        FacetAutodetectionConfigurable.this.myModulesListModel.addElement(moduleName);
                        if (FacetAutodetectionConfigurable.this.myRemovedModules.remove(moduleName)) continue;
                        FacetAutodetectionConfigurable.this.myAddedModules.add(moduleName);
                    }
                    FacetAutodetectionConfigurable.this.updateButtons();
                    FacetAutodetectionConfigurable.this.myModulesList.repaint();
                }
            }
        });
        this.myRemoveModuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List removed = ListUtil.removeSelectedItems((JList)FacetAutodetectionConfigurable.this.myModulesList);
                for (String moduleName : removed) {
                    if (FacetAutodetectionConfigurable.this.myAddedModules.remove(moduleName)) continue;
                    FacetAutodetectionConfigurable.this.myRemovedModules.add(moduleName);
                }
                FacetAutodetectionConfigurable.this.updateButtons();
            }
        });
        this.myRemoveFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List removed = ListUtil.removeSelectedItems((JList)FacetAutodetectionConfigurable.this.myFilesList);
                FacetAutodetectionConfigurable.this.myRemovedFiles.addAll(removed);
                FacetAutodetectionConfigurable.this.updateButtons();
            }
        });
        this.myEnableAutoDetectionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FacetAutodetectionConfigurable.this.updateButtons();
            }
        });
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FacetAutodetectionConfigurable.this.updateRemoveButtons();
            }
        };
        this.myFilesList.addListSelectionListener(selectionListener);
        this.myModulesList.addListSelectionListener(selectionListener);
    }

    private List<Module> getEnabledModules() {
        ArrayList<Module> modules = new ArrayList<Module>(Arrays.asList(this.getAllModules()));
        Iterator iterator = modules.iterator();
        Set<String> disabled = this.getDisabledModules();
        while (iterator.hasNext()) {
            Module module = (Module)iterator.next();
            if (!disabled.contains(module.getName())) continue;
            iterator.remove();
        }
        return modules;
    }

    protected Module[] getAllModules() {
        return this.myContext.getModules();
    }

    private Set<String> getDisabledModules() {
        LinkedHashSet<String> disabled = new LinkedHashSet<String>();
        for (int i = 0; i < this.myModulesListModel.getSize(); ++i) {
            disabled.add((String)this.myModulesListModel.getElementAt(i));
        }
        return disabled;
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"auto.detection.configurable.display.name", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.project.structure.facet";
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return this.myAutodetectionWasEnabled != this.myEnableAutoDetectionCheckBox.isSelected() || !this.myRemovedFiles.isEmpty() || !this.myAddedModules.isEmpty() || !this.myRemovedModules.isEmpty();
    }

    public void apply() throws ConfigurationException {
        DisabledAutodetectionByTypeElement state = this.getAutodetectingManager().getDisabledAutodetectionState(this.myFacetType);
        DisabledAutodetectionByTypeElement newState = this.modifyState(state);
        this.getAutodetectingManager().setDisabledAutodetectionState(this.myFacetType, newState);
    }

    @Nullable
    private DisabledAutodetectionByTypeElement modifyState(DisabledAutodetectionByTypeElement state) {
        if (!this.myEnableAutoDetectionCheckBox.isSelected()) {
            return new DisabledAutodetectionByTypeElement(this.myFacetType.getStringId());
        }
        if (state == null) {
            if (this.myAddedModules.isEmpty()) {
                return null;
            }
            DisabledAutodetectionByTypeElement newState = new DisabledAutodetectionByTypeElement(this.myFacetType.getStringId());
            for (String moduleName : this.myAddedModules) {
                newState.getModuleElements().add(new DisabledAutodetectionInModuleElement(moduleName));
            }
            return newState;
        }
        DisabledAutodetectionByTypeElement newState = this.copyState(state);
        boolean someModuleRemoved = false;
        for (String url : this.myRemovedFiles) {
            boolean removed;
            String moduleName = (String)this.myFile2Module.get((Object)url);
            DisabledAutodetectionInModuleElement element = newState.findElement(moduleName);
            if (element == null || !(removed = element.getFiles().remove(url) | element.getDirectories().remove(url)) || !element.isDisableInWholeModule()) continue;
            newState.removeDisabled(moduleName);
            someModuleRemoved = true;
        }
        for (String moduleName : this.myAddedModules) {
            newState.getModuleElements().add(new DisabledAutodetectionInModuleElement(moduleName));
        }
        for (String moduleName : this.myRemovedModules) {
            someModuleRemoved |= newState.findElement(moduleName) != null;
            newState.removeDisabled(moduleName);
        }
        if ((someModuleRemoved || !this.myAutodetectionWasEnabled) && newState.getModuleElements().isEmpty()) {
            return null;
        }
        return newState;
    }

    private DisabledAutodetectionByTypeElement copyState(DisabledAutodetectionByTypeElement state) {
        DisabledAutodetectionByTypeElement newState = new DisabledAutodetectionByTypeElement(this.myFacetType.getStringId());
        for (DisabledAutodetectionInModuleElement moduleElement : state.getModuleElements()) {
            DisabledAutodetectionInModuleElement newModuleElement = new DisabledAutodetectionInModuleElement(moduleElement.getModuleName());
            newModuleElement.getFiles().addAll(moduleElement.getFiles());
            newModuleElement.getDirectories().addAll(moduleElement.getDirectories());
            newState.getModuleElements().add(newModuleElement);
        }
        return newState;
    }

    public void reset() {
        DisabledAutodetectionByTypeElement autodetectionInfo = this.getAutodetectingManager().getDisabledAutodetectionState(this.myFacetType);
        this.myModulesListModel.removeAllElements();
        this.myFilesListModel.removeAllElements();
        this.myFile2Module.clear();
        this.myRemovedModules.clear();
        this.myAddedModules.clear();
        this.myRemovedFiles.clear();
        this.myEnableAutoDetectionCheckBox.setSelected(true);
        if (autodetectionInfo != null) {
            List<DisabledAutodetectionInModuleElement> moduleElements = autodetectionInfo.getModuleElements();
            if (moduleElements.isEmpty()) {
                this.myEnableAutoDetectionCheckBox.setSelected(false);
            } else {
                ArrayList<String> modules = new ArrayList<String>();
                ArrayList<String> urls = new ArrayList<String>();
                for (DisabledAutodetectionInModuleElement moduleElement : moduleElements) {
                    String moduleName = moduleElement.getModuleName();
                    if (moduleElement.isDisableInWholeModule()) {
                        modules.add(moduleName);
                        continue;
                    }
                    for (String url : moduleElement.getFiles()) {
                        this.myFile2Module.put((Object)url, (Object)moduleName);
                        urls.add(url);
                    }
                    for (String url : moduleElement.getDirectories()) {
                        this.myFile2Module.put((Object)url, (Object)moduleName);
                        urls.add(url);
                    }
                }
                Collections.sort(urls);
                Collections.sort(modules);
                for (String url : urls) {
                    this.myFilesListModel.addElement(url);
                }
                for (String moduleName : modules) {
                    this.myModulesListModel.addElement(moduleName);
                }
            }
        }
        this.myAutodetectionWasEnabled = this.myEnableAutoDetectionCheckBox.isSelected();
        this.mySkipFilesListPanel.setVisible(!this.myFilesListModel.isEmpty());
        this.updateButtons();
    }

    public Set<String> getRemovedModules() {
        return this.myRemovedModules;
    }

    public Set<String> getAddedModules() {
        return this.myAddedModules;
    }

    public Set<String> getRemovedFiles() {
        return this.myRemovedFiles;
    }

    public JCheckBox getEnableAutoDetectionCheckBox() {
        return this.myEnableAutoDetectionCheckBox;
    }

    private void updateButtons() {
        if (!this.myEnableAutoDetectionCheckBox.isSelected()) {
            UIUtil.setEnabled((Component)this.mySettingsPanel, (boolean)false, (boolean)true);
            return;
        }
        UIUtil.setEnabled((Component)this.mySettingsPanel, (boolean)true, (boolean)true);
        this.myAddModuleButton.setEnabled(!this.getEnabledModules().isEmpty());
        this.updateRemoveButtons();
    }

    private void updateRemoveButtons() {
        this.myRemoveModuleButton.setEnabled(this.myEnableAutoDetectionCheckBox.isSelected() && this.myModulesList.getSelectedIndices().length > 0);
        this.myRemoveFileButton.setEnabled(this.myEnableAutoDetectionCheckBox.isSelected() && this.myFilesList.getSelectedIndices().length > 0);
    }

    private FacetAutodetectingManagerImpl getAutodetectingManager() {
        return (FacetAutodetectingManagerImpl)FacetAutodetectingManager.getInstance(this.myProject);
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JList jList;
        JButton jButton;
        JPanel jPanel;
        JList jList2;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEnableAutoDetectionCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ProjectBundle").getString("checkbox.text.enable.auto.detection"));
        jCheckBox.setSelected(true);
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.mySettingsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/ProjectBundle").getString("label.text.autodetection.skip.modules"), 0, 0, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 1, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myRemoveModuleButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("messages/ProjectBundle").getString("button.remove"));
        jPanel5.add((Component)jButton3, new GridConstraints(1, 0, 1, 1, 0, 1, 1, 0, null, null, null));
        this.myAddModuleButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/ProjectBundle").getString("button.add"));
        jPanel5.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 1, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, new Dimension(180, -1), null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel6.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 1, null, new Dimension(250, 120), null));
        this.myModulesList = jList2 = new JList();
        jScrollPane.setViewportView(jList2);
        this.mySkipFilesListPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/ProjectBundle").getString("label.text.autodetection.skip.files"), 0, 0, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel7, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRemoveFileButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/ProjectBundle").getString("button.text.autodetection.remove.file"));
        jPanel7.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel7.add((Component)spacer4, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel8.add((Component)jScrollPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 1, null, new Dimension(350, 120), null));
        this.myFilesList = jList = new JList();
        jScrollPane2.setViewportView(jList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class ModulesListCellRenderer
    extends ColoredListCellRenderer {
        private ModulesListCellRenderer() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            String moduleName = (String)value;
            Module module = ((FacetAutodetectionConfigurable)FacetAutodetectionConfigurable.this).myContext.myModulesConfigurator.getModule(moduleName);
            if (module != null) {
                this.append(moduleName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.setIcon(module.getModuleType().getNodeIcon(false));
            } else {
                this.append(moduleName, SimpleTextAttributes.ERROR_ATTRIBUTES);
                this.setIcon(null);
            }
        }
    }

    private static class FilesListCellRenderer
    extends ColoredListCellRenderer {
        private FilesListCellRenderer() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            String url = (String)value;
            String path = VfsUtil.urlToPath((String)url);
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
            if (file != null) {
                this.append(path, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.setIcon(file.isDirectory() ? Icons.FOLDER_ICON : file.getIcon());
            } else {
                this.append(path, SimpleTextAttributes.ERROR_ATTRIBUTES);
                this.setIcon(null);
            }
        }
    }
}

