/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.configuration;

import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.SortedComboBoxModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.Nullable;

public class ConfigurationModuleSelector {
    private final Project myProject;
    private final JComboBox myModulesList;
    private final SortedComboBoxModel<Object> myModules = new SortedComboBoxModel((Comparator)new Comparator<Object>(){

        @Override
        public int compare(Object module, Object module1) {
            if (module instanceof Module && module1 instanceof Module) {
                return ((Module)module).getName().compareToIgnoreCase(((Module)module1).getName());
            }
            return -1;
        }
    });
    private static final String NO_MODULE = "<no module>";

    public ConfigurationModuleSelector(Project project, JComboBox modulesList) {
        this.myProject = project;
        this.myModulesList = modulesList;
        new ComboboxSpeedSearch(modulesList){

            @Override
            protected String getElementText(Object element) {
                if (element instanceof Module) {
                    return ((Module)element).getName();
                }
                if (element == null) {
                    return ConfigurationModuleSelector.NO_MODULE;
                }
                return super.getElementText(element);
            }
        };
        this.myModulesList.setModel(this.myModules);
        this.myModulesList.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof Module) {
                    Module module = (Module)value;
                    this.setIcon(module.getModuleType().getNodeIcon(true));
                    this.setText(module.getName());
                } else if (value == null) {
                    this.setText(ConfigurationModuleSelector.NO_MODULE);
                }
                return component;
            }
        });
    }

    public void applyTo(ModuleBasedConfiguration configurationModule) {
        configurationModule.setModule((Module)this.myModulesList.getSelectedItem());
    }

    public void reset(ModuleBasedConfiguration configuration) {
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        ArrayList<Module> list = new ArrayList<Module>();
        for (Module module : modules) {
            if (!ConfigurationModuleSelector.isModuleAccepted(module)) continue;
            list.add(module);
        }
        this.setModules(list);
        this.myModules.setSelectedItem((Object)configuration.getConfigurationModule().getModule());
    }

    public static boolean isModuleAccepted(Module module) {
        return ModuleTypeManager.getInstance().isClasspathProvider(module.getModuleType());
    }

    public Project getProject() {
        return this.myProject;
    }

    public JavaRunConfigurationModule getConfigurationModule() {
        JavaRunConfigurationModule configurationModule = new JavaRunConfigurationModule(this.getProject(), false);
        configurationModule.setModule((Module)this.myModules.getSelectedItem());
        return configurationModule;
    }

    private void setModules(Collection<Module> modules) {
        this.myModules.clear();
        this.myModules.add(null);
        for (Module module : modules) {
            this.myModules.add((Object)module);
        }
    }

    public Module getModule() {
        return (Module)this.myModules.getSelectedItem();
    }

    @Nullable
    public PsiClass findClass(String className) {
        return this.getConfigurationModule().findClass(className);
    }

    public String getModuleName() {
        Module module = (Module)this.myModules.getSelectedItem();
        return module == null ? "" : module.getName();
    }
}

