/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.DebuggerExpressionTextField;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.ReferenceRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.TableUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.Table;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;

public class CompoundRendererConfigurable
implements UnnamedConfigurable {
    private CompoundReferenceRenderer myRenderer;
    private CompoundReferenceRenderer myOriginalRenderer;
    private final Project myProject;
    private TextFieldWithBrowseButton myClassNameField;
    private JRadioButton myRbDefaultLabel;
    private JRadioButton myRbExpressionLabel;
    private JRadioButton myRbDefaultChildrenRenderer;
    private JRadioButton myRbExpressionChildrenRenderer;
    private JRadioButton myRbListChildrenRenderer;
    private DebuggerExpressionTextField myLabelEditor;
    private DebuggerExpressionTextField myChildrenEditor;
    private DebuggerExpressionTextField myChildrenExpandedEditor;
    private DebuggerExpressionTextField myListChildrenEditor;
    private JComponent myChildrenListEditor;
    private JLabel myExpandedLabel;
    private JPanel myMainPanel;
    private Table myTable;
    @NonNls
    private static final String EMPTY_PANEL_ID = "EMPTY";
    @NonNls
    private static final String DATA_PANEL_ID = "DATA";
    private JButton myAddButton;
    private JButton myRemoveButton;
    private JButton myUpButton;
    private JButton myDownButton;
    private static final int NAME_TABLE_COLUMN = 0;
    private static final int EXPRESSION_TABLE_COLUMN = 1;

    public CompoundRendererConfigurable(Project project) {
        this.myProject = project;
    }

    public void setRenderer(NodeRenderer renderer) {
        if (renderer instanceof CompoundReferenceRenderer) {
            this.myRenderer = (CompoundReferenceRenderer)renderer;
            this.myOriginalRenderer = (CompoundReferenceRenderer)renderer.clone();
        } else {
            this.myOriginalRenderer = null;
            this.myRenderer = null;
        }
        this.reset();
    }

    public CompoundReferenceRenderer getRenderer() {
        return this.myRenderer;
    }

    public JComponent createComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.myClassNameField = new TextFieldWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PsiClass psiClass = DebuggerUtils.getInstance().chooseClassDialog(DebuggerBundle.message((String)"title.compound.renderer.configurable.choose.renderer.reference.type", (Object[])new Object[0]), CompoundRendererConfigurable.this.myProject);
                if (psiClass != null) {
                    CompoundRendererConfigurable.this.myClassNameField.setText(JVMNameUtil.getNonAnonymousClassName(psiClass));
                }
            }
        });
        this.myClassNameField.getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String qName = CompoundRendererConfigurable.this.myClassNameField.getText();
                CompoundRendererConfigurable.this.updateContext(qName);
            }
        });
        this.myRbDefaultLabel = new JRadioButton(DebuggerBundle.message((String)"label.compound.renderer.configurable.use.default.renderer", (Object[])new Object[0]));
        this.myRbExpressionLabel = new JRadioButton(DebuggerBundle.message((String)"label.compound.renderer.configurable.use.expression", (Object[])new Object[0]));
        ButtonGroup labelButtonsGroup = new ButtonGroup();
        labelButtonsGroup.add(this.myRbDefaultLabel);
        labelButtonsGroup.add(this.myRbExpressionLabel);
        this.myRbDefaultChildrenRenderer = new JRadioButton(DebuggerBundle.message((String)"label.compound.renderer.configurable.use.default.renderer", (Object[])new Object[0]));
        this.myRbExpressionChildrenRenderer = new JRadioButton(DebuggerBundle.message((String)"label.compound.renderer.configurable.use.expression", (Object[])new Object[0]));
        this.myRbListChildrenRenderer = new JRadioButton(DebuggerBundle.message((String)"label.compound.renderer.configurable.use.expression.list", (Object[])new Object[0]));
        ButtonGroup childrenButtonGroup = new ButtonGroup();
        childrenButtonGroup.add(this.myRbDefaultChildrenRenderer);
        childrenButtonGroup.add(this.myRbExpressionChildrenRenderer);
        childrenButtonGroup.add(this.myRbListChildrenRenderer);
        this.myLabelEditor = new DebuggerExpressionTextField(this.myProject, null, "ClassLabelExpression");
        this.myChildrenEditor = new DebuggerExpressionTextField(this.myProject, null, "ClassChildrenExpression");
        this.myChildrenExpandedEditor = new DebuggerExpressionTextField(this.myProject, null, "ClassChildrenExpression");
        this.myChildrenListEditor = this.createChildrenListEditor();
        ItemListener updateListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CompoundRendererConfigurable.this.updateEnabledState();
            }
        };
        this.myRbExpressionLabel.addItemListener(updateListener);
        this.myRbListChildrenRenderer.addItemListener(updateListener);
        this.myRbExpressionChildrenRenderer.addItemListener(updateListener);
        panel.add((Component)new JLabel(DebuggerBundle.message((String)"label.compound.renderer.configurable.apply.to", (Object[])new Object[0])), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.myClassNameField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(4, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(DebuggerBundle.message((String)"label.compound.renderer.configurable.when.rendering", (Object[])new Object[0])), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(20, 0, 0, 0), 0, 0));
        panel.add((Component)this.myRbDefaultLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.myRbExpressionLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.myLabelEditor, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 30, 0, 0), 0, 0));
        panel.add((Component)new JLabel(DebuggerBundle.message((String)"label.compound.renderer.configurable.when.expanding", (Object[])new Object[0])), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(20, 0, 0, 0), 0, 0));
        panel.add((Component)this.myRbDefaultChildrenRenderer, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.myRbExpressionChildrenRenderer, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.myChildrenEditor, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 30, 0, 0), 0, 0));
        this.myExpandedLabel = new JLabel(DebuggerBundle.message((String)"label.compound.renderer.configurable.test.can.expand", (Object[])new Object[0]));
        panel.add((Component)this.myExpandedLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, 30, 0, 0), 0, 0));
        panel.add((Component)this.myChildrenExpandedEditor, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 30, 0, 0), 0, 0));
        panel.add((Component)this.myRbListChildrenRenderer, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.myChildrenListEditor, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, new Insets(4, 30, 0, 0), 0, 0));
        this.myMainPanel = new JPanel(new CardLayout());
        this.myMainPanel.add((Component)new JPanel(), EMPTY_PANEL_ID);
        this.myMainPanel.add((Component)panel, DATA_PANEL_ID);
        return this.myMainPanel;
    }

    private void updateContext(final String qName) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiClass psiClass = DebuggerUtils.findClass((String)qName, (Project)CompoundRendererConfigurable.this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)CompoundRendererConfigurable.this.myProject));
                CompoundRendererConfigurable.this.myLabelEditor.setContext((PsiElement)psiClass);
                CompoundRendererConfigurable.this.myChildrenEditor.setContext((PsiElement)psiClass);
                CompoundRendererConfigurable.this.myChildrenExpandedEditor.setContext((PsiElement)psiClass);
                CompoundRendererConfigurable.this.myListChildrenEditor.setContext((PsiElement)psiClass);
            }
        });
    }

    private void updateEnabledState() {
        this.myLabelEditor.setEnabled(this.myRbExpressionLabel.isSelected());
        boolean isChildrenExpression = this.myRbExpressionChildrenRenderer.isSelected();
        this.myChildrenExpandedEditor.setEnabled(isChildrenExpression);
        this.myExpandedLabel.setEnabled(isChildrenExpression);
        this.myChildrenEditor.setEnabled(isChildrenExpression);
        this.myChildrenListEditor.setEnabled(this.myRbListChildrenRenderer.isSelected());
    }

    private JComponent createChildrenListEditor() {
        final MyTableModel tableModel = new MyTableModel();
        this.myTable = new Table((TableModel)tableModel);
        this.myListChildrenEditor = new DebuggerExpressionTextField(this.myProject, null, "NamedChildrenConfigurable");
        TableColumn exprColumn = this.myTable.getColumnModel().getColumn(1);
        exprColumn.setCellEditor((TableCellEditor)new AbstractTableCellEditor(){

            public Object getCellEditorValue() {
                return CompoundRendererConfigurable.this.myListChildrenEditor.getText();
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                CompoundRendererConfigurable.this.myListChildrenEditor.setText((TextWithImports)value);
                return CompoundRendererConfigurable.this.myListChildrenEditor;
            }
        });
        exprColumn.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                TextWithImports textWithImports = (TextWithImports)value;
                String text = textWithImports != null ? textWithImports.toString() : "";
                return super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
            }
        });
        this.myAddButton = new JButton(DebuggerBundle.message((String)"button.add", (Object[])new Object[0]));
        this.myRemoveButton = new JButton(DebuggerBundle.message((String)"button.remove", (Object[])new Object[0]));
        this.myUpButton = new JButton(DebuggerBundle.message((String)"button.move.up", (Object[])new Object[0]));
        this.myDownButton = new JButton(DebuggerBundle.message((String)"button.move.down", (Object[])new Object[0]));
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tableModel.addRow("", DebuggerUtils.getInstance().createExpressionWithImports(""));
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = CompoundRendererConfigurable.this.myTable.getSelectedRow();
                if (selectedRow >= 0 && selectedRow < CompoundRendererConfigurable.this.myTable.getRowCount()) {
                    CompoundRendererConfigurable.this.getTableModel().removeRow(selectedRow);
                }
            }
        });
        this.myDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableUtil.moveSelectedItemsDown((JTable)CompoundRendererConfigurable.this.myTable);
            }
        });
        this.myUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableUtil.moveSelectedItemsUp((JTable)CompoundRendererConfigurable.this.myTable);
            }
        });
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = CompoundRendererConfigurable.this.myTable.getSelectedRow();
                CompoundRendererConfigurable.this.myRemoveButton.setEnabled(selectedRow != -1);
                CompoundRendererConfigurable.this.myUpButton.setEnabled(selectedRow > 0);
                CompoundRendererConfigurable.this.myDownButton.setEnabled(selectedRow < CompoundRendererConfigurable.this.myTable.getRowCount() - 1);
            }
        });
        JPanel panel = new JPanel(new GridBagLayout()){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                CompoundRendererConfigurable.this.myTable.setEnabled(enabled);
                CompoundRendererConfigurable.this.myAddButton.setEnabled(enabled);
                CompoundRendererConfigurable.this.myRemoveButton.setEnabled(enabled);
                CompoundRendererConfigurable.this.myUpButton.setEnabled(enabled);
                CompoundRendererConfigurable.this.myDownButton.setEnabled(enabled);
            }
        };
        JScrollPane scrollPane = new JScrollPane((Component)this.myTable);
        panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 4, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.myAddButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 4, 4, 0), 0, 0));
        panel.add((Component)this.myRemoveButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 4, 4, 0), 0, 0));
        panel.add((Component)this.myUpButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 4, 4, 0), 0, 0));
        panel.add((Component)this.myDownButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 4, 4, 0), 0, 0));
        return panel;
    }

    public boolean isModified() {
        if (this.myRenderer == null) {
            return false;
        }
        CompoundReferenceRenderer cloned = (CompoundReferenceRenderer)this.myRenderer.clone();
        this.flushDataTo(cloned);
        return !DebuggerUtilsEx.externalizableEqual(cloned, this.myOriginalRenderer);
    }

    public void apply() throws ConfigurationException {
        if (this.myRenderer == null) {
            return;
        }
        this.flushDataTo(this.myRenderer);
        this.myOriginalRenderer = (CompoundReferenceRenderer)this.myRenderer.clone();
    }

    private void flushDataTo(CompoundReferenceRenderer renderer) {
        LabelRenderer labelRenderer = null;
        if (this.myRbExpressionLabel.isSelected()) {
            labelRenderer = new LabelRenderer();
            labelRenderer.setLabelExpression(this.myLabelEditor.getText());
        }
        renderer.setLabelRenderer(labelRenderer);
        ReferenceRenderer childrenRenderer = null;
        if (this.myRbExpressionChildrenRenderer.isSelected()) {
            childrenRenderer = new ExpressionChildrenRenderer();
            childrenRenderer.setChildrenExpression(this.myChildrenEditor.getText());
            childrenRenderer.setChildrenExpandable(this.myChildrenExpandedEditor.getText());
        } else if (this.myRbListChildrenRenderer.isSelected()) {
            childrenRenderer = new EnumerationChildrenRenderer(this.getTableModel().getExpressions());
        }
        renderer.setChildrenRenderer((ChildrenRenderer)((Object)childrenRenderer));
        renderer.setClassName(this.myClassNameField.getText());
    }

    public void reset() {
        TextWithImportsImpl emptyExpressionFragment = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "");
        ((CardLayout)this.myMainPanel.getLayout()).show(this.myMainPanel, this.myRenderer == null ? EMPTY_PANEL_ID : DATA_PANEL_ID);
        if (this.myRenderer == null) {
            return;
        }
        String className = this.myRenderer.getClassName();
        this.myClassNameField.setText(className);
        ValueLabelRenderer labelRenderer = this.myRenderer.getLabelRenderer();
        ChildrenRenderer childrenRenderer = this.myRenderer.getChildrenRenderer();
        NodeRendererSettings rendererSettings = NodeRendererSettings.getInstance();
        if (rendererSettings.isBase(labelRenderer)) {
            this.myRbDefaultLabel.setSelected(true);
            this.myLabelEditor.setText(emptyExpressionFragment);
        } else {
            this.myRbExpressionLabel.setSelected(true);
            this.myLabelEditor.setText(((LabelRenderer)labelRenderer).getLabelExpression());
        }
        if (rendererSettings.isBase(childrenRenderer)) {
            this.myRbDefaultChildrenRenderer.setSelected(true);
            this.myChildrenEditor.setText(emptyExpressionFragment);
            this.myChildrenExpandedEditor.setText(emptyExpressionFragment);
            this.getTableModel().clear();
        } else if (childrenRenderer instanceof ExpressionChildrenRenderer) {
            this.myRbExpressionChildrenRenderer.setSelected(true);
            ExpressionChildrenRenderer exprRenderer = (ExpressionChildrenRenderer)childrenRenderer;
            this.myChildrenEditor.setText(exprRenderer.getChildrenExpression());
            this.myChildrenExpandedEditor.setText(exprRenderer.getChildrenExpandable());
            this.getTableModel().clear();
        } else {
            this.myRbListChildrenRenderer.setSelected(true);
            this.myChildrenEditor.setText(emptyExpressionFragment);
            this.myChildrenExpandedEditor.setText(emptyExpressionFragment);
            if (childrenRenderer instanceof EnumerationChildrenRenderer) {
                this.getTableModel().init(((EnumerationChildrenRenderer)childrenRenderer).getChildren());
            } else {
                this.getTableModel().clear();
            }
        }
        this.updateEnabledState();
        this.updateContext(className);
    }

    public void disposeUIResources() {
        this.myRenderer = null;
        this.myOriginalRenderer = null;
        this.myLabelEditor.dispose();
        this.myChildrenEditor.dispose();
        this.myChildrenExpandedEditor.dispose();
        this.myListChildrenEditor.dispose();
    }

    private MyTableModel getTableModel() {
        return (MyTableModel)this.myTable.getModel();
    }

    private final class MyTableModel
    extends AbstractTableModel {
        private final List<Row> myData = new ArrayList<Row>();

        public MyTableModel(List<Pair<String, TextWithImports>> data) {
            this.init(data);
        }

        public MyTableModel() {
        }

        public void init(List<Pair<String, TextWithImports>> data) {
            this.myData.clear();
            for (Pair<String, TextWithImports> pair : data) {
                this.myData.add(new Row((String)pair.getFirst(), (TextWithImports)pair.getSecond()));
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.myData.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return TextWithImports.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= this.getRowCount()) {
                return null;
            }
            Row row = this.myData.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return row.name;
                }
                case 1: {
                    return row.value;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (rowIndex >= this.getRowCount()) {
                return;
            }
            Row row = this.myData.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    row.name = (String)aValue;
                    break;
                }
                case 1: {
                    row.value = (TextWithImports)aValue;
                }
            }
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return DebuggerBundle.message((String)"label.compound.renderer.configurable.table.header.name", (Object[])new Object[0]);
                }
                case 1: {
                    return DebuggerBundle.message((String)"label.compound.renderer.configurable.table.header.expression", (Object[])new Object[0]);
                }
            }
            return "";
        }

        public void addRow(String name, TextWithImports expressionWithImports) {
            this.myData.add(new Row(name, expressionWithImports));
            int lastRow = this.myData.size() - 1;
            this.fireTableRowsInserted(lastRow, lastRow);
        }

        public void removeRow(int row) {
            if (row >= 0 && row < this.myData.size()) {
                this.myData.remove(row);
                this.fireTableRowsDeleted(row, row);
            }
        }

        public String getNameAt(int row) {
            return row >= 0 && row < this.myData.size() ? this.myData.get((int)row).name : null;
        }

        public TextWithImports getExpressionAt(int row) {
            return row >= 0 && row < this.myData.size() ? this.myData.get((int)row).value : null;
        }

        public void clear() {
            this.myData.clear();
            this.fireTableDataChanged();
        }

        public List<Pair<String, TextWithImports>> getExpressions() {
            ArrayList<Pair<String, TextWithImports>> pairs = new ArrayList<Pair<String, TextWithImports>>(this.myData.size());
            for (Row row : this.myData) {
                pairs.add((Pair<String, TextWithImports>)new Pair((Object)row.name, (Object)row.value));
            }
            return pairs;
        }

        private final class Row {
            public String name;
            public TextWithImports value;

            public Row(String name, TextWithImports value) {
                this.name = name;
                this.value = value;
            }

            public Row() {
                this("", new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, ""));
            }
        }
    }
}

