/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.HTMLComposer;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.DescriptorProviderInspection;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.actions.SuppressActionWrapper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.jetbrains.annotations.Nullable;

public class Browser
extends JPanel {
    private static final String UNDER_CONSTRUCTION = InspectionsBundle.message((String)"inspection.tool.description.under.construction.text", (Object[])new Object[0]);
    private final List<ClickListener> myClickListeners;
    private RefEntity myCurrentEntity;
    private JEditorPane myHTMLViewer;
    private final InspectionResultsView myView;
    private final HyperlinkListener myHyperLinkListener;
    private CommonProblemDescriptor myCurrentDescriptor;

    public void dispose() {
        this.removeAll();
        if (this.myHTMLViewer != null) {
            this.myHTMLViewer.removeHyperlinkListener(this.myHyperLinkListener);
            this.myHTMLViewer = null;
        }
        this.myClickListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showPageFromHistory(RefEntity newEntity) {
        InspectionTool tool = this.getTool(newEntity);
        try {
            if (tool instanceof DescriptorProviderInspection) {
                this.showEmpty();
            } else {
                try {
                    String html = this.generateHTML(newEntity, tool);
                    this.myHTMLViewer.read(new StringReader(html), null);
                    this.myHTMLViewer.setCaretPosition(0);
                }
                catch (Exception e) {
                    this.showEmpty();
                }
            }
        }
        finally {
            this.myCurrentEntity = newEntity;
            this.myCurrentDescriptor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPageFor(RefEntity refEntity, CommonProblemDescriptor descriptor) {
        try {
            String html = this.generateHTML(refEntity, descriptor);
            this.myHTMLViewer.read(new StringReader(html), null);
            this.myHTMLViewer.setCaretPosition(0);
        }
        catch (Exception e) {
            this.showEmpty();
        }
        finally {
            this.myCurrentEntity = refEntity;
            this.myCurrentDescriptor = descriptor;
        }
    }

    public void showPageFor(RefEntity newEntity) {
        if (newEntity == null) {
            this.showEmpty();
            return;
        }
        this.showPageFromHistory(newEntity.getRefManager().getRefinedElement(newEntity));
    }

    public Browser(InspectionResultsView view) {
        super(new BorderLayout());
        this.myView = view;
        this.myClickListeners = new ArrayList<ClickListener>();
        this.myCurrentEntity = null;
        this.myCurrentDescriptor = null;
        this.myHTMLViewer = new JEditorPane("text/html", InspectionsBundle.message((String)"inspection.offline.view.empty.browser.text", (Object[])new Object[0]));
        this.myHTMLViewer.setEditable(false);
        this.myHyperLinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    JEditorPane pane = (JEditorPane)e.getSource();
                    if (e instanceof HTMLFrameHyperlinkEvent) {
                        HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                        HTMLDocument doc = (HTMLDocument)pane.getDocument();
                        doc.processHTMLFrameHyperlinkEvent(evt);
                    } else {
                        try {
                            URL url = e.getURL();
                            String ref = url.getRef();
                            if (ref.startsWith("pos:")) {
                                int delimeterPos = ref.indexOf(58, "pos:".length() + 1);
                                String startPosition = ref.substring("pos:".length(), delimeterPos);
                                String endPosition = ref.substring(delimeterPos + 1);
                                Integer textStartOffset = new Integer(startPosition);
                                Integer textEndOffset = new Integer(endPosition);
                                String fileURL = url.toExternalForm();
                                fileURL = fileURL.substring(0, fileURL.indexOf(35));
                                VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(fileURL);
                                if (vFile != null) {
                                    Browser.this.fireClickEvent(vFile, textStartOffset, textEndOffset);
                                }
                            } else if (ref.startsWith("descr:")) {
                                if (Browser.this.myCurrentDescriptor instanceof ProblemDescriptor) {
                                    PsiElement psiElement = ((ProblemDescriptor)Browser.this.myCurrentDescriptor).getPsiElement();
                                    if (psiElement == null) {
                                        return;
                                    }
                                    VirtualFile vFile = psiElement.getContainingFile().getVirtualFile();
                                    if (vFile != null) {
                                        TextRange range = ((ProblemDescriptorImpl)Browser.this.myCurrentDescriptor).getTextRange();
                                        Browser.this.fireClickEvent(vFile, range.getStartOffset(), range.getEndOffset());
                                    }
                                }
                            } else if (ref.startsWith("invoke:")) {
                                int actionNumber = Integer.parseInt(ref.substring("invoke:".length()));
                                Browser.this.getTool().getQuickFixes((RefEntity[])new RefElement[]{(RefElement)Browser.this.myCurrentEntity})[actionNumber].doApplyFix(new RefElement[]{(RefElement)Browser.this.myCurrentEntity}, Browser.this.myView);
                            } else if (ref.startsWith("invokelocal:")) {
                                int actionNumber = Integer.parseInt(ref.substring("invokelocal:".length()));
                                if (actionNumber > -1) {
                                    Browser.this.invokeLocalFix(actionNumber);
                                }
                            } else if (ref.startsWith("suppress:")) {
                                int actionNumber;
                                SuppressActionWrapper.SuppressTreeAction[] suppressTreeActions = new SuppressActionWrapper(Browser.this.myView.getProject(), Browser.this.getTool(), Browser.this.myView.getTree().getSelectionPaths()).getChildren(null);
                                ArrayList<SuppressActionWrapper.SuppressTreeAction> activeActions = new ArrayList<SuppressActionWrapper.SuppressTreeAction>();
                                for (SuppressActionWrapper.SuppressTreeAction suppressTreeAction : suppressTreeActions) {
                                    if (!suppressTreeAction.isAvailable()) continue;
                                    activeActions.add(suppressTreeAction);
                                }
                                if (!activeActions.isEmpty() && (actionNumber = Integer.parseInt(ref.substring("suppress:".length()))) > -1 && activeActions.size() > actionNumber) {
                                    ((AnAction)activeActions.get(actionNumber)).actionPerformed(null);
                                }
                            } else {
                                int offset = Integer.parseInt(ref);
                                String fileURL = url.toExternalForm();
                                fileURL = fileURL.substring(0, fileURL.indexOf(35));
                                VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(fileURL);
                                if (vFile == null) {
                                    vFile = VfsUtil.findFileByURL((URL)url);
                                }
                                if (vFile != null) {
                                    Browser.this.fireClickEvent(vFile, offset, offset);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        this.myHTMLViewer.addHyperlinkListener(this.myHyperLinkListener);
        this.add((Component)new JScrollPane(this.myHTMLViewer), "Center");
    }

    public void addClickListener(ClickListener listener) {
        this.myClickListeners.add(listener);
    }

    private void fireClickEvent(VirtualFile file, int startPosition, int endPosition) {
        ClickEvent e = new ClickEvent(file, startPosition, endPosition);
        for (ClickListener listener : this.myClickListeners) {
            listener.referenceClicked(e);
        }
    }

    private String generateHTML(final RefEntity refEntity, final InspectionTool tool) {
        final StringBuffer buf = new StringBuffer();
        if (refEntity instanceof RefElement) {
            Runnable action = new Runnable(){

                @Override
                public void run() {
                    tool.getComposer().compose(buf, refEntity);
                }
            };
            ApplicationManager.getApplication().runReadAction(action);
        } else {
            tool.getComposer().compose(buf, refEntity);
        }
        Browser.uppercaseFirstLetter(buf);
        if (refEntity instanceof RefElement) {
            this.appendSuppressSection(buf);
        }
        Browser.insertHeaderFooter(buf);
        return buf.toString();
    }

    private static void insertHeaderFooter(StringBuffer buf) {
        buf.insert(0, "<HTML><BODY><font style=\"font-family:verdana;\" size = \"3\">");
        buf.append("</font></BODY></HTML>");
    }

    private String generateHTML(final RefEntity refEntity, final CommonProblemDescriptor descriptor) {
        final StringBuffer buf = new StringBuffer();
        Runnable action = new Runnable(){

            @Override
            public void run() {
                InspectionTool tool = Browser.this.getTool(refEntity);
                tool.getComposer().compose(buf, refEntity, descriptor);
            }
        };
        ApplicationManager.getApplication().runReadAction(action);
        Browser.uppercaseFirstLetter(buf);
        if (refEntity instanceof RefElement) {
            this.appendSuppressSection(buf);
        }
        Browser.insertHeaderFooter(buf);
        return buf.toString();
    }

    private InspectionTool getTool(RefEntity refEntity) {
        InspectionTool tool = this.getTool();
        assert (tool != null);
        GlobalInspectionContextImpl manager = tool.getContext();
        if (refEntity instanceof RefElement) {
            PsiElement element = ((RefElement)refEntity).getElement();
            if (element == null) {
                return tool;
            }
            tool = InspectionProjectProfileManager.getInstance(manager.getProject()).getProfileWrapper().getInspectionTool(tool.getShortName(), element);
        }
        return tool;
    }

    private void appendSuppressSection(StringBuffer buf) {
        SuppressActionWrapper.SuppressTreeAction[] suppressActions;
        HighlightDisplayKey key;
        InspectionTool tool = this.getTool();
        if (tool != null && (key = HighlightDisplayKey.find((String)tool.getShortName())) != null && (suppressActions = new SuppressActionWrapper(this.myView.getProject(), tool, this.myView.getTree().getSelectionPaths()).getChildren(null)).length > 0) {
            ArrayList<SuppressActionWrapper.SuppressTreeAction> activeSuppressActions = new ArrayList<SuppressActionWrapper.SuppressTreeAction>();
            for (SuppressActionWrapper.SuppressTreeAction suppressAction : suppressActions) {
                if (!suppressAction.isAvailable()) continue;
                activeSuppressActions.add(suppressAction);
            }
            if (!activeSuppressActions.isEmpty()) {
                int idx = 0;
                String font = "<font style=\"font-family:verdana;\" size = \"3\">";
                buf.append(font);
                String br = "<br>";
                buf.append("<br>").append("<br>");
                HTMLComposerImpl.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.export.results.suppress", (Object[])new Object[0]));
                for (AnAction anAction : activeSuppressActions) {
                    buf.append("<br>");
                    HTMLComposer.appendAfterHeaderIndention((StringBuffer)buf);
                    String href = "<a HREF=\"file://bred.txt#suppress:" + idx + "\">" + anAction.getTemplatePresentation().getText() + "</a>";
                    buf.append(href);
                    ++idx;
                }
                String closeFont = "</font>";
                buf.append(closeFont);
            }
        }
    }

    private static void uppercaseFirstLetter(StringBuffer buf) {
        if (buf.length() > 1) {
            char[] firstLetter = new char[1];
            buf.getChars(0, 1, firstLetter, 0);
            buf.setCharAt(0, Character.toUpperCase(firstLetter[0]));
        }
    }

    public void showEmpty() {
        this.myCurrentEntity = null;
        try {
            this.myHTMLViewer.read(new StringReader("<html><body></body></html>"), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showDescription(InspectionTool tool) {
        if (tool.getShortName().length() == 0) {
            this.showEmpty();
            return;
        }
        StringBuffer page = new StringBuffer("<html>");
        page.append("<table border='0' cellspacing='0' cellpadding='0' width='100%'>");
        page.append("<tr><td colspan='2'>");
        HTMLComposer.appendHeading((StringBuffer)page, (String)InspectionsBundle.message((String)"inspection.tool.in.browser.id.title", (Object[])new Object[0]));
        page.append("</td></tr>");
        page.append("<tr><td width='37'></td><td>");
        page.append(tool.getShortName());
        page.append("</td></tr>");
        page.append("<tr height='10'></tr>");
        page.append("<tr><td colspan='2'>");
        HTMLComposer.appendHeading((StringBuffer)page, (String)InspectionsBundle.message((String)"inspection.tool.in.browser.description.title", (Object[])new Object[0]));
        page.append("</td></tr>");
        page.append("<tr><td width='37'></td><td>");
        String underConstruction = "<b>" + UNDER_CONSTRUCTION + "</b></html>";
        try {
            String description = tool.loadDescription();
            if (description == null) {
                description = underConstruction;
            }
            if (description.startsWith("<html>")) {
                page.append(description.substring(description.indexOf("<html>") + 6));
            } else {
                page.append(underConstruction);
            }
            page.append("</td></tr></table>");
            this.myHTMLViewer.setText(page.toString());
        }
        finally {
            this.myCurrentEntity = null;
        }
    }

    @Nullable
    private InspectionTool getTool() {
        if (this.myView != null) {
            return this.myView.getTree().getSelectedTool();
        }
        return null;
    }

    public void invokeLocalFix(int idx) {
        if (this.myView.getTree().getSelectionCount() != 1) {
            return;
        }
        InspectionTreeNode node = (InspectionTreeNode)this.myView.getTree().getSelectionPath().getLastPathComponent();
        if (node instanceof ProblemDescriptionNode) {
            ProblemDescriptionNode problemNode = (ProblemDescriptionNode)node;
            CommonProblemDescriptor descriptor = problemNode.getDescriptor();
            RefEntity element = problemNode.getElement();
            this.invokeFix(element, descriptor, idx);
        } else if (node instanceof RefElementNode) {
            RefElementNode elementNode = (RefElementNode)node;
            RefEntity element = elementNode.getElement();
            CommonProblemDescriptor descriptor = elementNode.getProblem();
            if (descriptor != null) {
                this.invokeFix(element, descriptor, idx);
            }
        }
    }

    private void invokeFix(final RefEntity element, final CommonProblemDescriptor descriptor, final int idx) {
        final QuickFix[] fixes = descriptor.getFixes();
        if (fixes != null && fixes.length > idx && fixes[idx] != null) {
            if (element instanceof RefElement) {
                PsiElement psiElement = ((RefElement)element).getElement();
                if (psiElement != null && psiElement.isValid()) {
                    ReadonlyStatusHandler.OperationStatus operationStatus;
                    if (!psiElement.isWritable() && (operationStatus = ReadonlyStatusHandler.getInstance((Project)this.myView.getProject()).ensureFilesWritable(new VirtualFile[]{psiElement.getContainingFile().getVirtualFile()})).hasReadonlyFiles()) {
                        return;
                    }
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            Runnable command = new Runnable(){

                                @Override
                                public void run() {
                                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(Browser.this.myView.getProject());
                                    fixes[idx].applyFix(Browser.this.myView.getProject(), descriptor);
                                }
                            };
                            CommandProcessor.getInstance().executeCommand(Browser.this.myView.getProject(), command, fixes[idx].getName(), null);
                            DescriptorProviderInspection tool = (DescriptorProviderInspection)Browser.this.myView.getTree().getSelectedTool();
                            if (tool != null) {
                                tool.ignoreProblem(element, descriptor, idx);
                            }
                            Browser.this.myView.updateView(false);
                        }
                    });
                }
            } else {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        Runnable command = new Runnable(){

                            @Override
                            public void run() {
                                CommandProcessor.getInstance().markCurrentCommandAsGlobal(Browser.this.myView.getProject());
                                fixes[idx].applyFix(Browser.this.myView.getProject(), descriptor);
                            }
                        };
                        CommandProcessor.getInstance().executeCommand(Browser.this.myView.getProject(), command, fixes[idx].getName(), null);
                        DescriptorProviderInspection tool = (DescriptorProviderInspection)Browser.this.myView.getTree().getSelectedTool();
                        if (tool != null) {
                            tool.ignoreProblem(element, descriptor, idx);
                        }
                        Browser.this.myView.updateView(false);
                    }
                });
            }
        }
    }

    public static interface ClickListener {
        public void referenceClicked(ClickEvent var1);
    }

    public static class ClickEvent {
        public static final int REF_ELEMENT = 1;
        public static final int FILE_OFFSET = 2;
        private final VirtualFile myFile;
        private final int myStartPosition;
        private final int myEndPosition;
        private final RefElement refElement;
        private final int myEventType;

        public ClickEvent(VirtualFile myFile, int myStartPosition, int myEndPosition) {
            this.myFile = myFile;
            this.myStartPosition = myStartPosition;
            this.myEndPosition = myEndPosition;
            this.myEventType = 2;
            this.refElement = null;
        }

        public int getEventType() {
            return this.myEventType;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public int getStartOffset() {
            return this.myStartPosition;
        }

        public int getEndOffset() {
            return this.myEndPosition;
        }

        public RefElement getClickedElement() {
            return this.refElement;
        }
    }
}

