/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFix;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.BaseLocalInspectionTool;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.javaDoc.JavaDocLocalInspection;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.FQNameCellRenderer;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.javadoc.JavadocManager;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocReferenceInspection
extends BaseLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "JavadocReference";
    public static final String DISPLAY_NAME = InspectionsBundle.message((String)"inspection.javadoc.ref.display.name", (Object[])new Object[0]);

    private static ProblemDescriptor createDescriptor(@NotNull PsiElement element, String template, InspectionManager manager, boolean onTheFly) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection.createDescriptor must not be null");
        }
        return manager.createProblemDescriptor(element, template, onTheFly, (LocalQuickFix[])null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
    }

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiMethod == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection.checkMethod must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection.checkMethod must not be null");
        }
        return this.checkMember((PsiDocCommentOwner)psiMethod, manager, isOnTheFly);
    }

    @Nullable
    public ProblemDescriptor[] checkField(@NotNull PsiField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection.checkField must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection.checkField must not be null");
        }
        return this.checkMember((PsiDocCommentOwner)field, manager, isOnTheFly);
    }

    @Nullable
    private ProblemDescriptor[] checkMember(PsiDocCommentOwner docCommentOwner, InspectionManager manager, boolean isOnTheFly) {
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        PsiDocComment docComment = docCommentOwner.getDocComment();
        if (docComment == null) {
            return null;
        }
        HashSet<PsiJavaCodeReferenceElement> references = new HashSet<PsiJavaCodeReferenceElement>();
        docComment.accept(this.getVisitor(references, (PsiElement)docCommentOwner, problems, manager, isOnTheFly));
        for (PsiJavaCodeReferenceElement reference : references) {
            List<PsiClass> classesToImport = new ImportClassFix(reference).getClassesToImport();
            problems.add(manager.createProblemDescriptor((PsiElement)reference, JavaDocReferenceInspection.cannotResolveSymbolMessage("<code>" + reference.getText() + "</code>"), (LocalQuickFix)(!isOnTheFly || classesToImport.isEmpty() ? null : new AddImportFix(classesToImport)), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, isOnTheFly));
        }
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection.checkClass must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection.checkClass must not be null");
        }
        return this.checkMember((PsiDocCommentOwner)aClass, manager, isOnTheFly);
    }

    private PsiElementVisitor getVisitor(final Set<PsiJavaCodeReferenceElement> references, final PsiElement context, final ArrayList<ProblemDescriptor> problems, final InspectionManager manager, final boolean onTheFly) {
        return new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitElement((PsiElement)expression);
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                JavaResolveResult result = reference.advancedResolve(false);
                if (result.getElement() == null && !result.isPackagePrefixPackageReference()) {
                    references.add(reference);
                }
            }

            public void visitDocTag(PsiDocTag tag) {
                super.visitDocTag(tag);
                JavadocManager javadocManager = JavaPsiFacade.getInstance((Project)tag.getProject()).getJavadocManager();
                JavadocTagInfo info = javadocManager.getTagInfo(tag.getName());
                if (info == null || !info.isInline()) {
                    JavaDocReferenceInspection.visitRefInDocTag(tag, javadocManager, context, problems, manager, onTheFly);
                }
            }

            public void visitInlineDocTag(PsiInlineDocTag tag) {
                super.visitInlineDocTag(tag);
                JavadocManager javadocManager = JavaPsiFacade.getInstance((Project)tag.getProject()).getJavadocManager();
                JavaDocReferenceInspection.visitRefInDocTag((PsiDocTag)tag, javadocManager, context, problems, manager, onTheFly);
            }

            public void visitElement(PsiElement element) {
                PsiElement[] children;
                for (PsiElement child : children = element.getChildren()) {
                    if (child instanceof PsiDocCommentOwner) continue;
                    child.accept((PsiElementVisitor)this);
                }
            }
        };
    }

    public static void visitRefInDocTag(PsiDocTag tag, JavadocManager manager, PsiElement context, ArrayList<ProblemDescriptor> problems, InspectionManager inspectionManager, boolean onTheFly) {
        PsiDocTagValue valueElement;
        int textOffset;
        PsiElement element;
        PsiReference reference;
        String message;
        String tagName = tag.getName();
        PsiDocTagValue value = tag.getValueElement();
        if (value == null) {
            return;
        }
        JavadocTagInfo info = manager.getTagInfo(tagName);
        if (info != null && !info.isValidInContext(context)) {
            return;
        }
        String string = message = info == null || !info.isInline() ? null : info.checkTagValue(value);
        if (message != null) {
            problems.add(JavaDocReferenceInspection.createDescriptor((PsiElement)value, message, inspectionManager, onTheFly));
        }
        if ((reference = value.getReference()) != null && (element = reference.resolve()) == null && (textOffset = value.getTextOffset()) != value.getTextRange().getEndOffset() && (valueElement = tag.getValueElement()) != null) {
            PsiDocCommentOwner commentOwner;
            CharSequence paramName = value.getContainingFile().getViewProvider().getContents().subSequence(textOffset, value.getTextRange().getEndOffset());
            String params = "<code>" + paramName + "</code>";
            ArrayList<Object> fixes = new ArrayList<Object>();
            if (onTheFly && "param".equals(tagName) && (commentOwner = (PsiDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)tag, PsiDocCommentOwner.class)) instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)commentOwner;
                PsiParameter[] parameters = method.getParameterList().getParameters();
                PsiDocTag[] tags = tag.getContainingComment().getTags();
                HashSet<String> unboundParams = new HashSet<String>();
                for (PsiParameter parameter : parameters) {
                    if (JavaDocLocalInspection.isFound(tags, (PsiElement)parameter)) continue;
                    unboundParams.add(parameter.getName());
                }
                if (!unboundParams.isEmpty()) {
                    fixes.add(new RenameReferenceQuickFix(unboundParams));
                }
            }
            fixes.add(new RemoveTagFix(tagName, paramName, tag));
            problems.add(inspectionManager.createProblemDescriptor((PsiElement)valueElement, JavaDocReferenceInspection.cannotResolveSymbolMessage(params), onTheFly, fixes.toArray(new LocalQuickFix[fixes.size()]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL));
        }
    }

    private static String cannotResolveSymbolMessage(String params) {
        return InspectionsBundle.message((String)"inspection.javadoc.problem.cannot.resolve", (Object[])new Object[]{params});
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection.getGroupDisplayName must not return null");
        }
        return "";
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection.getShortName must not return null");
        }
        return SHORT_NAME;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    private static class RemoveTagFix
    implements LocalQuickFix {
        private final String myTagName;
        private final CharSequence myParamName;
        private final PsiDocTag myTag;

        public RemoveTagFix(String tagName, CharSequence paramName, PsiDocTag tag) {
            this.myTagName = tagName;
            this.myParamName = paramName;
            this.myTag = tag;
        }

        @NotNull
        public String getName() {
            String string = "Remove @" + this.myTagName + " " + this.myParamName;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$RemoveTagFix.getName must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$RemoveTagFix.getFamilyName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$RemoveTagFix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$RemoveTagFix.applyFix must not be null");
            }
            this.myTag.delete();
        }
    }

    private static class RenameReferenceQuickFix
    implements LocalQuickFix {
        private final Set<String> myUnboundParams;

        public RenameReferenceQuickFix(Set<String> unboundParams) {
            this.myUnboundParams = unboundParams;
        }

        @NotNull
        public String getName() {
            if ("Change to ..." == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$RenameReferenceQuickFix.getName must not return null");
            }
            return "Change to ...";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$RenameReferenceQuickFix.getFamilyName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$RenameReferenceQuickFix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$RenameReferenceQuickFix.applyFix must not be null");
            }
            Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext());
            assert (editor != null);
            TextRange textRange = ((ProblemDescriptorImpl)descriptor).getTextRange();
            editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
            String word = editor.getSelectionModel().getSelectedText();
            if (word == null || StringUtil.isEmptyOrSpaces((String)word)) {
                return;
            }
            ArrayList<LookupElementBuilder> items = new ArrayList<LookupElementBuilder>();
            for (String variant : this.myUnboundParams) {
                items.add(LookupElementBuilder.create((String)variant));
            }
            LookupManager.getInstance(project).showLookup(editor, items.toArray(new LookupElement[items.size()]));
        }
    }

    private class AddImportFix
    implements LocalQuickFix {
        private final List<PsiClass> myClassesToImport;

        public AddImportFix(List<PsiClass> classesToImport) {
            this.myClassesToImport = classesToImport;
        }

        @NotNull
        public String getName() {
            String string = QuickFixBundle.message("import.class.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$AddImportFix.getName must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("import.class.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$AddImportFix.getFamilyName must not return null");
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$AddImportFix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$AddImportFix.applyFix must not be null");
            }
            final PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiJavaCodeReferenceElement) {
                final PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)element;
                Collections.sort(this.myClassesToImport, new PsiProximityComparator(referenceElement.getElement()));
                final JList<PsiClass> list = new JList<PsiClass>(this.myClassesToImport.toArray(new PsiClass[this.myClassesToImport.size()]));
                list.setCellRenderer(new FQNameCellRenderer());
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (!element.isValid()) {
                            return;
                        }
                        final int index = list.getSelectedIndex();
                        if (index < 0) {
                            return;
                        }
                        new WriteCommandAction(project, new PsiFile[]{element.getContainingFile()}){

                            protected void run(Result result) throws Throwable {
                                PsiClass psiClass = (PsiClass)AddImportFix.this.myClassesToImport.get(index);
                                if (psiClass.isValid()) {
                                    PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                                    referenceElement.bindToElement((PsiElement)psiClass);
                                }
                            }
                        }.execute();
                    }
                };
                Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext());
                assert (editor != null);
                new PopupChooserBuilder(list).setTitle(QuickFixBundle.message("class.to.import.chooser.title", new Object[0])).setItemChoosenCallback(runnable).createPopup().showInBestPositionFor(editor);
            }
        }
    }
}

