/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTypeParameter;
import org.jetbrains.annotations.NotNull;

public class QualifiedClassNameMacro
implements Macro {
    public String getName() {
        return "qualifiedClassName";
    }

    public String getDescription() {
        return CodeInsightBundle.message((String)"macro.qualified.class.name", (Object[])new Object[0]);
    }

    public String getDefaultValue() {
        return "";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/QualifiedClassNameMacro.calculateResult must not be null");
        }
        Project project = context.getProject();
        int templateStartOffset = context.getTemplateStartOffset();
        int offset = templateStartOffset > 0 ? context.getTemplateStartOffset() - 1 : context.getTemplateStartOffset();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        for (PsiElement place = file.findElementAt(offset); place != null; place = place.getParent()) {
            if (!(place instanceof PsiClass) || place instanceof PsiAnonymousClass || place instanceof PsiTypeParameter) continue;
            PsiClass psiClass = (PsiClass)place;
            return new TextResult(psiClass.getQualifiedName());
        }
        return null;
    }

    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/QualifiedClassNameMacro.calculateQuickResult must not be null");
        }
        return null;
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/QualifiedClassNameMacro.calculateLookupItems must not be null");
        }
        return null;
    }
}

