/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl.editorActions;

import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.TextRange;

public abstract class HomeEndHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalHandler;
    boolean myIsHomeHandler;

    public HomeEndHandler(EditorActionHandler originalHandler, boolean isHomeHandler) {
        this.myOriginalHandler = originalHandler;
        this.myIsHomeHandler = isHomeHandler;
    }

    public void execute(Editor editor, DataContext dataContext) {
        TemplateState templateState = TemplateManagerImpl.getTemplateState(editor);
        if (templateState != null && !templateState.isFinished()) {
            TextRange range = templateState.getCurrentVariableRange();
            int caretOffset = editor.getCaretModel().getOffset();
            if (range != null && range.getStartOffset() <= caretOffset && caretOffset <= range.getEndOffset()) {
                int offsetToMove;
                int n = offsetToMove = this.myIsHomeHandler ? range.getStartOffset() : range.getEndOffset();
                if (offsetToMove != caretOffset) {
                    editor.getCaretModel().moveToOffset(offsetToMove);
                    editor.getSelectionModel().removeSelection();
                }
            } else {
                this.myOriginalHandler.execute(editor, dataContext);
            }
        } else {
            this.myOriginalHandler.execute(editor, dataContext);
        }
    }
}

