/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class IntentionActionWrapper
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper");
    private IntentionAction myDelegate;
    private final String[] myCategories;
    private final IntentionActionBean myExtension;

    public IntentionActionWrapper(IntentionActionBean extension, String[] categories) {
        this.myExtension = extension;
        this.myCategories = categories;
    }

    @NotNull
    public String getText() {
        String string = this.getDelegate().getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/IntentionActionWrapper.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getDelegate().getFamilyName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/IntentionActionWrapper.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/IntentionActionWrapper.isAvailable must not be null");
        }
        return this.getDelegate().isAvailable(project, editor, file);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/IntentionActionWrapper.invoke must not be null");
        }
        this.getDelegate().invoke(project, editor, file);
    }

    public boolean startInWriteAction() {
        return this.getDelegate().startInWriteAction();
    }

    public String getFullFamilyName() {
        if (this.myCategories != null) {
            return StringUtil.join((String[])this.myCategories, (String)"/") + "/" + this.getFamilyName();
        }
        return this.getFamilyName();
    }

    public synchronized IntentionAction getDelegate() {
        if (this.myDelegate == null) {
            try {
                this.myDelegate = this.myExtension.instantiate();
            }
            catch (ClassNotFoundException e) {
                LOG.error((Throwable)e);
            }
        }
        return this.myDelegate;
    }

    public String getImplementationClassName() {
        return this.myExtension.className;
    }

    public ClassLoader getImplementationClassLoader() {
        return this.myExtension.getLoaderForClass();
    }

    public String toString() {
        return "Intention: (" + this.getDelegate().getClass() + "): '" + this.getText() + "'";
    }
}

