/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.BraceHighlightingHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class BraceHighlighter
extends AbstractProjectComponent {
    private final Alarm myAlarm = new Alarm();

    public BraceHighlighter(Project project) {
        super(project);
    }

    @NotNull
    public String getComponentName() {
        if ("BraceHighlighter" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/highlighting/BraceHighlighter.getComponentName must not return null");
        }
        return "BraceHighlighter";
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                BraceHighlighter.this.doinit();
            }
        });
    }

    private void doinit() {
        EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        CaretListener myCaretListener = new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                BraceHighlighter.this.myAlarm.cancelAllRequests();
                Editor editor = e.getEditor();
                if (editor.getProject() == BraceHighlighter.this.myProject) {
                    BraceHighlighter.updateBraces(editor, BraceHighlighter.this.myAlarm);
                }
            }
        };
        eventMulticaster.addCaretListener(myCaretListener, (Disposable)this.myProject);
        final SelectionListener mySelectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent e) {
                BraceHighlighter.this.myAlarm.cancelAllRequests();
                Editor editor = e.getEditor();
                if (editor.getProject() == BraceHighlighter.this.myProject) {
                    BraceHighlighter.updateBraces(editor, BraceHighlighter.this.myAlarm);
                }
            }
        };
        eventMulticaster.addSelectionListener(mySelectionListener);
        DocumentAdapter documentListener = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                Editor[] editors;
                BraceHighlighter.this.myAlarm.cancelAllRequests();
                for (Editor editor : editors = EditorFactory.getInstance().getEditors(e.getDocument(), BraceHighlighter.this.myProject)) {
                    BraceHighlighter.updateBraces(editor, BraceHighlighter.this.myAlarm);
                }
            }
        };
        eventMulticaster.addDocumentListener((DocumentListener)documentListener, (Disposable)this.myProject);
        final FocusChangeListener myFocusChangeListener = new FocusChangeListener(){

            @Override
            public void focusLost(Editor editor) {
                BraceHighlighter.this.clearBraces(editor);
            }

            @Override
            public void focusGained(Editor editor) {
                BraceHighlighter.updateBraces(editor, BraceHighlighter.this.myAlarm);
            }
        };
        ((EditorEventMulticasterEx)eventMulticaster).addFocusChangeListner(myFocusChangeListener);
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        fileEditorManager.addFileEditorManagerListener((FileEditorManagerListener)new FileEditorManagerAdapter(){

            public void selectionChanged(FileEditorManagerEvent e) {
                BraceHighlighter.this.myAlarm.cancelAllRequests();
            }
        }, (Disposable)this.myProject);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
                ((EditorEventMulticasterEx)eventMulticaster).removeFocusChangeListner(myFocusChangeListener);
                eventMulticaster.removeSelectionListener(mySelectionListener);
            }
        });
    }

    static void updateBraces(@NotNull Editor editor, @NotNull Alarm alarm) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/BraceHighlighter.updateBraces must not be null");
        }
        if (alarm == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/highlighting/BraceHighlighter.updateBraces must not be null");
        }
        Document document = editor.getDocument();
        if (document instanceof DocumentEx && ((DocumentEx)document).isInBulkUpdate()) {
            return;
        }
        BraceHighlightingHandler.lookForInjectedAndMatchBracesInOtherThread(editor, alarm, new Processor<BraceHighlightingHandler>(){

            public boolean process(BraceHighlightingHandler handler) {
                handler.updateBraces();
                return false;
            }
        });
    }

    private void clearBraces(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/BraceHighlighter.clearBraces must not be null");
        }
        BraceHighlightingHandler.lookForInjectedAndMatchBracesInOtherThread(editor, this.myAlarm, new Processor<BraceHighlightingHandler>(){

            public boolean process(BraceHighlightingHandler handler) {
                handler.clearBraceHighlighters();
                return false;
            }
        });
    }
}

