/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ExtendedTagInsertHandler
extends XmlTagInsertHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.ExtendedTagInsertHandler");
    protected final String myElementName;
    @Nullable
    protected final String myNamespace;
    @Nullable
    protected final String myNamespacePrefix;

    public ExtendedTagInsertHandler(String elementName, @Nullable String namespace, @Nullable String namespacePrefix) {
        this.myElementName = elementName;
        this.myNamespace = namespace;
        this.myNamespacePrefix = namespacePrefix;
    }

    @Override
    public void handleInsert(final InsertionContext context, final LookupElement item) {
        XmlFile contextfile = (XmlFile)context.getFile();
        XmlExtension extension = XmlExtension.getExtension((PsiFile)contextfile);
        final XmlFile file = extension.getContainingFile((PsiElement)contextfile);
        final Project project = context.getProject();
        assert (file != null);
        PsiElement psiElement = file.findElementAt(context.getStartOffset());
        assert (psiElement != null);
        if (this.isNamespaceBound(psiElement)) {
            this.doDefault(context, item);
            return;
        }
        final Editor editor = context.getEditor();
        final Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        int caretOffset = editor.getCaretModel().getOffset();
        final RangeMarker caretMarker = document.createRangeMarker(caretOffset, caretOffset);
        caretMarker.setGreedyToRight(true);
        XmlExtension.Runner<String, IncorrectOperationException> runAfter = new XmlExtension.Runner<String, IncorrectOperationException>(){

            @Override
            public void run(String namespacePrefix) {
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                PsiElement element = file.findElementAt(context.getStartOffset());
                if (element != null) {
                    ExtendedTagInsertHandler.this.qualifyWithPrefix(namespacePrefix, element, document);
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                }
                editor.getCaretModel().moveToOffset(caretMarker.getEndOffset());
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                ExtendedTagInsertHandler.this.doDefault(context, item);
            }
        };
        try {
            String prefixByNamespace = ExtendedTagInsertHandler.getPrefixByNamespace(file, this.myNamespace);
            if (this.myNamespacePrefix != null || StringUtil.isEmpty((String)prefixByNamespace)) {
                String nsPrefix = this.myNamespacePrefix == null ? ExtendedTagInsertHandler.suggestPrefix(file, this.myNamespace) : this.myNamespacePrefix;
                extension.insertNamespaceDeclaration(file, editor, Collections.singleton(this.myNamespace), nsPrefix, runAfter);
                FeatureUsageTracker.getInstance().triggerFeatureUsed("tag.name.completion");
            } else {
                runAfter.run(prefixByNamespace);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void doDefault(InsertionContext context, LookupElement item) {
        ExtendedTagInsertHandler.super.handleInsert(context, item);
    }

    protected boolean isNamespaceBound(PsiElement psiElement) {
        XmlTag tag = (XmlTag)psiElement.getParent();
        XmlElementDescriptor tagDescriptor = tag.getDescriptor();
        String tagNamespace = tag.getNamespace();
        return tagDescriptor != null && !(tagDescriptor instanceof AnyXmlElementDescriptor) && this.myNamespace.equals(tagNamespace);
    }

    @Nullable
    public static String getPrefixByNamespace(XmlFile file, String namespace) {
        XmlDocument document = file.getDocument();
        assert (document != null);
        XmlTag tag = document.getRootTag();
        return tag == null ? null : tag.getPrefixByNamespace(namespace);
    }

    @Nullable
    public static String suggestPrefix(XmlFile file, @Nullable String namespace) {
        if (namespace == null) {
            return null;
        }
        for (XmlSchemaProvider provider : XmlSchemaProvider.getAvailableProviders((XmlFile)file)) {
            String prefix = provider.getDefaultPrefix(namespace, file);
            if (prefix == null) continue;
            return prefix;
        }
        return null;
    }

    protected Set<String> getNamespaces(XmlFile file) {
        return XmlExtension.getExtension((PsiFile)file).getNamespacesByTagName(this.myElementName, file);
    }

    protected void qualifyWithPrefix(String namespacePrefix, PsiElement element, Document document) {
        ExtendedTagInsertHandler.qualifyWithPrefix(namespacePrefix, element);
    }

    public static void qualifyWithPrefix(String namespacePrefix, PsiElement element) {
        String prefix;
        PsiElement tag = element.getParent();
        if (tag instanceof XmlTag && !(prefix = ((XmlTag)tag).getNamespacePrefix()).equals(namespacePrefix)) {
            String name = namespacePrefix + ":" + ((XmlTag)tag).getLocalName();
            try {
                ((XmlTag)tag).setName(name);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

