/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.OptionId;
import com.intellij.application.options.OptionsApplicabilityFilter;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CodeCompletionPanel {
    JPanel myPanel;
    private JCheckBox myCbAutocompletion;
    private JTextField myAutocompletionDelayField;
    private JCheckBox myCbXmlAutocompletion;
    private JTextField myXmlAutocompletionDelayField;
    private JCheckBox myCbJavadocAutocompletion;
    private JTextField myFldJavadocAutocompletionDelayField;
    private JCheckBox myCbAutopopupJavaDoc;
    private JTextField myAutopopupJavaDocField;
    private JCheckBox myCbAutocompleteCommonPrefix;
    private JCheckBox myCbShowStaticAfterInstance;
    private JCheckBox myCbOnCodeCompletion;
    private JCheckBox myCbOnSmartTypeCompletion;
    private JCheckBox myCbOnClassNameCompletion;
    private JCheckBox myCbParameterInfoPopup;
    private JTextField myParameterInfoDelayField;
    private JCheckBox myCbShowFullParameterSignatures;
    private JComboBox myCaseSensitiveCombo;
    private static final String CASE_SENSITIVE_ALL = ApplicationBundle.message((String)"combobox.autocomplete.casesensitive.all", (Object[])new Object[0]);
    private static final String CASE_SENSITIVE_NONE = ApplicationBundle.message((String)"combobox.autocomplete.casesensitive.none", (Object[])new Object[0]);
    private static final String CASE_SENSITIVE_FIRST_LETTER = ApplicationBundle.message((String)"combobox.autocomplete.casesensitive.first.letter", (Object[])new Object[0]);
    ButtonGroup buttonGroup;

    public CodeCompletionPanel() {
        this.$$$setupUI$$$();
        this.buttonGroup = new ButtonGroup();
        this.myCaseSensitiveCombo.setModel(new DefaultComboBoxModel<String>(new String[]{CASE_SENSITIVE_ALL, CASE_SENSITIVE_NONE, CASE_SENSITIVE_FIRST_LETTER}));
        this.myCbAutocompletion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CodeCompletionPanel.this.myAutocompletionDelayField.setEnabled(CodeCompletionPanel.this.myCbAutocompletion.isSelected());
            }
        });
        this.myCbXmlAutocompletion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CodeCompletionPanel.this.myXmlAutocompletionDelayField.setEnabled(CodeCompletionPanel.this.myCbXmlAutocompletion.isSelected());
            }
        });
        this.myCbJavadocAutocompletion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeCompletionPanel.this.myFldJavadocAutocompletionDelayField.setEnabled(CodeCompletionPanel.this.myCbJavadocAutocompletion.isSelected());
            }
        });
        this.myCbAutopopupJavaDoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CodeCompletionPanel.this.myAutopopupJavaDocField.setEnabled(CodeCompletionPanel.this.myCbAutopopupJavaDoc.isSelected());
            }
        });
        this.myCbParameterInfoPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CodeCompletionPanel.this.myParameterInfoDelayField.setEnabled(CodeCompletionPanel.this.myCbParameterInfoPopup.isSelected());
            }
        });
        CodeCompletionPanel.hideOption(this.myCbShowStaticAfterInstance, OptionId.COMPLETION_SHOW_STATIC_AFTER_IMPORT);
        CodeCompletionPanel.hideOption(this.myCbXmlAutocompletion, OptionId.COMPLETION_AUTO_POPUP_XML);
        CodeCompletionPanel.hideOption(this.myXmlAutocompletionDelayField, OptionId.COMPLETION_AUTO_POPUP_XML);
        CodeCompletionPanel.hideOption(this.myCbJavadocAutocompletion, OptionId.COMPLETION_AUTO_POPUP_DOC_COMMENT);
        CodeCompletionPanel.hideOption(this.myFldJavadocAutocompletionDelayField, OptionId.COMPLETION_AUTO_POPUP_DOC_COMMENT);
        CodeCompletionPanel.hideOption(this.myCbOnSmartTypeCompletion, OptionId.COMPLETION_SMART_TYPE);
        CodeCompletionPanel.hideOption(this.myCbOnClassNameCompletion, OptionId.COMPLETION_CLASS_NAME);
        this.reset();
    }

    private static void hideOption(JComponent component, OptionId id) {
        component.setVisible(OptionsApplicabilityFilter.isApplicable(id));
    }

    public void reset() {
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        String value = "";
        switch (codeInsightSettings.COMPLETION_CASE_SENSITIVE) {
            case 1: {
                value = CASE_SENSITIVE_ALL;
                break;
            }
            case 2: {
                value = CASE_SENSITIVE_NONE;
                break;
            }
            default: {
                value = CASE_SENSITIVE_FIRST_LETTER;
            }
        }
        this.myCaseSensitiveCombo.setSelectedItem(value);
        this.myCbOnCodeCompletion.setSelected(codeInsightSettings.AUTOCOMPLETE_ON_CODE_COMPLETION);
        this.myCbOnSmartTypeCompletion.setSelected(codeInsightSettings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION);
        this.myCbOnClassNameCompletion.setSelected(codeInsightSettings.AUTOCOMPLETE_ON_CLASS_NAME_COMPLETION);
        this.myCbAutocompleteCommonPrefix.setSelected(codeInsightSettings.AUTOCOMPLETE_COMMON_PREFIX);
        this.myCbShowStaticAfterInstance.setSelected(codeInsightSettings.SHOW_STATIC_AFTER_INSTANCE);
        this.myCbAutocompletion.setSelected(codeInsightSettings.AUTO_POPUP_MEMBER_LOOKUP);
        this.myAutocompletionDelayField.setEnabled(codeInsightSettings.AUTO_POPUP_MEMBER_LOOKUP);
        this.myAutocompletionDelayField.setText(String.valueOf(codeInsightSettings.MEMBER_LOOKUP_DELAY));
        this.myCbXmlAutocompletion.setSelected(codeInsightSettings.AUTO_POPUP_XML_LOOKUP);
        this.myXmlAutocompletionDelayField.setEnabled(codeInsightSettings.AUTO_POPUP_XML_LOOKUP);
        this.myXmlAutocompletionDelayField.setText(String.valueOf(codeInsightSettings.XML_LOOKUP_DELAY));
        this.myCbJavadocAutocompletion.setSelected(codeInsightSettings.AUTO_POPUP_JAVADOC_LOOKUP);
        this.myFldJavadocAutocompletionDelayField.setEnabled(codeInsightSettings.AUTO_POPUP_JAVADOC_LOOKUP);
        this.myFldJavadocAutocompletionDelayField.setText(String.valueOf(codeInsightSettings.JAVADOC_LOOKUP_DELAY));
        this.myCbAutopopupJavaDoc.setSelected(codeInsightSettings.AUTO_POPUP_JAVADOC_INFO);
        this.myAutopopupJavaDocField.setEnabled(codeInsightSettings.AUTO_POPUP_JAVADOC_INFO);
        this.myAutopopupJavaDocField.setText(String.valueOf(codeInsightSettings.JAVADOC_INFO_DELAY));
        this.myCbParameterInfoPopup.setSelected(codeInsightSettings.AUTO_POPUP_PARAMETER_INFO);
        this.myParameterInfoDelayField.setEnabled(codeInsightSettings.AUTO_POPUP_PARAMETER_INFO);
        this.myParameterInfoDelayField.setText(String.valueOf(codeInsightSettings.PARAMETER_INFO_DELAY));
        this.myCbShowFullParameterSignatures.setSelected(codeInsightSettings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO);
        this.myCbAutocompletion.setSelected(codeInsightSettings.AUTO_POPUP_MEMBER_LOOKUP);
    }

    public void apply() {
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        codeInsightSettings.COMPLETION_CASE_SENSITIVE = this.getCaseSensitiveValue();
        codeInsightSettings.AUTOCOMPLETE_ON_CODE_COMPLETION = this.myCbOnCodeCompletion.isSelected();
        codeInsightSettings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION = this.myCbOnSmartTypeCompletion.isSelected();
        codeInsightSettings.AUTOCOMPLETE_ON_CLASS_NAME_COMPLETION = this.myCbOnClassNameCompletion.isSelected();
        codeInsightSettings.AUTOCOMPLETE_COMMON_PREFIX = this.myCbAutocompleteCommonPrefix.isSelected();
        codeInsightSettings.SHOW_STATIC_AFTER_INSTANCE = this.myCbShowStaticAfterInstance.isSelected();
        codeInsightSettings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO = this.myCbShowFullParameterSignatures.isSelected();
        codeInsightSettings.AUTO_POPUP_PARAMETER_INFO = this.myCbParameterInfoPopup.isSelected();
        codeInsightSettings.AUTO_POPUP_MEMBER_LOOKUP = this.myCbAutocompletion.isSelected();
        codeInsightSettings.AUTO_POPUP_XML_LOOKUP = this.myCbXmlAutocompletion.isSelected();
        codeInsightSettings.AUTO_POPUP_JAVADOC_LOOKUP = this.myCbJavadocAutocompletion.isSelected();
        codeInsightSettings.AUTO_POPUP_JAVADOC_INFO = this.myCbAutopopupJavaDoc.isSelected();
        codeInsightSettings.MEMBER_LOOKUP_DELAY = CodeCompletionPanel.getIntegerValue(this.myAutocompletionDelayField.getText(), 0);
        codeInsightSettings.XML_LOOKUP_DELAY = CodeCompletionPanel.getIntegerValue(this.myXmlAutocompletionDelayField.getText(), 0);
        codeInsightSettings.JAVADOC_LOOKUP_DELAY = CodeCompletionPanel.getIntegerValue(this.myFldJavadocAutocompletionDelayField.getText(), 0);
        codeInsightSettings.PARAMETER_INFO_DELAY = CodeCompletionPanel.getIntegerValue(this.myParameterInfoDelayField.getText(), 0);
        codeInsightSettings.JAVADOC_INFO_DELAY = CodeCompletionPanel.getIntegerValue(this.myAutopopupJavaDocField.getText(), 0);
        Project project = (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myPanel));
        if (project != null) {
            DaemonCodeAnalyzer.getInstance((Project)project).settingsChanged();
        }
    }

    public boolean isModified() {
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        boolean isModified = false;
        isModified |= this.getCaseSensitiveValue() != codeInsightSettings.COMPLETION_CASE_SENSITIVE;
        isModified |= CodeCompletionPanel.isModified(this.myCbOnCodeCompletion, codeInsightSettings.AUTOCOMPLETE_ON_CODE_COMPLETION);
        isModified |= CodeCompletionPanel.isModified(this.myCbOnSmartTypeCompletion, codeInsightSettings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION);
        isModified |= CodeCompletionPanel.isModified(this.myCbOnClassNameCompletion, codeInsightSettings.AUTOCOMPLETE_ON_CLASS_NAME_COMPLETION);
        isModified |= CodeCompletionPanel.isModified(this.myCbAutocompleteCommonPrefix, codeInsightSettings.AUTOCOMPLETE_COMMON_PREFIX);
        isModified |= CodeCompletionPanel.isModified(this.myCbShowStaticAfterInstance, codeInsightSettings.SHOW_STATIC_AFTER_INSTANCE);
        isModified |= CodeCompletionPanel.isModified(this.myCbShowFullParameterSignatures, codeInsightSettings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO);
        isModified |= CodeCompletionPanel.isModified(this.myCbParameterInfoPopup, codeInsightSettings.AUTO_POPUP_PARAMETER_INFO);
        isModified |= CodeCompletionPanel.isModified(this.myCbAutocompletion, codeInsightSettings.AUTO_POPUP_MEMBER_LOOKUP);
        isModified |= CodeCompletionPanel.isModified(this.myCbXmlAutocompletion, codeInsightSettings.AUTO_POPUP_XML_LOOKUP);
        isModified |= CodeCompletionPanel.isModified(this.myCbJavadocAutocompletion, codeInsightSettings.AUTO_POPUP_JAVADOC_LOOKUP);
        isModified |= CodeCompletionPanel.isModified(this.myCbAutopopupJavaDoc, codeInsightSettings.AUTO_POPUP_JAVADOC_INFO);
        isModified |= CodeCompletionPanel.isModified(this.myAutocompletionDelayField, codeInsightSettings.MEMBER_LOOKUP_DELAY, 0);
        isModified |= CodeCompletionPanel.isModified(this.myXmlAutocompletionDelayField, codeInsightSettings.XML_LOOKUP_DELAY, 0);
        isModified |= CodeCompletionPanel.isModified(this.myFldJavadocAutocompletionDelayField, codeInsightSettings.JAVADOC_LOOKUP_DELAY, 0);
        isModified |= CodeCompletionPanel.isModified(this.myParameterInfoDelayField, codeInsightSettings.PARAMETER_INFO_DELAY, 0);
        return isModified |= CodeCompletionPanel.isModified(this.myAutopopupJavaDocField, codeInsightSettings.JAVADOC_INFO_DELAY, 0);
    }

    private static boolean isModified(JCheckBox checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    private static boolean isModified(JTextField textField, int value, int defaultValue) {
        return CodeCompletionPanel.getIntegerValue(textField.getText(), defaultValue) != value;
    }

    private static int getIntegerValue(String s, int defaultValue) {
        int value = defaultValue;
        try {
            value = Integer.parseInt(s);
            if (value < 0) {
                return defaultValue;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    private int getCaseSensitiveValue() {
        Object value = this.myCaseSensitiveCombo.getSelectedItem();
        if (CASE_SENSITIVE_ALL.equals(value)) {
            return 1;
        }
        if (CASE_SENSITIVE_NONE.equals(value)) {
            return 2;
        }
        return 3;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField2;
        JCheckBox jCheckBox3;
        JTextField jTextField3;
        JTextField jTextField4;
        JTextField jTextField5;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JComboBox jComboBox;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        JCheckBox jCheckBox11;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(12, 2, new Insets(7, 7, 7, 7), -1, 1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 2, 1, 1, 1, 3, 0, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.code.completion"), 0, 0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("combobox.case.sensitive.completion"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCbOnCodeCompletion = jCheckBox11 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox11, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.autocomplete.basic"));
        jCheckBox11.setMargin(new Insets(2, 15, 2, 2));
        jPanel2.add((Component)jCheckBox11, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbOnSmartTypeCompletion = jCheckBox10 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox10, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.autocomplete.smart.type"));
        jCheckBox10.setMargin(new Insets(2, 15, 2, 2));
        jPanel2.add((Component)jCheckBox10, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbOnClassNameCompletion = jCheckBox9 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox9, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.autocomplete.class.name"));
        jCheckBox9.setMargin(new Insets(2, 15, 2, 2));
        jPanel2.add((Component)jCheckBox9, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbAutocompleteCommonPrefix = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.autocomplete.common.prefix"));
        jPanel2.add((Component)jCheckBox8, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbShowStaticAfterInstance = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.static.members.after.instance.qualifier"));
        jCheckBox7.setMargin(new Insets(2, 2, 12, 2));
        jPanel2.add((Component)jCheckBox7, new GridConstraints(6, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCaseSensitiveCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, new Dimension(100, -1), null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.autocomplete.when.only.one.choice"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.complete.autopopup"));
        jPanel2.add((Component)jLabel3, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCbAutocompletion = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.after.dot.ms"));
        jCheckBox6.setMargin(new Insets(2, 15, 2, 2));
        jPanel2.add((Component)jCheckBox6, new GridConstraints(8, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbXmlAutocompletion = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.after.gt.in.xml.ms"));
        jCheckBox5.setMargin(new Insets(2, 15, 2, 2));
        jPanel2.add((Component)jCheckBox5, new GridConstraints(9, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbJavadocAutocompletion = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.after.at.in.java.doc.ms"));
        jCheckBox4.setMargin(new Insets(2, 15, 10, 2));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(10, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAutocompletionDelayField = jTextField5 = new JTextField();
        jTextField5.setColumns(4);
        jTextField5.setText("1000");
        jPanel2.add((Component)jTextField5, new GridConstraints(8, 1, 1, 1, 8, 0, 6, 0, new Dimension(50, -1), null, new Dimension(50, -1)));
        this.myXmlAutocompletionDelayField = jTextField4 = new JTextField();
        jTextField4.setColumns(4);
        jTextField4.setText("0");
        jPanel2.add((Component)jTextField4, new GridConstraints(9, 1, 1, 1, 8, 0, 6, 0, new Dimension(50, -1), null, new Dimension(50, -1)));
        this.myFldJavadocAutocompletionDelayField = jTextField3 = new JTextField();
        jTextField3.setOpaque(true);
        jTextField3.setRequestFocusEnabled(true);
        jTextField3.setColumns(4);
        jTextField3.setText("1000");
        jTextField3.setMargin(new Insets(0, 0, 0, 0));
        jPanel2.add((Component)jTextField3, new GridConstraints(10, 1, 1, 1, 9, 0, 6, 0, new Dimension(50, -1), null, new Dimension(50, -1)));
        this.myCbAutopopupJavaDoc = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.autopopup.javadoc.in.ms"));
        jCheckBox3.setMargin(new Insets(2, 2, 12, 2));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(11, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAutopopupJavaDocField = jTextField2 = new JTextField();
        jTextField2.setColumns(4);
        jTextField2.setText("1000");
        jPanel2.add((Component)jTextField2, new GridConstraints(11, 1, 1, 1, 9, 0, 6, 0, new Dimension(50, -1), null, new Dimension(50, -1)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), 1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(7, 7, 0, 7), -1, 0, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 1, 3, 3, 2, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.parameter.info"), 0, 0, null, null));
        this.myCbParameterInfoPopup = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.autopopup.in.ms"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbShowFullParameterSignatures = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.full.signatures"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myParameterInfoDelayField = jTextField = new JTextField();
        jTextField.setColumns(4);
        jTextField.setText("1000");
        jPanel4.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, new Dimension(50, -1), null, new Dimension(50, -1)));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

