/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MissortedModifiersInspection
extends BaseInspection {
    public boolean m_requireAnnotationsFirst = true;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("missorted.modifiers.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/MissortedModifiersInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("missorted.modifiers.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/MissortedModifiersInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MissortedModifiersVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SortModifiersFix();
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("missorted.modifiers.require.option", new Object[0]), (InspectionProfileEntry)this, "m_requireAnnotationsFirst");
    }

    private static class ModifierComparator
    implements Comparator<String> {
        @NonNls
        private static final Map<String, Integer> s_modifierOrder = new HashMap<String, Integer>(11);

        private ModifierComparator() {
        }

        @Override
        public int compare(String modifier1, String modifier2) {
            Integer ordinal1 = s_modifierOrder.get(modifier1);
            if (ordinal1 == null) {
                return 0;
            }
            Integer ordinal2 = s_modifierOrder.get(modifier2);
            if (ordinal2 == null) {
                return 0;
            }
            return ordinal1 - ordinal2;
        }

        static {
            s_modifierOrder.put("public", 0);
            s_modifierOrder.put("protected", 1);
            s_modifierOrder.put("private", 2);
            s_modifierOrder.put("abstract", 3);
            s_modifierOrder.put("static", 4);
            s_modifierOrder.put("final", 5);
            s_modifierOrder.put("transient", 6);
            s_modifierOrder.put("volatile", 7);
            s_modifierOrder.put("synchronized", 8);
            s_modifierOrder.put("native", 9);
            s_modifierOrder.put("strictfp", 10);
        }
    }

    private class MissortedModifiersVisitor
    extends BaseInspectionVisitor {
        private final Comparator<String> modifierComparator = new ModifierComparator();

        private MissortedModifiersVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/MissortedModifiersInspection$MissortedModifiersVisitor.visitClass must not be null");
            }
            super.visitClass(aClass);
            this.checkForMissortedModifiers((PsiModifierListOwner)aClass);
        }

        public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
            if (initializer == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/MissortedModifiersInspection$MissortedModifiersVisitor.visitClassInitializer must not be null");
            }
            super.visitClassInitializer(initializer);
            this.checkForMissortedModifiers((PsiModifierListOwner)initializer);
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/MissortedModifiersInspection$MissortedModifiersVisitor.visitLocalVariable must not be null");
            }
            super.visitLocalVariable(variable);
            this.checkForMissortedModifiers((PsiModifierListOwner)variable);
        }

        public void visitParameter(@NotNull PsiParameter parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/MissortedModifiersInspection$MissortedModifiersVisitor.visitParameter must not be null");
            }
            super.visitParameter(parameter);
            this.checkForMissortedModifiers((PsiModifierListOwner)parameter);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/MissortedModifiersInspection$MissortedModifiersVisitor.visitMethod must not be null");
            }
            super.visitMethod(method);
            this.checkForMissortedModifiers((PsiModifierListOwner)method);
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/MissortedModifiersInspection$MissortedModifiersVisitor.visitField must not be null");
            }
            super.visitField(field);
            this.checkForMissortedModifiers((PsiModifierListOwner)field);
        }

        private void checkForMissortedModifiers(PsiModifierListOwner listOwner) {
            PsiModifierList modifierList = listOwner.getModifierList();
            if (modifierList == null) {
                return;
            }
            if (!this.isModifierListMissorted(modifierList)) {
                return;
            }
            this.registerError((PsiElement)modifierList, new Object[0]);
        }

        private boolean isModifierListMissorted(PsiModifierList modifierList) {
            if (modifierList == null) {
                return false;
            }
            PsiElement[] children = modifierList.getChildren();
            String currentModifier = null;
            for (PsiElement child : children) {
                if (child instanceof PsiJavaToken) {
                    String text = child.getText();
                    if (this.modifierComparator.compare(text, currentModifier) < 0) {
                        return true;
                    }
                    currentModifier = text;
                }
                if (!(child instanceof PsiAnnotation) || !MissortedModifiersInspection.this.m_requireAnnotationsFirst || currentModifier == null) continue;
                return true;
            }
            return false;
        }
    }

    private static class SortModifiersFix
    extends InspectionGadgetsFix {
        private SortModifiersFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("missorted.modifiers.sort.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/MissortedModifiersInspection$SortModifiersFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement[] children;
            PsiModifierList modifierList = (PsiModifierList)descriptor.getPsiElement();
            ArrayList<String> modifiers = new ArrayList<String>();
            for (PsiElement child : children = modifierList.getChildren()) {
                if (child instanceof PsiComment) {
                    PsiComment comment = (PsiComment)child;
                    IElementType tokenType = comment.getTokenType();
                    if (JavaTokenType.END_OF_LINE_COMMENT.equals(tokenType)) {
                        String text = child.getText() + '\n';
                        modifiers.add(text);
                        continue;
                    }
                    modifiers.add(child.getText());
                    continue;
                }
                if (child instanceof PsiJavaToken) {
                    modifiers.add(child.getText());
                    continue;
                }
                if (!(child instanceof PsiAnnotation)) continue;
                modifiers.add(0, child.getText());
            }
            Collections.sort(modifiers, new ModifierComparator());
            StringBuilder buffer = new StringBuilder();
            for (String modifier : modifiers) {
                buffer.append(modifier);
                buffer.append(' ');
            }
            PsiManager manager = modifierList.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            buffer.append("void x() {}");
            String text = buffer.toString();
            PsiMethod method = factory.createMethodFromText(text, (PsiElement)modifierList);
            PsiModifierList newModifierList = method.getModifierList();
            modifierList.replace((PsiElement)newModifierList);
        }
    }
}

