/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToArrayCallWithZeroLengthArrayArgumentInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("to.array.call.with.zero.length.array.argument.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/ToArrayCallWithZeroLengthArrayArgumentInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiExpression argument = (PsiExpression)infos[1];
        String string = InspectionGadgetsBundle.message("to.array.call.with.zero.length.array.argument.problem.descriptor", argument.getText());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/ToArrayCallWithZeroLengthArrayArgumentInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)infos[0];
        String replacementText = ToArrayCallWithZeroLengthArrayArgumentFix.getReplacementText(methodCallExpression);
        if (replacementText == null) {
            return null;
        }
        return new ToArrayCallWithZeroLengthArrayArgumentFix(replacementText);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ToArrayCallWithZeroLengthArrayArgument();
    }

    private static class ToArrayCallWithZeroLengthArrayArgument
    extends BaseInspectionVisitor {
        private ToArrayCallWithZeroLengthArrayArgument() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiMethod method;
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"toArray".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiType type = argument.getType();
            if (!(type instanceof PsiArrayType)) {
                return;
            }
            if (argument instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)argument;
                PsiElement element = referenceExpression.resolve();
                if (!(element instanceof PsiField)) {
                    return;
                }
                PsiField field = (PsiField)element;
                if (!CollectionUtils.isConstantEmptyArray(field)) {
                    return;
                }
            } else if (!ExpressionUtils.isZeroLengthArrayConstruction(argument)) {
                return;
            }
            if ((method = expression.resolveMethod()) == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (!ClassUtils.isSubclass(containingClass, "java.util.Collection")) {
                return;
            }
            this.registerMethodCallError(expression, expression, argument);
        }
    }

    private static class ToArrayCallWithZeroLengthArrayArgumentFix
    extends InspectionGadgetsFix {
        private final String replacementText;

        ToArrayCallWithZeroLengthArrayArgumentFix(@NotNull String replacementText) {
            if (replacementText == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/ToArrayCallWithZeroLengthArrayArgumentInspection$ToArrayCallWithZeroLengthArrayArgumentFix.<init> must not be null");
            }
            this.replacementText = replacementText;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("to.array.call.with.zero.length.array.argument.quickfix", this.replacementText);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/ToArrayCallWithZeroLengthArrayArgumentInspection$ToArrayCallWithZeroLengthArrayArgumentFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            ToArrayCallWithZeroLengthArrayArgumentFix.replaceExpression((PsiExpression)methodCallExpression, this.replacementText);
        }

        @Nullable
        public static String getReplacementText(PsiMethodCallExpression expression) {
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return null;
            }
            PsiExpression argument = arguments[0];
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return null;
            }
            String qualifierText = qualifier.getText();
            if (argument instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)argument;
                PsiExpression[] dimensions = newExpression.getArrayDimensions();
                if (dimensions.length != 1) {
                    return null;
                }
                PsiExpression dimension = dimensions[0];
                String replacementText = qualifierText + ".size()";
                return ToArrayCallWithZeroLengthArrayArgumentFix.getElementText((PsiElement)expression, (PsiElement)dimension, replacementText);
            }
            if (argument instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)argument;
                PsiArrayType type = (PsiArrayType)referenceExpression.getType();
                if (type == null) {
                    return null;
                }
                PsiType componentType = type.getComponentType();
                String typeText = componentType.getCanonicalText();
                String replacementText = "new " + typeText + "[" + qualifierText + ".size()]";
                return ToArrayCallWithZeroLengthArrayArgumentFix.getElementText((PsiElement)expression, (PsiElement)referenceExpression, replacementText);
            }
            return null;
        }
    }
}

