/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionFromCatchWhichDoesntWrapInspection
extends BaseInspection {
    public boolean ignoreGetMessage = false;

    @NotNull
    public String getID() {
        if ("ThrowInsideCatchBlockWhichIgnoresCaughtException" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/ExceptionFromCatchWhichDoesntWrapInspection.getID must not return null");
        }
        return "ThrowInsideCatchBlockWhichIgnoresCaughtException";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("exception.from.catch.which.doesnt.wrap.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/ExceptionFromCatchWhichDoesntWrapInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("exception.from.catch.which.doesnt.wrap.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/ExceptionFromCatchWhichDoesntWrapInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("exception.from.catch.which.doesntwrap.ignore.option", new Object[0]), (InspectionProfileEntry)this, "ignoreGetMessage");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExceptionFromCatchWhichDoesntWrapVisitor();
    }

    private class ExceptionFromCatchWhichDoesntWrapVisitor
    extends BaseInspectionVisitor {
        private ExceptionFromCatchWhichDoesntWrapVisitor() {
        }

        public void visitThrowStatement(PsiThrowStatement statement) {
            super.visitThrowStatement(statement);
            if (!ControlFlowUtils.isInCatchBlock((PsiElement)statement)) {
                return;
            }
            PsiExpression exception = statement.getException();
            if (!(exception instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)exception;
            PsiMethod constructor = newExpression.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (this.argumentsContainsCatchParameter(arguments)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        private boolean argumentsContainsCatchParameter(PsiExpression[] arguments) {
            for (PsiExpression argument : arguments) {
                PsiParameter parameter;
                PsiElement declarationScope;
                PsiReferenceExpression referenceExpression;
                if (!(argument instanceof PsiReferenceExpression)) {
                    PsiMethodCallExpression methodCallExpression;
                    PsiReferenceExpression methodExpression;
                    PsiExpression expression;
                    if (!ExceptionFromCatchWhichDoesntWrapInspection.this.ignoreGetMessage || !(argument instanceof PsiMethodCallExpression) || (expression = (methodExpression = (methodCallExpression = (PsiMethodCallExpression)argument).getMethodExpression()).getQualifierExpression()) == null || !(expression instanceof PsiReferenceExpression)) continue;
                    referenceExpression = (PsiReferenceExpression)expression;
                } else {
                    referenceExpression = (PsiReferenceExpression)argument;
                }
                PsiElement referent = referenceExpression.resolve();
                if (!(referent instanceof PsiParameter) || !((declarationScope = (parameter = (PsiParameter)referent).getDeclarationScope()) instanceof PsiCatchSection)) continue;
                return true;
            }
            return false;
        }
    }
}

